<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$form_style = [
	'--cms-form-field-padding-end:60px',
	'--cms-form-field-height:58px'
];
?>
<form method="get" class="woocommerce-product-search cms-wgsearch-form relative" action="<?php echo esc_url( home_url( '/' ) ); ?>" style="<?php echo implode(';', $form_style); ?>">
	<input type="search" id="woocommerce-product-search-field-<?php echo isset( $index ) ? absint( $index ) : 0; ?>" class="woocommerce-product-search-field cms-wgsearch-field w-100" placeholder="<?php echo esc_attr__( 'Search products&hellip;', 'finanzia' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	<button type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'finanzia' ); ?>" class="cms-wgsearch-submit text-16 text-accent absolute top-right h-100">
		<svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M502.24 457.152L402.912 357.632C430.88 320.256 447.648 273.984 447.648 223.712C447.648 100 347.456 -0.320007 223.872 -0.320007C100.256 -0.320007 0.0639954 100 0.0639954 223.712C0.0639954 347.36 100.256 447.68 223.872 447.68C274.112 447.68 320.32 430.848 357.696 402.88L457.024 502.336C463.264 508.544 471.456 511.68 479.648 511.68C487.84 511.68 496.032 508.544 502.24 502.336C514.688 489.92 514.688 469.504 502.24 457.152ZM64 223.712C64 135.488 135.712 63.68 223.872 63.68C312 63.68 383.68 135.488 383.68 223.712C383.68 311.84 312 383.68 223.872 383.68C135.712 383.68 64 311.84 64 223.712Z"/></svg>
	</button>
	<input type="hidden" name="post_type" value="product" />
</form>