<?php
/**
 * Template part for displaying default header layout
 */
?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes(); ?>">
        <?php finanzia_header_top(); ?>
        <div class="<?php echo finanzia_header_container_classes('d-flex gap-30 justify-content-between'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding site-header-item flex-auto d-flex justify-content-start">',
                'after'  => '</div>',
            ]);
            // Navigation 
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation site-navigation-dropdown flex-basic d-flex justify-content-end">', 
                'after'  => '</nav>'
            ]);
            ?>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'flex-auto d-flex justify-content-end gap-40 gap-mobile-menu-20 max-h']); ?>" style="--max-h:var(--cms-header-height);">
                <?php
                // Phone
                finanzia_header_phone_render();
                // Mail
                finanzia_header_mail_render(['class' => 'menu-color cms-hover-underline font-700']);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="site-header-item site-header-language font-700">',
                    'after'  => '</div>'
                ]);
                // Login
                finanzia_header_login();
                // Search icon
                finanzia_header_search([
                    'text' => ''
                ]);
                // Wishlist
                finanzia_header_wishlist();
                // Compare
                finanzia_header_compare();
                // Cart icon
                finanzia_header_cart();
                // Side Nav
                finanzia_header_side_nav_render();
                // Mobile menu
                finanzia_open_mobile_menu([
                    'text'         => '<span class="cms-hidden-mobile-menu text-15 font-700">'.esc_html('Menu','finanzia').'</span>',
                    'hide_desktop' => false,
                    'class'        => 'site-header-item d-flex gap-20'
                ]);
                // Button 01
                finanzia_header_button_render([
                    'class'      => 'h-btn1 btn-menu-mobile bg-accent text-white bg-hover-accent-darken text-hover-white text-15 font-700 p-tb-40 p-tb-smobile-20 p-lr-22 mt-20 mt-mobile-menu-0 d-flex align-items-center justify-content-center align-self-center',
                    'data'       => [
                        'default'     => 'bg-accent--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'bg-white--text-accent' : 'bg-accent--text-white'
                    ],
                    'icon'        => '',
                    'icon_mobile' => 'core/email',
                    'icon_size'   => '17'
                ]);
                // Button 02
                finanzia_header_button_render([
                    'name'       => 'h_btn2',
                    'class'      => 'h-btn2 btn-menu-mobile bg-primary text-white bg-hover-accent text-hover-white text-15 font-700 p-tb-40 p-tb-smobile-20 p-lr-22 mt-20 mt-mobile-menu-0 d-flex align-items-center justify-content-center align-self-center',
                    'data'       => [
                        'default'     => 'bg-primary--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'bg-white--text-primary' : 'bg-primary--text-white'
                    ],
                    'icon'        => '',
                    'icon_mobile' => 'core/arrow-right'  
                ]);
                // Social
                finanzia_header_social_render([
                    'before' => '<div class="site-header-social d-flex gapX-20 p-lr-50 p-lr-mobile-menu-20 cms-header-height bdr-b-1 bdr-divider cms-hidden-mobile-menu">',
                    'after'  => '</div>'
                ]);
                ?>
            </div>
        </div>
    </div>
</header>