<?php
/**
 * Template part for displaying default header layout
 */
// Side Nav Desktop
ob_start();
    finanzia_header_side_nav_render([
        'class' => 'cms-hidden-mobile-menu'
    ]);
$side_nav_desktop = ob_get_clean();
?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes(); ?>">
        <?php finanzia_header_top(); ?>
        <div class="<?php echo finanzia_header_container_classes('d-flex justify-content-between'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding flex-auto d-flex justify-content-start p-lr-50 p-lr-mobile-menu-20 bdr-r-1 bdr-divider">',
                'after'  => '</div>',
            ]);
            ?>
            <div class="flex-basic">
                <div class="d-flex justify-content-between cms-hidden-mobile-menu bdr-b-1 bdr-divider cms-header-height">
                    <?php 
                        // Search
                        finanzia_header_search_plain(['class' => 'col-6 col-smobile-12']);
                        // Phone
                        finanzia_header_phone_render3(['class' => 'col-6 col-smobile-12 d-flex justify-content-center bdr-l-1 bdr-divider']);
                    ?>
                </div>
                <?php
                // Navigation 
                get_template_part('template-parts/header/header-menu', '',[
                    'before' => '<nav class="site-navigation site-navigation-dropdown justify-content-between d-flex gap-30 p-lr-40 p-lr-mobile-menu-0">', 
                    'after'  => $side_nav_desktop.'</nav>' 
                ]);
                ?>
            </div>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'flex-auto bdr-l-1 bdr-divider']); ?>">
                <?php
                // Social
                finanzia_header_social_render([
                    'before' => '<div class="site-header-social d-flex gapX-20 p-lr-50 p-lr-mobile-menu-20 cms-header-height bdr-b-1 bdr-divider cms-hidden-mobile-menu">',
                    'after'  => '</div>',
                    'item_class' => 'text-accent'
                ]);
                ?>
                <div class="p-lr-50 p-lr-mobile-menu-20 cms-header-height d-flex gap-20 align-items-center"><?php
                // Phone
                finanzia_header_phone_render3([
                    'class' => 'cms-hidden-desktop-menu'
                ]);
                // Mail
                finanzia_header_mail_render(['class' => 'menu-color cms-hover-underline font-700']);
                // Login
                finanzia_header_login();
                // Search icon
                finanzia_header_search([
                    'class' => 'cms-hidden-desktop-menu'
                ]);
                // Wishlist
                finanzia_header_wishlist();
                // Compare
                finanzia_header_compare();
                // Cart icon
                finanzia_header_cart([
                    'class' => ''
                ]);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="site-header-item site-header-language font-700">',
                    'after'  => '</div>'
                ]);
                // Side Nav
                finanzia_header_side_nav_render(['class' => 'cms-hidden-desktop-menu']);
                // Button 01
                finanzia_header_button_render([
                    'class'      => 'h-btn1 btn-menu-mobile cms-hover-move-icon-right btn btn-smd btn-accent text-white btn-hover-accent-darken text-hover-white w-100 justify-content-between',
                    'data'       => [
                        'default'     => 'btn-accent--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-accent--text-white' : 'btn-accent--text-white'
                    ],
                    'icon'        => 'core/long-arrow-right',
                    'icon_size'   => 17,  
                    'icon_mobile' => ''
                ]);
                // Button 02
                finanzia_header_button_render([
                    'name'       => 'h_btn2',
                    'class'      => 'h-btn2 btn-menu-mobile cms-hover-move-icon-right btn btn-smd btn-primary text-white btn-hover-accent text-hover-white w-100 justify-content-between',
                    'data'       => [
                        'default'     => 'btn-primary--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary' : 'btn-primary--text-white'
                    ],
                    'icon'        => 'core/long-arrow-right',
                    'icon_size'   => 17,  
                    'icon_mobile' => ''  
                ]);
                // Mobile menu
                finanzia_open_mobile_menu();
                ?></div>
            </div>
        </div>
    </div>
</header>