<?php
/**
 * Template part for displaying posts in loop
 *
 * @package 
 */
if(has_post_thumbnail()){
	$show_cat_meta = false;
	$show_cat_meta_thumb = (bool) finanzia_get_opt('archive_date_on', true);
	ob_start();
	?>
		<div class="tag-thumb post-tag absolute top-left mt-20 ml-20 d-flex gap-5 text-13"><?php finanzia_the_terms(get_the_ID(), 'post_tag', '', 'tag-thumb-link cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10'); ?></div>
	<?php
	$thumbnail_cat = ob_get_clean();
	$thumbnail_content = '';
	if($show_cat_meta_thumb){
		$thumbnail_content = $thumbnail_cat;
	}
} else {
	$show_cat_meta = (bool) finanzia_get_opt('archive_cat_on', true);
	$thumbnail_content = '';
}
?>
<article <?php post_class('cms-blog cms-shadow-1 cms-hover-shadow-2 cms-transition'); ?>>
	<?php
		finanzia_entry_thumbnail([
			'size'      => 'large',
			'class'     => '',
			'img_class' => 'bg-accent',
			'content'	=> $thumbnail_content
		]);
	?>
	<div class="cms--blog p-40 p-lr-smobile-20"><?php 
		// Post Content	
		finanzia_post_meta([
			'class'          => 'cms-archive-meta gap-10 pb-15 m-tb-n5 pb-20 text-13',
			'separator'      => '<span class="separator"></span>',
			//'show_cat'       => $show_cat_meta,
			'cat_class'      => '',
			'cat_link_class' => '',
			'link_class'	 => 'cms-hover-underline text-accent'
		]);
		finanzia_entry_title([
			'class' => 'text-accent pb-23 mb-23 mt-n7 bdr-b-1 bdr-divider'
		]);
		finanzia_entry_excerpt(['class' => 'text-line-4 pt-2']);
		finanzia_entry_link_pages();
		finanzia_entry_readmore();
	?></div>
</article>