<?php
/**
 * Template part for displaying posts in loop
 *
 * @package 
 */
if(has_post_thumbnail()){
	$show_cat_meta = false;
	$show_cat_meta_thumb = (bool) finanzia_get_opt('archive_date_on', true);
	ob_start();
	?>
		<div class="tag-thumb post-tag absolute top-left mt-20 ml-20 d-flex gap-5 text-13"><?php finanzia_the_terms(get_the_ID(), 'post_tag', '', 'tag-thumb-link cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10'); ?></div>
	<?php
	$thumbnail_cat = ob_get_clean();
	$thumbnail_content = '';
	if($show_cat_meta_thumb){
		$thumbnail_content = $thumbnail_cat;
	}
} else {
	$show_cat_meta = (bool) finanzia_get_opt('archive_cat_on', true);
	$thumbnail_content = '';
}
?> 
<div class="cms-single cms-shadow-1 cms-hover-shadow-2 cms-transition">
	<?php 
		finanzia_entry_thumbnail([
			'size'      => 'large',
			'class'     => '',
			'img_class' => 'bg-accent',
			'content'	=> $thumbnail_content
		]);
	?>
	<div class="cms--single p-40 p-lr-smobile-20"><?php 
		// Post Content
		finanzia_post_meta([
			'opt_prefix'     => 'post_',
			'gap'            => '',
			'class'          => 'gap-10 pb-15 mt-n5 text-13',
			'separator'      => '<span class="separator"></span>',
			//'show_cat'       => $show_cat_meta,
			'cat_class'		 => '',
			'cat_link_class' => '',
			'link_class'     => 'text-accent text-hover-accent-darken' 		
		]);
		finanzia_entry_single_title(['class' => 'pb-23 mb-23 mt-n7 bdr-b-1 bdr-divider']);
		?>
		<div class="content clearfix mb-n7"><?php 
			the_content(); 
			finanzia_entry_link_pages();
		?></div>
		<div class="tags-share d-flex justify-content-between gap-30 empty-none mt-40 pt-40 bdr-t-1 bdr-divider"><?php 
			finanzia_entry_tagged_in([
				'class' => 'flex-basic flex-mobile-full',
				'title' => '',
			]);
			finanzia_socials_share_default([
				'title'       => '<div class="text-15">'.esc_html__('Share', 'finanzia').'</div>',
				'class'       => 'flex-auto flex-mobile-full d-flex gap-20',
				'inner_class' => 'cms-social-share',
				'show'        => (bool)finanzia_get_opt('post_social_share_on', false),
				'icon_size'   => 20,
				'icon_class'  => 'cms-hover-zoomout text-accent'
			]); 
		?></div>
	</div>
</div>
<?php
// Post Nav
	finanzia_post_nav_default([
		'class' => 'text-15 pt-35 mb-n5 text-accent'
	]);
// About Author
if(!empty(get_the_author_meta( 'description' )) && finanzia_get_opt('post_author_info_on', false)){
?>
<div class="cms-author-info bg-grey d-flex gap-30 gap-mobile-20 justify-content-mobile-center text-mobile-center mt-40 p-50 p-lr-smobile-20">
    <div class="author-avatar flex-auto">
		<?php echo get_avatar( get_the_author_meta( 'ID' ), 120, '', '', ['class' => '']); ?>
    </div>
    <div class="author-desc flex-basic flex-mobile-full d-flex flex-column justify-content-between">
    	<h4 class="author-name cms-heading text-21 mt-n5 text-accent"><?php the_author_meta( 'display_name' ); ?></h4>
		<div class="author-bio text-15 pt-10"><?php  the_author_meta( 'description' ); ?></div>
		<?php
			// User Social
			finanzia_get_user_social(['class' => 'pt-15 cms-social-share text-white', 'icon_class' => 'cms-hover-zoomout text-accent']); 
		?>
    </div>
</div>
<?php 
	}
?>