<?php
/**
 * Search Form
 * 
 * @package CMS Theme
 * @subpackage Finanzia
 * 
 */
$form_style = [
    '--cms-form-field-height:68px',
    '--cms-form-field-radius:35px'
];
?>
<form role="search" method="get" class="<?php echo esc_attr($args['class']); ?>" action="<?php echo esc_url( home_url( '/' ) ); ?>" style="<?php echo implode(';', $form_style); ?>">
    <input type="text" name="s" class="<?php echo esc_attr($args['field_class']) ?>" placeholder="<?php echo esc_attr( $args['placeholder'] );?>"/>
    <button type="submit" class="<?php echo esc_attr($args['btn_class']); ?>" data-title="<?php echo esc_attr($args['btn_text']) ?>"><?php printf('%s', $args['btn_icon']); ?></button>
</form>