<?php
/**
 * Custom template tags for this theme.
 *
 * @package CMS Theme
 * @subpackage Finanzia
 * 
 */
/**
 * Theme File
 * */
function finanzia_theme_file_uri(){
    if(is_child_theme()){
        return get_parent_theme_file_uri() ;
    } else {
        return get_theme_file_uri();
    }
}
/**
 * SVG Icons
 * 
*/
function finanzia_svgs_icon($args = []){
    $args = wp_parse_args($args, [
        'icon'       => 'core/arrow-next',
        'icon_class' => 'cms-eicon',
        'icon_size'  => '', 
        'class'      => '',
        'before'     => '',
        'after'      => '',
        'tag'        => 'span',
        'echo'       => true,
        'rtl'        => true,
        'attrs'      => [],
        'before_icon' => '',
        'after_icon'  => ''
    ]);
    if(empty($args['icon'])) return;
    //
    $icon_classes = ['cms-svg-icon lh-0', $args['icon_class'], $args['class']];
    if($args['rtl']) $icon_classes[] = 'rtl-flip empty-none';
    // attributes
    if(isset($args['attrs']['style'])){
        $args['attrs']['style'] .= ';--svg-size:'.$args['icon_size'].'px;';
    } else {
        $args['attrs']['style'] = '--svg-size:'.$args['icon_size'].'px;';
    }
    $icon_attrs = array_merge(
        [
            'class' => finanzia_nice_class($icon_classes)
        ],
        $args['attrs']
    );
    // icon html
    ob_start();
        if(is_child_theme()){
            include get_template_directory() . '/assets/svgs/'.$args['icon'].'.svg';
        } else {
            include get_template_directory() . '/assets/svgs/'.$args['icon'].'.svg';
        }
    $icon_html = ob_get_clean();
    // html
    ob_start();
        printf('%s', $args['before']);
            printf('%1$s%2$s%3$s%4$s%5$s','<'.$args['tag'].' '.finanzia_render_attrs($icon_attrs).'>',$args['before_icon'],$icon_html,$args['after_icon'], '</'.$args['tag'].'>');
        printf('%s', $args['after']);
    if($args['echo']){
        echo ob_get_clean();
    } else {
        return ob_get_clean();
    }
}
/**
 * Leading Zero
 * */
function finanzia_leading_zero($number, $before = '', $after = ''){
    printf('%1$s%2$s%3$s', $before, zeroise( $number, 2 ), $after);
}
/**
 * Check is Blog page
 * 
*/
if(!function_exists('cms_is_blog')){
    function cms_is_blog(){
        if(is_home() || is_archive() || is_category() || is_tag() || is_author() || is_date() || is_post_type_archive() || is_tax() || is_search() ){
            return true;
        } else {
            return false;
        }
    }
}

/**
 * Body CSS class
 * 
 */
add_filter('body_class', 'finanzia_body_classes');
function finanzia_body_classes($classes){
    global $wp_query;
    $page = $wp_query->get( 'page' );
    if ( ! $page || $page < 2 ) {
        $page = $wp_query->get( 'paged' );
    }
    // Header Top
    $header_top_layout = finanzia_get_opts('header_top_layout', '', 'header_top_custom');
    if(!in_array($header_top_layout, ['-1', '0', 'none', ''])){
        $classes[] = 'has-header-top';
    }
    // header layout
    $classes[] = 'cms-header-layout-'.finanzia_get_opts('header_layout', '1', 'header_custom');
    // header transparent
    if(finanzia_get_opts( 'header_transparent', 'off', 'header_custom') === 'on'){
        $classes[] = 'cms-header-transparent';
    }

    // header boxed
    $classes[] = 'cms-header-boxed-'.finanzia_get_opts('header_boxed', 'off', 'header_custom');
    // Custom font
    $classes[] = 'cms-heading-font-'.finanzia_get_opts('heading_font','default');
    // footer
    $footer_fixed = finanzia_get_opts('footer_fixed', 'off', 'footer_custom');
    if($footer_fixed == 'on') $classes[] = 'cms-footer-fixed';
    //
    return $classes;
}

/**
 * Archives Title
 * remove label
 * */
add_filter('get_the_archive_title', 'finanzia_archive_title_remove_label');
function finanzia_archive_title_remove_label($title){
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_author()) {
        $title = get_the_author();
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    } elseif (is_tax()) {
        $title = single_term_title('', false);
    } elseif (is_home()) {
        $title = single_post_title('', false);
    }
    return $title;
}
/**
 * Page loading.
 * 
 **/
function finanzia_page_loading(){
    $page_loading = finanzia_get_opt('show_page_loading', false);
    if ($page_loading) { ?>
        <section id="cms-loadding" class="cms-loader">
            <div class="loading-spinner">
                <div class="cms-bounce1"></div>
                <div class="cms-bounce2"></div>
                <div class="cms-bounce3"></div>
            </div>
        </section>
    <?php }
}
/**
 * Header Top
 * 
 * **/
if(!function_exists('finanzia_header_top')){
    function finanzia_header_top($args = []){
        if( (!class_exists('Elementor_Theme_Core') && !class_exists('\Elementor\Plugin')) || is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu')) return;
        $args = wp_parse_args($args, [
            'id'    => 'cms-header-top',
            'class' => ''
        ]);
        $header_top_layout = finanzia_get_opts('header_top_layout', '', 'header_top_custom');
        if(in_array($header_top_layout, ['-1', '0', 'none', ''])) return;

        $cms_post = get_post($header_top_layout);

        if (!is_wp_error($cms_post) && $cms_post->ID == $header_top_layout){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $header_top_layout );
            if(empty($content)){
                $content = $cms_post->post_content;
            }
        } else {
            $content = $cms_post->post_content;
        }
        if(empty($content)) return;
        // Classes 
        $classes = ['cms-header-top', $args['class'], $cms_post->post_name];
    ?>
    <div id="<?php echo esc_attr($args['id']);?>" class="<?php echo finanzia_nice_class($classes); ?>"><?php 
        etc_print_html($content);
    ?></div>
    <?php
    }
}
/**
 * Header layout.
 **/
function finanzia_header_layout(){
    $header_layout = finanzia_get_opts('header_layout', '1', 'header_custom');
    if ($header_layout == '0' || is_singular('cms-header-top') || is_singular('cms-footer') || is_singular('cms-mega-menu')) return;
    get_template_part('template-parts/header/header-layout', $header_layout);
}

/**
 * Header
 * Header Wrap Classes
 * 
 * */
if(!function_exists('finanzia_header_wrap_classes')){
    function finanzia_header_wrap_classes($class = ''){
        $classes = [
            'site-header',
            (finanzia_get_opts( 'header_boxed', 'off', 'header_custom') == 'on') ? 'header-boxed' : ''
        ];
        return finanzia_nice_class($classes);
    }
}
/**
 * Header
 * Header Class
 * **/
if(!function_exists('finanzia_header_classes')){
    function finanzia_header_classes($class = ''){
        $classes = [
            'cms-header',
            'header-layout-'.finanzia_get_opts('header_layout','1', 'header_custom'),
            'sticky-'.finanzia_get_opts( 'header_sticky', 'off', 'header_custom'),
            'sticky-'.finanzia_get_opts( 'header_sticky_mode', 'off', 'header_sticky'),
            'transparent-'.finanzia_get_opts( 'header_transparent', 'off', 'header_custom'),
            $class
        ];
        if(finanzia_get_opts( 'header_shadow', 'on', 'header_custom') === 'on'){
            $classes[] = 'header-shadow';
        }
        if(finanzia_get_opts( 'header_transparent', 'off', 'header_custom') === 'on'){
            $classes[] = 'header-transparent';
        }
        if(finanzia_get_opts( 'header_divider', 'off', 'header_custom') === 'on'){
            $classes[] = 'header-divider';
        }
        return implode(' ', array_filter($classes));
    }
}
/**
 * Header Container class 
 * 
 * **/
if(!function_exists('finanzia_header_container_classes')){
    function finanzia_header_container_classes($class = ''){
        $classes = [
            'cms-header-main',
            finanzia_get_opts( 'header_width', 'container', 'header_custom'),
            $class
        ];
        return implode(' ', array_filter($classes));
    }
}
/**
 * Header Search 
 * 
 * */
if(!function_exists('finanzia_header_search')){
    function finanzia_header_search($args = []){
        $args = wp_parse_args($args, [
            'class'       => 'site-header-item menu-color',
            'echo'        => true,
            'icon'        => 'core/search',
            'icon_size'   => 20,
            'icon_class'  => '',  
            'text'        => '',
            'modal-mode'  => 'slide', // fade, slide
            'modal-slide' => 'top', // top, right, bottom, left, center, zoom-in, zoom-out
            'modal-class' => '',
            'modal-width' => '100vw',
            'modal-space' => 0,
            'placeholder' => '',
            'before'      => '',
            'after'       => ''  
        ]);
        $search_on = finanzia_get_opts('search_icon', 'off', 'header_custom');
        if($search_on != 'on') return;
        add_action('wp_footer', 'finanzia_search_popup');
        $classes = ['site-header-search cms-modal d-flex gap-10 align-items-center lh-1', $args['class']];
        $icon_classes = ['header-icon search-toggle', 'text-'.$args['icon_size'], $args['icon_class']];
        // Search icon 
        $search_icon = finanzia_svgs_icon([
            'icon'  => $args['icon'],
            'class' => finanzia_nice_class($icon_classes),
            'echo'  => false
        ]);
    ob_start();
    printf('%s', $args['before']);
?>
    <div class="<?php echo implode(' ', array_filter($classes)); ?>" data-modal="#cms-modal-search" data-focus=".cms-search-field" data-modal-mode="<?php echo esc_attr($args['modal-mode']); ?>" data-modal-slide="<?php echo esc_attr($args['modal-slide']); ?>" data-modal-class="<?php echo esc_attr($args['modal-class']); ?>" <?php if(!empty($args['placeholder'])): ?>data-modal-placeholder="<?php echo esc_attr($args['placeholder']); ?>"<?php endif; ?> data-modal-width="<?php echo esc_attr($args['modal-width']) ?>" data-modal-space="<?php echo esc_attr($args['modal-space']); ?>"><?php  
            printf('%1$s%2$s', $search_icon, $args['text']); 
        ?></div>
<?php
    printf('%s', $args['after']);
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Header Search Popup
 */
function finanzia_search_popup($args = []){
    $args = wp_parse_args($args, [
        'text'        => '', //'<span class="close-text text-15">'.esc_html__('Close','finanzia').'</span>',
        'icon'        => get_template_directory() . '/assets/svgs/close.svg',
        'placeholder' => esc_html__('Search...','finanzia'),
        'btn_class'   => 'cms-header-search-form-btn btn text-20 absolute top-left',
        'btn_text'    => esc_html__('Search','finanzia'),
        'btn_icon'    => get_template_directory() . '/assets/svgs/core/search.svg',
    ]); 
    $placeholder               = finanzia_get_opt('search_field_placeholder', esc_html__('Search', 'finanzia'));
    $search_on                 = finanzia_get_opts( 'search_icon', 'no' ); 
    $search_on_content         = finanzia_get_opts('search_on_content', '_1');
    $search_on_content_content = finanzia_get_opts('search_on_content_content', '_1');
    if($search_on == 'no') return;

    $wraps_classes     = ['cms-modal-html cms-modal-search', 'cms-transition', 'bg-white', 'd-flex flex-nowrap justify-content-between gap-20 flex-nowrap'];
    if($search_on_content != 'custom'){
        $container_classes[] = 'container';
    } else {
        $wraps_classes[] = 'cms-mousewheel';
    }
    // Close icon 
    ob_start();
        echo '<span class="text-accent text-hover-red text-16 lh-0 box-40">';
        include $args['icon'];
        echo '</span>';
    $close_icon = ob_get_clean();
    // Search Form
    $header_searform_style = [
        '--cms-form-field-height:40px',
        '--cms-form-field-border:none',
        '--cms-form-field-radius:none',
        '--cms-form-field-border-width:0 0 1px 0',
        '--cms-form-field-border-color:var(--cms-accent)',
        '--cms-form-field-border-style:solid',
        '--cms-form-field-border-hover:none',
        '--cms-form-field-padding-start:30px',
        '--cms-placeholder-color:var(--cms-accent)',
        '--cms-placeholder-weight:400',
        // button
        '--cms-btn-padding:0',
        '--cms-form-btn-height:40px',
        '--cms-form-btn-color:var(--cms-accent)',
        '--cms-form-btn-bg:none',
        '--cms-form-btn-bg-hover:hover',
        '--cms-form-btn-text-color:var(--cms-accent-darken)',
        '--cms-form-btn-text-color-hover:var(--cms-accent-darken)',
        //
        '--max-w:400px;'
    ];
    ob_start();
    ?>
        <form method="get" class="cms-header-search-form d-flex align-items-center max-w relative" action="<?php echo esc_url( home_url( '/' ) ); ?>" style="<?php echo implode(';', $header_searform_style); ?>">
            <button type="submit" class="<?php echo esc_attr($args['btn_class']); ?>" data-title="<?php echo esc_attr($args['btn_text']) ?>"><?php include($args['btn_icon']); ?></button>
            <input type="text" name="s" class="cms-search-field" placeholder="<?php echo esc_attr( $args['placeholder'] );?>"/>
        </form>
    <?php $search_form = ob_get_clean(); ?>
    <div id="cms-modal-search" class="<?php echo finanzia_nice_class($wraps_classes); ?>">
        <div class="cms-modal--content">
            <?php switch ($search_on_content) {
                case 'custom':
                    if(class_exists('\Elementor\Plugin') && !empty($search_on_content_content)){
                        printf('%s', \Elementor\Plugin::$instance->frontend->get_builder_content( $search_on_content_content )); 
                    } else {
                        printf('%s', $search_form);
                    }
                break;
                default : 
                    printf('%s', $search_form);
                break;
            } ?>
        </div>
        <span class="cms-modal--close cms-close">
            <?php 
                // text
                printf('%1$s%2$s',$args['text'], $close_icon);
            ?>
        </span>
    </div>
<?php }
/**
 * Header Search Plain
 * 
 * */
if(!function_exists('finanzia_header_search_plain')){
    function finanzia_header_search_plain($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $form_style = [
            '--cms-form-field-height:calc(var(--cms-header-height) - 1px)',
            '--cms-form-field-radius:0',
            '--cms-form-field-border-width:0',
            '--cms-form-field-border:none',
            '--cms-form-field-border-hover:none',
            '--cms-form-field-padding-start:60px',
            '--cms-form-btn-height:80px',
            '--cms-btn-padding:0',
            '--cms-form-btn-color:var(--cms-body-color)',
            '--cms-form-btn-bg:transparent',
            '--cms-form-btn-color-hover:var(--cms-body-color)',
            '--cms-form-btn-bg-hover:transparent',
        ];
    $classes = finanzia_nice_class([
        'cms-search-plain relative',
        $args['class']
    ]);
?>
    <form method="get" class="<?php echo esc_attr($classes); ?>" action="<?php echo esc_url( home_url( '/' ) ); ?>" style="<?php echo implode(';', $form_style); ?>">
        <input type="text" name="s" class="cms-search-plain-input" placeholder="<?php echo esc_attr__('Search','finanzia');?>"/>
        <button type="submit" class="cms-search-plain-btn btn absolute top-left box-80" data-title="<?php echo esc_attr__('Search','finanzia');?>"><?php
            finanzia_svgs_icon([
                'icon' => 'core/search',
                'class' => 'text-20'
            ]);
        ?></button>
    </form>
<?php
    }
}
/**
 * Header Cart
 * 
 * */
if(!function_exists('finanzia_header_cart')){
    function finanzia_header_cart($args = []){
        $args = wp_parse_args($args, [
            'layout'    => '1', 
            'class'     => 'menu-color',
            'echo'      => true,
            'icon'      => 'core/cart-box',
            'icon_size' => 20,
            'icon_class' => '',
            'text'      => '', 
            'position'  => 'dropdown', // dropdown, modal
            'offset'    => '-40'
        ]);
        $cart_on = finanzia_get_opts('cart_icon', 'off', 'header_custom');
        // fix show cart icon on single product page without theme option
        if(is_singular('product')) $cart_on = 'on';
        //
        if(!class_exists('Woocommerce') || $cart_on != 'on') return;
        $classes  =['site-header-item site-header-cart lh-1', $args['class']];

        switch ($args['position']) {
            case 'modal':
                $classes[] = 'cms-modal';
                add_action('wp_footer', 'finanzia_cart_content');
                break;
            
            default:
                $classes[] = 'relative cms-touchedside';
                add_action('finanzia_cart_dropdown', 'finanzia_cart_content_dropdown');
                break;
        }
        $icon_classes = ['header-icon cart-icon', 'text-'.$args['icon_size'], $args['icon_class']];
        $cart_counter_classes = ['cart-counter cart_total cms-count'];
        
        $cart_icon = finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
    ob_start();
?>
    <div class="<?php  echo implode(' ', array_filter($classes)); ?>" data-dropdown-offset="<?php echo esc_attr($args['offset']) ?>" data-modal="#cms-modal-cart" data-modal-mode="slide" data-modal-slide="right" data-modal-class="bg-white">
        <?php 
        switch ($args['layout']) {
            case '1':
                printf('%s', $args['text']); 
            ?>
                <div class="cms-cart-icon cms-counter-icon relative">
                    <?php printf('%s', $cart_icon); ?>
                    <span class="<?php echo finanzia_nice_class($cart_counter_classes); ?>" data-count="<?php echo WC()->cart->cart_contents_count; ?>">
                        <span class="text--mixed"><?php 
                            echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'finanzia' ), WC()->cart->cart_contents_count ); 
                        ?></span>
                    </span>
                </div>
            <?php
                break;
            case '2':
                printf('%1$s%2$s', $cart_icon, $args['text']);
            ?>
                <span class="">(<span class="<?php echo finanzia_nice_class($cart_counter_classes); ?>" data-count="<?php echo WC()->cart->cart_contents_count; ?>"><span class="text-mixed"><?php 
                        echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'finanzia' ), WC()->cart->cart_contents_count ); 
                ?></span></span>)</span>
            <?php
                break;
        }
        ?>
        <?php do_action('finanzia_cart_dropdown'); ?>
    </div>
<?php
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Header Cart
 * Update cart count
 * 
 * */
if(!function_exists('finanzia_woocommerce_add_to_cart_fragments')){
    add_filter('woocommerce_add_to_cart_fragments', 'finanzia_woocommerce_add_to_cart_fragments', 10, 1 );
    function finanzia_woocommerce_add_to_cart_fragments( $fragments ) {
        if(!class_exists('WooCommerce')) return;
        ob_start();
        ?><span class="cart-counter cart_total cms-count" data-count="<?php echo WC()->cart->cart_contents_count;?>">
            <span class="text--mixed"><?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'finanzia' ), WC()->cart->cart_contents_count ); ?></span>
        </span>
        <?php
        $fragments['.cart_total'] = ob_get_clean();
        $fragments['.cms-fix-cart-empty'] = '';
        return $fragments;
    }
}

/**
 * 
 * Cart Content
 * 
 */
function finanzia_cart_content(){
    if (!class_exists('Woocommerce')) return;

    ob_start();
        echo '<span class="cms-modal-close cms-close cmsi-remove p-30 p-smobile-20 text-22 lh-0">';
        include get_template_directory() . '/assets/svgs/core/close.svg';
        echo '</span>';
    $close_icon = ob_get_clean();
?>
    <div id="cms-modal-cart" class="cms-modal-html cms-modal-slide cms-modal-cart cms-shadow-1">
        <?php printf('%s', $close_icon); ?>
        <h2 class="cms-cart-title text-30 w-100 p-lr-40 p-lr-mobile-20 pt-25"><?php echo esc_html__('Shopping Cart','finanzia'); ?></h2>
        <div class="cms-modal-content">
            <div class="widget_shopping_cart cms-mousewheel cms-mini-cart-modal">
                <div class="widget_shopping_cart_content">
                    <?php  woocommerce_mini_cart(); ?>
                </div>
            </div>
        </div>
    </div>
<?php
}

function finanzia_cart_content_dropdown(){
    if (!class_exists('Woocommerce')) return;
?>
    <div class="cms-header-cart-dropdown cms--touchedside overflow-hidden">
        <div class="widget_shopping_cart cms-mousewheel">
            <div class="widget_shopping_cart_content"><?php 
                woocommerce_mini_cart(); 
            ?></div>
        </div>
    </div>
<?php
}

/**
 * Header Phone
 * */
if(!function_exists('finanzia_header_phone_render')){
    function finanzia_header_phone_render($args = []){
        $args = wp_parse_args($args, [
            'name'      => '',
            'class'     => 'menu-color',
            'icon'      => 'core/phone',
            'icon_size' => 17,
            'data'      => [
                'default'     => '',
                'transparent' => ''
            ],
            'text_class'  => '',
            'phone_class' => ''
        ]);
        $phone_text = finanzia_get_opt('h_phone'.$args['name'].'_text', '');
        $phone_number = finanzia_get_opt('h_phone'.$args['name'].'_number', '');
        if(finanzia_get_opts('h_phone'.$args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($phone_number) ) return;
        $tel = str_ireplace(' ', '', $phone_number); // remove space for link
        // phone icon
        $icon_classes = ['phone-icon', 'phone-icon-outline', 'ripple', 'text-'.$args['icon_size']];
        $phone_icon = finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
        // 
        $classes = ['site-header-item', 'site-header-phone', 'd-flex gap-10', $args['class']];
    ?>
        <a class="<?php echo finanzia_nice_class($classes); ?>" data-classes='<?php echo wp_json_encode($args['data']); ?>' href="tel:<?php echo esc_attr($tel);?>"><?php 
            if(!empty($args['icon'])) printf('%s', $phone_icon);
            printf('<div class="cms-hidden-mobile-menu lh-1"><div class="phone-number heading font-500 text-20 pb-10 empty-none">%s</div><div class="phone-text text-13">%s</div></div>', $phone_number, $phone_text);
        ?></a>
    <?php
    }
}
/**
 * Header Phone #2
 * */
if(!function_exists('finanzia_header_phone_render2')){
    function finanzia_header_phone_render2($args = []){
        $args = wp_parse_args($args, [
            'name'      => '',
            'class'     => 'menu-color',
            'icon'      => 'core/phone',
            'icon_size' => 17,
            'data'      => [
                'default'     => '',
                'transparent' => ''
            ],
            'text_class'  => '',
            'phone_class' => ''
        ]);
        $phone_text = finanzia_get_opt('h_phone'.$args['name'].'_text', '');
        $phone_number = finanzia_get_opt('h_phone'.$args['name'].'_number', '');
        if(finanzia_get_opts('h_phone'.$args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($phone_number) ) return;
        $tel = str_ireplace(' ', '', $phone_number); // remove space for link
        // phone icon
        $icon_classes = ['phone-icon', 'text-'.$args['icon_size']];
        $phone_icon = finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
        // 
        $classes = ['site-header-item', 'site-header-phone', 'd-flex gap-20', $args['class']];
    ?>
        <a class="<?php echo finanzia_nice_class($classes); ?>" data-classes='<?php echo wp_json_encode($args['data']); ?>' href="tel:<?php echo esc_attr($tel);?>"><?php 
            // icon
            printf('%s', $phone_icon);
            //
            printf('<div class="cms-hidden-mobile-menu lh-1"><div class="phone-text text-13 pb-10 empty-none">%s</div><div class="phone-number heading font-500 text-20 empty-none">%s</div></div>', $phone_text, $phone_number);
        ?></a>
    <?php
    }
}
if(!function_exists('finanzia_header_phone_render3')){
    function finanzia_header_phone_render3($args = []){
        $args = wp_parse_args($args, [
            'name'      => '',
            'class'     => 'menu-color',
            'icon'      => 'phone',
            'icon_mail' => 'core/email',
            'icon_size' => 20,
            'data'      => [
                'default'     => '',
                'transparent' => ''
            ],
            'text_class'  => '',
            'phone_class' => '',
            'phone_text_before' => '<div class="phone-text empty-none">',
            'phone_text_after'  => '</div>'
        ]);
        $phone_number = finanzia_get_opt('h_phone'.$args['name'].'_number', '');

        if(finanzia_get_opts('h_phone'.$args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($phone_number) ) return;
        // phone
        $tel = str_ireplace(' ', '', $phone_number); // remove space for link
        $phone_text = $args['phone_text_before'].finanzia_get_opt('h_phone'.$args['name'].'_text', '').$args['phone_text_after'];        // phone icon
        //$icon_classes = finanzia_nice_class(['phone-icon', 'phone-icon-outline', 'ripple', 'text-'.$args['icon_size']]);
        $icon_classes = finanzia_nice_class(['phone-icon', 'text-'.$args['icon_size']]);
        $phone_icon = finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
        // Email
        $email_text = finanzia_get_opt('h_mail'.$args['name'].'_text', '');
        $mail_icon = finanzia_svgs_icon(['icon' => $args['icon_mail'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
        $mail_classes = finanzia_nice_class(['mail-icon', 'phone-icon-outline','cms-hidden-desktop-menu', 'ripple', 'text-'.$args['icon_size']]);
        // 
        $phone_email_text = !empty($email_text) ? $email_text : $phone_text;
        $classes = ['site-header-item', 'site-header-phone', 'd-flex gap-10', $args['class']];
    ?>
        <div class="<?php echo finanzia_nice_class($classes); ?>" data-classes='<?php echo wp_json_encode($args['data']); ?>'><?php 
            if(!empty($args['icon']) && !empty($tel)) {
                //printf('<a href="tel:%s" class="%s">%s</a>',$tel, $icon_classes, $phone_icon);
                finanzia_svgs_icon([
                    'icon'  => $args['icon'], 
                    'class' => finanzia_nice_class($icon_classes), 
                    'tag'  => 'a',
                    'attrs' => [
                        'href' => 'tel:'.$tel
                    ]
                ]);
            }
            if(!empty($args['icon_mail']) && !empty($email_text)){
                //printf('<a href="mailto:%s" class="%s">%s</a>',$email_text, $mail_classes, $mail_icon);
                finanzia_svgs_icon([
                    'icon'  => $args['icon_mail'], 
                    'class' => finanzia_nice_class($icon_classes).' cms-hidden-desktop-menu', 
                    'tag'  => 'a',
                    'attrs' => [
                        'href' => 'mailto:'.$email_text
                    ]
                ]);
            } 
            ?>
            <div class="cms-hidden-mobile-menu lh-1">
                <?php 
                    // tel
                    if(!empty($tel)) printf('<a href="tel:%1$s" class="phone-number text-13 d-block text-body">%2$s%3$s</a>',$tel, $tel, $phone_text);
                    // text
                    if(!empty($email_text)) printf('<a href="mailto:%s" class="email-text text-13 d-block">%s</a>',$email_text, $email_text);
                ?>
            </div>
        </div>
    <?php
    }
}
/**
 * Header Mail
 * */
if(!function_exists('finanzia_header_mail_render')){
    function finanzia_header_mail_render($args = []){
        $args = wp_parse_args($args, [
            'name'      => '',
            'class'     => '',
            'icon'      => 'core/email',
            'icon_size' => 17
        ]);
        $email_text = finanzia_get_opt('h_mail'.$args['name'].'_text', '');

        if(finanzia_get_opts('h_mail'.$args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($email_text) ) return;

        $classes = ['site-header-item d-flex gap-10 align-items-center','cms-hidden-mobile-menu', $args['class']];
        // mail icon
        $icon_classes = finanzia_nice_class(['site-header-item  mail-icon', 'phone-icon-outline', 'ripple', 'text-'.$args['icon_size']]);
        $mail_icon = finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'echo' => false]);
        $mail_classes = finanzia_nice_class(['site-header-item site-header-phone mail-icon', 'phone-icon-outline','cms-hidden-desktop-menu', 'ripple', 'text-'.$args['icon_size']]);

        if(!empty($args['icon']) && !empty($email_text)){
            printf('<a href="mailto:%s" class="%s">%s</a>',$email_text, $mail_classes, $mail_icon);
        } 
    ?>
        <a class="<?php echo implode(' ', array_filter($classes)); ?>" href="mailto:<?php echo esc_attr($email_text);?>"><?php 
            if(!empty($args['icon'])) printf('%s', $mail_icon);
            printf('%s', $email_text);
        ?></a>
    <?php
    }
}
/**
 * Header Button
 * */
if(!function_exists('finanzia_header_button_render')){
    function finanzia_header_button_render($args = []){
        $args = wp_parse_args($args, [
            'name'        => 'h_btn',
            'class'       => 'btn',
            'icon'        => '',
            'icon_mobile' => '',
            'icon_size'   => 10,
            'data'        => [
                'default'     => '',
                'transparent' => ''
            ],
            'style'  => '',
            'before' => '',
            'after'  => ''
        ]);
        $h_btn_text        = finanzia_get_opt( $args['name'].'_text' );
        if(finanzia_get_opts($args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($h_btn_text)) return;

        $h_btn_link_type   = finanzia_get_opt( $args['name'].'_link_type', 'page' );
        $h_btn_link        = finanzia_get_opt( $args['name'].'_link' );
        $h_btn_link_custom = finanzia_get_opt( $args['name'].'_link_custom' );
        $h_btn_target      = finanzia_get_opt( $args['name'].'_target', '_self' );
        if ( $h_btn_link_type == 'page' ) {
            $h_btn_url = get_permalink( $h_btn_link );
        } else {
            $h_btn_url = $h_btn_link_custom;
        }

        $attrs = [
            'class'        => $args['class'],
            'data-classes' => $args['data'],
            'style'        => $args['style'] 
        ];
        // icon
        $args['icon_mobile'] = !empty($args['icon_mobile']) ? $args['icon_mobile'] : $args['icon'];
        $icon = !empty($args['icon']) ? finanzia_svgs_icon(['icon' => $args['icon'], 'class' => 'cms-hidden-mobile-menu text-'.$args['icon_size'], 'echo' => false]) : '';
        $icon_mobile = !empty($args['icon_mobile']) ? finanzia_svgs_icon(['icon' => $args['icon_mobile'], 'class' => 'cms-hidden-desktop-menu text-'.$args['icon_size'], 'echo' => false]) : '';

        $icons = $icon.$icon_mobile;

        printf('%s', $args['before']);
    ?>
        <a class="h-btn <?php echo esc_attr($attrs['class']); ?> cms-hidden-mobile-menu" data-classes=<?php echo wp_json_encode($args['data']); ?> href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr( $h_btn_target ); ?>" style="<?php echo esc_attr($attrs['style']) ?>">
            <?php printf( '<span class="cms-hidden-mobile-menu">%1$s</span>%2$s', $h_btn_text, $icons ); ?>
            <span class="screen-reader-text"><?php echo esc_html($h_btn_text); ?></span> 
        </a>
    <?php
    printf('%s', $args['after']);
    }
}

/***
 * Header Wishlist
 */
if(!function_exists('finanzia_is_wishlist_page')){
    function finanzia_is_wishlist_page(){
        if(!class_exists('WPCleverWoosw')) {
            return false;
        } else {
            $woosw_settings = wp_parse_args(get_option('woosw_settings'), [
                'page_id' => ''
            ]); 
            $wpcsw_page   = $woosw_settings['page_id']; // Wishlist page
            $current_page = get_the_ID(); // current page
            if(!empty($wpcsw_page) && $wpcsw_page == $current_page){
                return true;
            } else {
                return false;
            }
        }
    }
}
if(!function_exists('finanzia_header_wishlist')){
    function finanzia_header_wishlist($args=[]){
        if(!class_exists('WPCleverWoosw')) return;
        $args = wp_parse_args($args,[
            'name'           => '',
            'class'          => '',
            'text'           => '',
            'icon'           => 'core/heart-alt',
            'icon_size'      => 17,
            'icon_class'     => '',   
            'before'         => '',
            'after'          => '',
            'link_class'     => 'menu-color',
            'count_color'    => '',
            'count_bg_color' => ''
        ]);
        if(finanzia_get_opts('h_wishlist'.$args['name'].'_on', 'off', 'header_custom') !== 'on') return;
        $css_class = ['cms-header-wishlist relative', $args['class']];
        if(!finanzia_is_wishlist_page()) {
            $css_class[] = 'woosw-menu';
            $url = WPCleverWoosw::get_url();
        } else {
            $url = '#';
        }
        $link_classes = ['cms-wishlist relative cms-counter-icon', $args['link_class']];
        $count_classes = ['header-count wishlist-count cms-count', $args['count_color'], $args['count_bg_color']];
        $icon_classes = ['wishlist-icon header-icon', 'text-'.$args['icon_size'], 'lh-0', 'd-flex', $args['icon_class']];
        printf('%s', $args['before']);
    ?>
        <div class="<?php echo finanzia_nice_class($css_class); ?>">
            <a class="<?php echo finanzia_nice_class($link_classes); ?>" href="<?php echo esc_url( $url ); ?>">
                <?php 
                    // text
                    printf('%s', $args['text']); 
                    // icon
                    finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'attrs' => ['data-count' => WPcleverWoosw::get_count()]]);
                ?>
                <span class="<?php echo finanzia_nice_class($count_classes); ?>"><?php echo WPcleverWoosw::get_count(); ?></span>
            </a>
        </div>
    <?php
        printf('%s', $args['after']);
    }
}
// Header Compare
if(!function_exists('finanzia_header_compare')){
    function finanzia_header_compare($args=[]){
        if(!class_exists('WPCleverWoosc')) return;
        $args = wp_parse_args($args,[
            'name'           => '',
            'class'          => '',
            'text'           => '',
            'icon'           => 'core/compare',
            'icon_size'      => 20,  
            'icon_class'     => '',
            'before'         => '',
            'after'          => '',
            'count_color'    => '',
            'count_bg_color' => '',
            'link_class'     => 'menu-color'
        ]);
        
        if(finanzia_get_opts('h_compare'.$args['name'].'_on', 'off', 'header_custom') !== 'on') return;

        $css_class = ['cms-header-compare woosc-menu relative', $args['class']];
        $count_classes = ['header-count compare-count cms-count', $args['count_color'], $args['count_bg_color']];
        $icon_classes = ['compare-icon header-icon', 'text-'.$args['icon_size'], $args['icon_class']];
        $link_classes = finanzia_nice_class(['cms-compare cms-counter-icon', $args['link_class']]);

        printf('%s', $args['before']);
    ?>
        <div class="<?php echo finanzia_nice_class($css_class); ?>">
            <a class="<?php echo esc_attr($link_classes); ?>" href="<?php echo esc_url( WPcleverWoosc::get_url() ); ?>">
                <?php 
                    // text
                    printf('%s', $args['text']);
                    // icon
                    finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes), 'attrs' => ['data-count' => WPcleverWoosc::get_count()]]);
                ?>
                <span class="<?php echo finanzia_nice_class($count_classes); ?>"><?php echo WPcleverWoosc::get_count(); ?></span>
            </a>
        </div>
    <?php
        printf('%s', $args['after']);
    }
}
// Header Currency Switch
if(!function_exists('finanzia_header_woocs')){
    function finanzia_header_woocs($args = []){
        if(!class_exists('WOOCS_STARTER')) return;
        $args = wp_parse_args($args, [
            'name'             => '',
            'before'           => '',
            'after'            => '',
            'class'            => '',
            'item_class'       => '',
            'link_class'       => 'menu-color',
            'sub_link_class'   => '',           
            'show_flags'       => 'no',
            'show_money_signs' => 'no',
            'show_text'        => 'yes',
            'text_as'          => 'description', // value: name / description
        ]);
        if(finanzia_get_opts('h_woocs'.$args['name'].'_on', 'off', 'header_custom') !== 'on') return;

        printf('%s', $args['before']);
            finanzia_woocs_currency_switcher([
                'class'            => $args['class'],
                'item_class'       => $args['item_class'],
                'link_class'       => $args['link_class'],
                'sub_link_class'   => $args['sub_link_class'],           
                'show_flags'       => $args['show_flags'],
                'show_money_signs' => $args['show_money_signs'],
                'show_text'        => $args['show_text'],
                'text_as'          => $args['text_as'],
            ]);
        printf('%s', $args['after']);
    }
}
// Header Login 
if(!function_exists('finanzia_header_login')){
    function finanzia_header_login($args=[]){
        if(!function_exists('cshlg_link_to_login')) return;
        $args = wp_parse_args($args, [
            'name'                => '',
            'class'               => '',
            'icon'                => 'core/user',
            'icon_class'          => '',
            'icon_size'           => 17,  
            'before'              => '',
            'after'               => '',
            'link_class'          => 'menu-color',
            'show_text'           => true,
            'login_text'          => '',
            'loggedin_text'       => '',
            'modal-mode'          => 'fade',
            'modal-slide'         => 'center',
            'modal-class'         => 'center bg-white',
            'modal-width'         => '400px',
            'modal-content-width' => '400px',
            'modal-space'         => '50px'
        ]);
        
        if(finanzia_get_opts('h_login'.$args['name'].'_on', 'off', 'header_custom') !== 'on') return;
        $css_class = [];
        $link_classes = [
            'site-header-login site-header-item', 
            $args['class'],
            $args['link_class'],
            'header-icon'
        ];

        if(is_user_logged_in()) {
            $text = $args['loggedin_text'];
            if(class_exists('WooCommerce')){
                $url = get_permalink( get_option('woocommerce_myaccount_page_id') );
            } else {
                $url = get_edit_user_link();
            }
            $link_classes[] = '';
        } else {
            $text = $args['login_text'];
            $url = '#csh-login-wrap';
            $link_classes[] = 'cms-modal';
            //$link_classes[] = 'go_to_login_link';
        }
        $icon_classes = ['text-'.$args['icon_size'], $args['icon_class']];
        //
        printf('%s', $args['before']);
    ?>
        <a href="<?php echo esc_url($url); ?>" class="<?php echo finanzia_nice_class($link_classes);?>" data-modal="<?php echo esc_url($url); ?>" data-modal-mode="<?php echo esc_attr($args['modal-mode']) ?>" data-modal-class="<?php echo esc_attr($args['modal-class']) ?>" data-modal-slide="<?php echo esc_attr($args['modal-slide']) ?>" data-modal-width=<?php echo esc_attr($args['modal-width']); ?> data-modal-content-width="<?php echo esc_attr($args['modal-content-width']); ?>" data-modal-space="<?php echo esc_attr($args['modal-space']); ?>">
            <?php 
            // text
            if(!empty($text)): ?><span class="cms-hidden-mobile"><?php printf('%s', $text);?></span><?php 
            endif;
            // icon
            finanzia_svgs_icon(['icon' => $args['icon'], 'class' => finanzia_nice_class($icon_classes) ]);
            ?>
        </a>
    <?php
        printf('%s', $args['after']);
    }
}
/**
 * Language Switcher
*/
if(!function_exists('finanzia_header_language_switcher')){
    function finanzia_header_language_switcher($args = []){
        if(!class_exists('TRP_Translate_Press')) return;
        $args = wp_parse_args($args, [
            'name'           => '',
            'before'         => '',
            'after'          => '',
            // config
            'class'          => '',
            'item_class'     => '',
            'link_class'     => 'menu-color',
            'sub_link_class' => '',
            'show_flag'      => 'no',
            'show_name'      => 'yes',
            'name_as'        => 'full', // short 
        ]);
        if(finanzia_get_opts('h_language'.$args['name'].'_on', 'off', 'header_custom') !== 'on') return;

        printf('%s', $args['before']); 
            cms_language_switcher([
                'class'          => $args['class'],
                'item_class'     => $args['item_class'],
                'link_class'     => $args['link_class'],
                'sub_link_class' => $args['sub_link_class'],
                'show_flag'      => $args['show_flag'],
                'show_name'      => $args['show_name'],
                'name_as'        => $args['name_as'] 
            ]);
        printf('%s', $args['after']);
    }
}
/**
 * Header
 * Side Nav
 * */
if(!function_exists('finanzia_header_side_nav_render')){
    function finanzia_header_side_nav_render($args = []){
        $hide_sidebar_icon = finanzia_get_opts( 'hide_sidebar_icon', 'off', 'header_custom' );
        $header_sidenav_layout = finanzia_get_opts('header_sidenav_layout', 'none', 'hide_sidebar_icon');
        if ( in_array($header_sidenav_layout, ['-1', '0', 'none', '']) || $hide_sidebar_icon != 'on' || !apply_filters('finanzia_enable_sidenav', false) ) return;
        $args = wp_parse_args($args, [
            'class'           => '',
            'modal-mode'      => 'slide', // fade
            'modal-slide'     => 'right', // left/right/up/down/zoom-in
            'modal-width'     => '400px',
            'modal-space'     => '30px',
            'hide_mobile_nav' => true,
            'text'            => '',
            'close-text'      => '',
            'icon_class'      => 'menu-color',
            'icon_size'       => 32 
        ]);
        $classes = array_filter(array_unique(['site-side-navs cms-modal site-header-item', $args['class']]));
        if($args['hide_mobile_nav']){
            $classes[] = 'cms-hidden-mobile-menu';
        }
        $icon_classes = finanzia_nice_class(['site-side-nav', 'text-'.$args['icon_size'], $args['icon_class']]);
    ?>
        <div class="<?php echo finanzia_nice_class($classes); ?>" data-modal="#cms-side-nav" data-modal-mode="<?php echo esc_attr($args['modal-mode']); ?>" data-modal-slide="<?php echo esc_attr($args['modal-slide']); ?>" data-modal-class="bg-white" data-modal-width="<?php echo esc_attr($args['modal-width']); ?>" data-modal-space="<?php echo esc_attr($args['modal-space']); ?>" data-close-text="<?php printf('%s', $args['close-text']); ?>">
            <?php 
                // text
                printf('%s', $args['text']);
                // icon
                finanzia_svgs_icon([
                    'icon'      => 'core/side-menu',
                    'icon_size' => $args['icon_size'],
                    'class'     => $icon_classes
                ]);
            ?>
        </div>
    <?php
    }
}
add_action('wp_footer', 'finanzia_header_side_nav_content_render');
if(!function_exists('finanzia_header_side_nav_content_render')){
    function finanzia_header_side_nav_content_render($args = []){
        $hide_sidebar_icon = finanzia_get_opts( 'hide_sidebar_icon', 'off', 'header_custom' );
        if ( $hide_sidebar_icon !='on' || !apply_filters('finanzia_enable_sidenav', false) ) return;
        $header_sidenav_layout = finanzia_get_opts('header_sidenav_layout', 'none', 'hide_sidebar_icon');
        if(in_array($header_sidenav_layout, ['-1', '0', 'none', ''])) return;
        $cms_post = get_post($header_sidenav_layout);
        if (!is_wp_error($cms_post) && $cms_post->ID == $header_sidenav_layout && class_exists('Elementor_Theme_Core') && class_exists('\Elementor\Plugin')){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $header_sidenav_layout );
            if(empty($content)){
                $content = $cms_post->post_content;
            }
        } else {
            $content = $cms_post->post_content;
        }
        ?>
            <div id="cms-side-nav" class="cms-modal-html cms-modal-sidenav">
                <span class="cms-modal-close cms-close d-flex align-items-center gap-20 gap-mobile-10 p-30">
                    <span class="close-icon text-14 lh-0"><?php include get_template_directory() . '/assets/svgs/core/close.svg'; ?></span>
                </span>
                <div class="cms-modal-content">
                    <div class="cms-sidenav-content cms-mousewheel">
                        <div class="cms-sidenav--content">
                            <?php printf('%s', $content); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
/**
 * Header
 * Socials
 * 
**/
if(!function_exists('finanzia_header_social_render')){
    function finanzia_header_social_render($args = []){
        $args = wp_parse_args($args, [
            'before'     => '',
            'after'      => '',
            'icon'       => '',
            'icon_size'  => 20,
            'icon_class' => '',
            'item_class' => '',
            'text_class' => '',
            'show_text'  => true,
            'echo'       => true,
            'before'     => '',
            'after'      => ''
        ]);

        $show_header_socical = finanzia_get_opts( 'show_header_social', 'off', 'header_custom' );
        $header_socials = finanzia_get_opts('header_socials', []);

        if(empty( $header_socials) || $show_header_socical != 'on') return;
        //
        $icon_class = finanzia_nice_class([
            'cms-header-social-icon cms-icon',
            'text-'.$args['icon_size'],
            'lh-0',
            $args['icon_class']
        ]);
        $text_class = finanzia_nice_class([
            'cms-hidden-mobile-menu empty-none',
            $args['text_class']
        ]);
        $item_class = finanzia_nice_class([
            'd-flex gap-10 align-items-center',
            'cms-anim-icon',
            $args['item_class']
        ]);
        // before
        printf('%s', $args['before']);
        // socials list
        foreach ($header_socials as $key => $social) {
            $icon_mime = substr($social['icon']['url'], -4);
            ob_start();
                switch ($icon_mime) {
                    case '.svg':
                        echo file_get_contents($social['icon']['url']);
                    break;
                    
                    default:
                        echo '<img src="'.$social['icon']['url'].'" width="'.$args['icon_size'].'" alt="'.get_bloginfo('name').'" />';
                        break;
                }
            $icon_html = ob_get_clean();
            $social_text = $args['show_text'] ?  '<span class="'.$text_class.'">'.$social['text'].'</span>' : '';
            // html
            printf('<a href="%1$s" class="%2$s"><span class="%3$s">%4$s</span>%5$s</a>', $social['url'], $item_class, $icon_class, $icon_html, $social_text);
        }
        // after
        printf('%s', $args['after']);
    }
}
/**
 * Header Open Mobile Menu
 * 
 * */
if(!function_exists('finanzia_open_mobile_menu')){
    function finanzia_open_mobile_menu($args = []){
        $args = wp_parse_args($args, [
            'class'        => 'site-header-item',
            'hide_desktop' => true,
            'text'         => '',
            'icon_class'   => 'text-22 menu-color'
        ]);
        $classes = [
            'main-menu-mobile',
            $args['class']
        ];
        if($args['hide_desktop']) $classes[] = 'cms-hidden-desktop-menu';
    ?>
        <div id="main-menu-mobile" class="<?php echo finanzia_nice_class($classes); ?>">
            <?php 
                // text
                printf('%s', $args['text']);
                // icon
                finanzia_svgs_icon([
                    'icon' => 'core/menu',
                    'class' => 'open-menu '.$args['icon_class']
                ]);
            ?>
        </div>
    <?php
    }
}
/**
 * Header Tools Classes
 * 
 * */
if(!function_exists('finanzia_header_tools_classes')){
    function finanzia_header_tools_classes($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $classes = ['site-tools'];
        
        $h_btn_text   = finanzia_get_opt( 'h_btn_text' );
        $h_btn2_text  = finanzia_get_opt( 'h_btn2_text' );
        $phone_number = finanzia_get_opt( 'h_phone_number' );
        $h_btn_on     = $h_btn2_on = $h_phone_on = 'off';
        if(finanzia_get_opts('h_btn_on', 'off', 'header_custom') == 'on' && !empty($h_btn_text)){
            $h_btn_on = 'on';
        }
        if(finanzia_get_opts('h_btn2_on', 'off', 'header_custom') == 'on' && !empty($h_btn2_text)){
            $h_btn2_on = 'on';
        };
        if(finanzia_get_opts('h_phone_on', 'off', 'header_custom') == 'on' && !empty($phone_number) ){
            $h_phone_on = 'on';
        };
        $search_on         = finanzia_get_opts('search_icon', 'off', 'header_custom');
        $cart_on           = finanzia_get_opts('cart_icon', 'off', 'header_custom');
        $social_on           = finanzia_get_opts('show_header_social', 'off', 'header_custom');
        $hide_sidebar_icon = finanzia_get_opts( 'hide_sidebar_icon', 'off', 'header_custom' );
        $header_sidenav_layout = finanzia_get_opts('header_sidenav_layout', 'none', 'hide_sidebar_icon');
        $show_mobile_nav = ($hide_sidebar_icon == 'off' || ($hide_sidebar_icon == 'on' && !in_array($header_sidenav_layout, ['-1', '0', 'none', ''])) || !apply_filters('finanzia_enable_sidenav', false) );

        if($search_on == 'on' || $cart_on == 'on' || $hide_sidebar_icon == 'on' || $h_btn_on == 'on' || $h_btn2_on == 'on' || $h_phone_on == 'on' || $hide_sidebar_icon == 'on' || $social_on == 'on'){
            $classes[] = 'has-tools';
        } else {
            $classes[] = 'cms-hidden-desktop-menu';
        }
        $classes[] = $args['class'];

        return finanzia_nice_class($classes);
    }
}

/**
 * Page title layout
 **/
function finanzia_page_title_layout($args = []){
    // remove page title on some custom post type
    if( (is_singular() && in_array(get_post_type(), ['cms-service', 'cms-industry', 'cms-case', 'cms-career', 'cms-popup'])) ) return;
    $header_transparent = '';
    if(is_singular() && finanzia_get_opts('header_transparent', 'off', 'header_custom') == 'on'){
        $header_transparent = 'ptitle-header-transparent';
    }
    $args = wp_parse_args($args, [
        'show'            => finanzia_get_opts('pagetitle', 'on', 'custom_ptitle'),
        'layout'          => finanzia_get_opts('ptitle_layout', '', 'custom_ptitle'),
        'show_title'      => finanzia_get_opts('show_title', 'on', 'custom_ptitle'),
        'show_breadcrumb' => finanzia_get_opts('show_breadcrumb', 'on', 'custom_ptitle'),
        'ptitle_align'    => finanzia_get_opts('ptitle_align', 'center', 'custom_ptitle'),
        'container'       => 'container',
        'class'           => 'overflow-hidden'
    ]);
    // Configs
    $ptitle_bg = finanzia_get_opts('page_title_bg', ['background-color' => '#999', 'background-image' => ''], 'custom_ptitle');
    $args['class'] = implode(' ', array_filter([
        'cms-ptitle',
        'text-'.$args['ptitle_align'],
        !empty($ptitle_bg['background-image']) ? 'custom' : '',
        $header_transparent,
        $args['class']
    ]));
    if($args['show'] === 'off' || is_404() || is_singular('cms-header-top') || is_singular('cms-footer') || is_singular('cms-mega-menu')) return;
    get_template_part('template-parts/page-title', $args['layout'], $args);
}
/**
 * Get page title and description.
 *
 * @return array Contains 'title'
 */
function finanzia_get_page_titles(){
    $title = '';

    // Default titles
    if (!is_archive()) {
        // Posts page view
        if (is_home()) {
            // Only available if posts page is set.
            if (
                !is_front_page() &&
                ($page_for_posts = get_option('page_for_posts'))
            ) {
                $title = get_post_meta($page_for_posts, 'custom_title', true);
                if (empty($title)) {
                    $title = get_the_title($page_for_posts);
                }
            }
            if (is_front_page()) {
                $title = esc_html__('Blog', 'finanzia');
            }
        }
        // Single page view
        elseif (is_page()) {
            $title = get_post_meta(get_the_ID(), 'custom_title', true);
            if (!$title) {
                $title = get_the_title();
            }
        } elseif (is_404()) {
            $title = esc_html__('404', 'finanzia');
        } elseif (is_search()) {
            $title = esc_html__('Search results', 'finanzia');
        } else {
            $title = get_post_meta(get_the_ID(), 'custom_title', true);
            if (!$title) {
                $title = get_the_title();
            }
        }
    } elseif (is_author()) {
        $title = esc_html__('Author:', 'finanzia') . ' ' . get_the_author();
    }
    // Author
    else {
        $title = get_the_archive_title();
        if (class_exists('WooCommerce') && is_shop()) {
            $title = esc_html__('Our Shop', 'finanzia');
        }
    }

    return [
        'title' => $title,
    ];
}
/**
 * Prints HTML for breadcrumbs.
 */
function finanzia_breadcrumb($args= []){
    if (!class_exists('CMS_Breadcrumb')) {
        return;
    }

    $breadcrumb = new CMS_Breadcrumb();
    $entries = $breadcrumb->get_entries();

    if (empty($entries)) {
        return;
    }
    $args = wp_parse_args($args, [
        'icon_home' => '',
        'class'     => '',
        'link_class'=> '',
        'before'    => '',
        'after'     => ''
    ]);
    $link_class = finanzia_nice_class(['breadcrumb-entry', 'cms-hover-underline', $args['link_class']]);
    ob_start();

    foreach ($entries as $key => $entry) {
        $entry = wp_parse_args($entry, array(
            'label' => '',
            'url' => ''
        ));
        $breadcrumb_separate_icon = apply_filters('finanzia_breadcrumb_separate_icon', 'finanzia_breadcrumb_separate_icon');
        if (empty($entry['label'])) {
            continue;
        }

        echo '<li>';
        if (!empty($entry['url'])) {
            printf(
                '<a class="%1$s" href="%2$s">%3$s%4$s%5$s</a>',
                $link_class,
                esc_url($entry['url']),
                $key === 0 ?  $args['icon_home'] : '',
                esc_attr($entry['label']),
                $breadcrumb_separate_icon
            );
        } else {
            printf('<span class="breadcrumb-entry" >%s</span>', esc_html($entry['label']));
        }

        echo '</li>';
    }

    $output = ob_get_clean();

    if ($output) {
        printf('%s', $args['before']);
            printf('<ul class="%1$s">%2$s</ul>',implode(' ', array_filter(['cms-breadcrumb unstyled', $args['class']])), $output);
        printf('%s', $args['after']);
    }
}
add_filter('finanzia_breadcrumb_separate_icon', 'finanzia_breadcrumb_separate_icon');
function finanzia_breadcrumb_separate_icon(){
    // icon
    ob_start();
        echo '<span class="breadcrumb-separate text-6 lh-0">';
        include get_template_directory() . '/assets/svgs/core/chevron-right.svg';
        echo '</span>';
    return ob_get_clean();
}
/**
 * Main Content 
 * 
 * **/
if(!function_exists('finanzia_show_sidebar')){
    function finanzia_show_sidebar($sidebar=''){
        $sidebar_on = finanzia_get_opt('sidebar_on','off');
        if(empty($sidebar)){
            if(finanzia_is_woocommerce()){
                $sidebar_name = 'sidebar-product';
            } else {
                $sidebar_name = 'sidebar-post';
            }
        } else {
            $sidebar_name = $sidebar;
        }
        $show_sidebar = ($sidebar_on === 'on' && is_active_sidebar($sidebar_name));
        return $show_sidebar;
    }
}
if(!function_exists('finanzia_main_content_classes')){
    function finanzia_main_content_classes($args = []){
        $args = wp_parse_args($args, [
            'class' => '',
            'sidebar' => ''
        ]);
        $classes = [
            'cms-main',
            $args['class']
        ];
        if(finanzia_is_built_with_elementor()){
            $classes[] = 'is-elementor';
        } else {
            $classes[] = finanzia_get_opts('content_width', 'container', 'on');
            if(finanzia_is_woocommerce()){
                if(finanzia_show_sidebar($args['sidebar']) && !is_singular('product') ){
                    $classes[] = 'cms-main-sidebar cms-woo-sidebar d-flex justify-content-center';
                } else {
                    $classes[] = 'cms-woo-content';
                }
            } elseif( (cms_is_blog() || is_single()) && finanzia_show_sidebar($args['sidebar']) ){
                $classes[] = 'cms-main-sidebar d-flex justify-content-center';
            } else {
                $classes[] = 'no-sidebar';
            }
            // Post type archive
            if ( is_post_type_archive() ) {
                $post_type = get_query_var( 'post_type' );
                if ( is_array( $post_type ) ) {
                    $post_type = reset( $post_type );
                }
                $classes[] = 'cms-post-type-archive-' . sanitize_html_class( $post_type );
            }
        }
        $classes = apply_filters('finanzia_main_content_classes', $classes);
        
        echo implode(' ', array_filter($classes));
    }
}
function finanzia_content_has_sidebar_open($sidebar=''){
    $classes = ['cms-main-content'];
    if(finanzia_is_built_with_elementor()){
        $has_sidebar = false;
    } else {
        if(finanzia_is_woocommerce()){
            if(finanzia_show_sidebar($sidebar) && !is_singular('product') ){
                $has_sidebar = true;
            } else {
                $has_sidebar = false;
            }
            $classes[] = 'main-content-shop';
        } elseif((cms_is_blog() || is_single()) && finanzia_show_sidebar($sidebar)){
            $has_sidebar = true;
        } else {
            $has_sidebar = false;
        }
    }
    if(!$has_sidebar) return;
    ?>
    <div class="<?php echo finanzia_nice_class($classes); ?>">
    <?php
}
function finanzia_content_has_sidebar_close($sidebar=''){
    if(finanzia_is_built_with_elementor()){
        $has_sidebar = false;
    } else {
        if(finanzia_is_woocommerce()){
            if(finanzia_show_sidebar($sidebar) && !is_singular('product') ){
                $has_sidebar = true;
            } else {
                $has_sidebar = false;
            }
        } elseif((cms_is_blog() || is_single()) && finanzia_show_sidebar($sidebar)){
            $has_sidebar = true;
        } else {
            $has_sidebar = false;
        }
    }
    if(!$has_sidebar) return;
    ?>
    </div>
    <?php
}

/**
 * Footer layout
 **/
function finanzia_footer(){
    if(is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu') || is_singular('cms-sidenav')) return;
    //get_template_part('template-parts/footer-layout','');
    $footer_layout = finanzia_get_opts('footer_layout', '1', 'footer_custom');

    switch ($footer_layout){
        case 'none':
            break;
        case '1':
            finanzia_footer_copyright();
            break;
        default : 
            finanzia_footer_elementor_builder();
            break;
    }
}
/*
 * Footer css class
*/
if(!function_exists('finanzia_footer_css_class')){
    function finanzia_footer_css_class($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $footer_layout = finanzia_get_opts( 'footer_layout', '1' );
        $footer_fixed = finanzia_get_opts('footer_fixed', 'off', 'footer_custom');
        $css_classes = [
            'cms-footer',
            'relative'
        ];
        if(!in_array($footer_layout, ['-1', '0', '1', 'none'])) {
            $css_classes[] = 'cms-footer-elementor';
        } else {
            $css_classes[] = finanzia_get_opts('content_width', 'container', 'on');
        }

        if($footer_fixed == 'on') $css_classes[] = 'cms-footer--fixed';
        echo implode(' ', array_filter($css_classes));
    }
}
if(!function_exists('finanzia_default_copyright_text')){
    function finanzia_default_copyright_text($text = '', $args = []){
        $args = wp_parse_args($args, [
            'link_color'       => '',
            'link_hover_color' => ''
        ]);
        if(!empty($text)){
            $default_copyright_text = str_replace(['[[copy]]', '[[year]]'], ['&copy;', date('Y')], $text);
        } else {
            $default_text = sprintf(esc_html__('&copy;%s %s, All Rights Reserved. With Love by %s ','finanzia'), date('Y') , get_bloginfo('name'), '<a class="'.$args['link_color'].' '.$args['link_hover_color'].'" href="'.esc_url('https://cmssuperheroes.com/').'" target="_blank" rel="nofollow">'.esc_html__('CMSSupperHeroes','finanzia').'</a>');
            //
            $default_copyright_text = str_replace(['[[copy]]', '[[year]]'], ['&copy;', date('Y')], finanzia_get_opts('footer_copyright', $default_text, 'footer_custom'));
        }
        return $default_copyright_text;
    }
}
if(!function_exists('finanzia_footer_copyright')){
    function finanzia_footer_copyright($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $classes = ['cms-copyright-text cms-footer-copyright', $args['class']];

        if(is_404()) $classes[] = 'text-center';
    ?>
    <div class="<?php echo implode(' ', array_filter($classes));?>">
        <?php echo finanzia_default_copyright_text(); ?>
    </div>
    <?php
    }
}
/**
* Footer elementor builder
*
*/
if(!function_exists('finanzia_footer_elementor_builder')){
    function finanzia_footer_elementor_builder(){
        if(!class_exists('Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $footer_layout = finanzia_get_opts('footer_layout', '1', 'footer_custom');
        if(in_array($footer_layout, ['-1', '0', '1', 'none'])) return;
        $cms_post = get_post($footer_layout);
        if (!is_wp_error($cms_post) && $cms_post->ID == $footer_layout){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $footer_layout );
            if(!empty($content)){
                etc_print_html($content);
            } else {
            ?>
            <div class="<?php etc_print_html(finanzia_get_opts('content_width', 'container', 'on'));  ?> cms-copyright-text cms-footer-copyright">
                <?php etc_print_html($cms_post->post_content); ?>
            </div>
            <?php 
            }
        }
    }
}

/**
 * Popup Content
 * 
 * **/
add_action('wp_footer', 'finanzia_popup_content_render');
if(!function_exists('finanzia_popup_content_render')){
    function finanzia_popup_content_render($args = []){
        if(is_user_logged_in()) return;
        $args = wp_parse_args($args, [
            'hide_popup' => finanzia_get_opts('hide_popup', 'off', 'popup_custom'),
            'animate'    => finanzia_get_opts('popup_animate', 'cms-fadeInUp', 'popup_custom'),
            'position'   => finanzia_get_opts('popup_position', 'align-items-end', 'popup_custom')
        ]);
        if(!class_exists('Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $popup_layout = finanzia_get_opts('popup_layout', '1', 'popup_custom');
        if(in_array($popup_layout, ['-1', '0', '1', 'none'])) return;
        $cms_post = get_post($popup_layout);

        $popup_classes = [
            'cms-sp cms-sp-holder cms-sp-prevent-session cms-overlay fixed d-flex',
            'p-50 p-tablet-20 p-mobile-0',
            $args['position']
        ];
        $popup_inner_classes = [
            'cms-sp-inner relative',
            $args['animate'],
            'cms-transition',
            'bg-white'
        ];
    ?>
        <div id="cms-subscribe-popup" class="<?php echo finanzia_nice_class($popup_classes); ?>">
            <div class="<?php echo finanzia_nice_class($popup_inner_classes); ?>">
                <a href="javascript:void(0)" class="cms-sp-close absolute top-right p-20 text-hover-red z-top3 bg-white text-18"><?php
                    include get_template_directory() . '/assets/svgs/core/chevron-right.svg';
                ?></a>
                <div class="cms-sp-content-container">
                    <div class="cms-sp-content-inner"><?php 
                        if (!is_wp_error($cms_post) && $cms_post->ID == $popup_layout){
                            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $popup_layout );
                            if(!empty($content)){
                                etc_print_html($content);
                            } else {
                                etc_print_html($cms_post->post_content);
                            }
                        }
                    ?></div>
                    <?php if($args['hide_popup'] === 'on'){ ?>
                        <div class="cms-sp-prevent p-20">
                            <div class="cms-sp-prevent-inner d-flex gap-10 align-items-center justify-content-end text-15">
                                <input class="cms-sp-prevent-input" type="checkbox" name="cms-sp-prevent-input" id="cms-sp-prevent-input">
                                <label for="cms-sp-prevent-input" class="cms-sp-prevent-label"><?php echo esc_html__('Disable This Pop-up', 'finanzia') ?></label>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php
    }
}

/**
 * Post Term
 * 
 *  */
if(!function_exists('finanzia_get_the_term_list')){
    function finanzia_get_the_term_list( $post_id, $taxonomy, $sep = '', $class = '', $args = [] ) {
        $terms = get_the_terms( $post_id, $taxonomy );
        
        if ( is_wp_error( $terms ) ) {
            return $terms;
        }
     
        if ( empty( $terms ) ) {
            return false;
        }
     
        $links = array();
     
        foreach ( $terms as $term ) {
            $link = get_term_link( $term, $taxonomy );
            if ( is_wp_error( $link ) ) {
                return $link;
            }
            $links[] = '<a href="' . esc_url( $link ) . '" class="'.finanzia_nice_class(['cms-term', $class]).'">' . $term->name . '</a>';
        }
     
        /**
         * Filters the term links for a given taxonomy.
         *
         * The dynamic portion of the hook name, `$taxonomy`, refers
         * to the taxonomy slug.
         *
         * Possible hook names include:
         *
         *  - `term_links-category`
         *  - `term_links-post_tag`
         *  - `term_links-post_format`
         *
         * @since 2.5.0
         *
         * @param string[] $links An array of term links.
         */
        $term_links = apply_filters( "cms_term_links-{$taxonomy}", $links );  // phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores
     
        return implode( $sep, $term_links );
    }
}
/**
 * Term Lists
 * 
 * */
if(!function_exists('finanzia_the_terms')){
    function finanzia_the_terms( $post_id, $taxonomy, $sep = ', ', $class = '' , $args = []) {
        $args = wp_parse_args($args, [
            'before'      => '',
            'after'       => '',
            'before_term' => '',
            'after_term'  => ''  
        ]);
        $term_list = finanzia_get_the_term_list( $post_id, $taxonomy, $sep, $class, $args );
        if ( is_wp_error( $term_list ) ) {
            return false;
        }
     
        /**
         * Filters the list of terms to display.
         *
         * @since 2.9.0
         *
         * @param string $term_list List of terms to display.
         * @param string $taxonomy  The taxonomy name.
         * @param string $sep       String to use between the terms.
         * @param string $class     CSS class to use in the terms.
         */
        printf ('%s', $args['before']);
            echo apply_filters( 'finanzia_the_terms', $term_list, $taxonomy, $sep, $class );
        printf ('%s', $args['after']);
    }
}
/**
 * Post Title
 * 
 * */
if(!function_exists('finanzia_entry_title')){
    function finanzia_entry_title($args= []){
        $args=wp_parse_args($args, [
            'class' => ''
        ]);
        $classes = array_filter(['cms-post-title', 'lh-1667', $args['class']]);
    ?>
        <h3 class="<?php echo implode(' ', $classes); ?>">
            <a href="<?php echo esc_url( get_permalink() ); ?>" class="d-inline">
                <?php 
                    // sticky icon
                    if ( is_sticky() ) {
                        echo '<span class="text-26">';
                            include get_template_directory() . '/assets/svgs/core/thumbtack.svg';
                        echo '</span>';
                    }
                    // title
                    the_title(); 
                ?>
            </a>
        </h3>
    <?php
    }
}
if(!function_exists('finanzia_entry_single_title')){
    function finanzia_entry_single_title($args = []){
        $args  = wp_parse_args($args, [
            'class' => ''
        ]);
        $classes = ['cms-post-title', 'cms-post-single-title', 'lh-1667', $args['class'], 'empty-none'];
    ?>
        <h3 class="<?php echo finanzia_nice_class($classes); ?>"><?php 
            the_title(); 
        ?></h3>
    <?php
    }
}

/**
 * Post Thumbnail
 * 
 * */
if(!function_exists('finanzia_entry_thumbnail')){
    function finanzia_entry_thumbnail($args = []){
        if ( !has_post_thumbnail() ) return;
        $args = wp_parse_args($args, [
            'class'     => '',
            'size'      => 'medium',
            'img_class' => '',
            'content'   => ''
        ]);
        $classes      = finanzia_nice_class(['cms-post-thumbnail', 'relative', $args['class']]);
        $opt_prefix   = is_singular('post')?'post_':'archive_';
    ?>
        <div class="<?php echo esc_attr($classes); ?>"><?php
            finanzia_the_post_thumbnail([
                'size'    => $args['size'],
                'class'   => $args['img_class']
            ]);
            printf('%s', $args['content']);
        ?></div>
    <?php
    }
}
if(!function_exists('finanzia_the_post_thumbnail')){
    function finanzia_the_post_thumbnail($args = []){
        $args = wp_parse_args($args, [
            'size'    => 'medium',
            'class'   => ''
        ]);
        echo wp_get_attachment_image(get_post_thumbnail_id(), $args['size'], false, ['class' => $args['class'], 'loading' => 'lazy']);
    }
}
/**
 * Get excerpt
 * The excerpt with custom length.
 * @return string      
 */
function finanzia_get_the_excerpt($length = 55, $post = null){
    $post = get_post($post);

    if (empty($post) || 0 >= $length) {
        return '';
    }

    if (post_password_required($post)) {
        return esc_html__('Post password required.', 'finanzia');
    }

    $content = apply_filters(
        'the_content',
        strip_shortcodes($post->post_content)
    );
    $content = str_replace(']]>', ']]&gt;', $content);

    $excerpt_more = apply_filters('finanzia_excerpt_more', '&hellip;');
    $excerpt = wp_trim_words($content, $length, $excerpt_more);

    return $excerpt;
}
/**
* Print post excerpt based on length.
*
* @param integer $length
*/
if (!function_exists('finanzia_entry_excerpt')) :
    function finanzia_entry_excerpt($args)
    {
        $args = wp_parse_args($args, [
            'length' => 55,
            'class' => ''
        ]);
        $cms_the_excerpt = get_the_excerpt();
        $classes = ['cms-excerpt', $args['class']];
    ?>
    <div class="<?php echo finanzia_nice_class($classes); ?>"><?php
        if (!empty($cms_the_excerpt)) {
            echo esc_html($cms_the_excerpt);
        } else {
            echo wp_kses_post(finanzia_get_the_excerpt($args['length']));
        }
    ?></div>
    <?php
    }
endif;
/**
 * Post Page Link
 * */
function finanzia_entry_link_pages(){
    wp_link_pages(array(
        'before'      => '<div class="cms-page-links d-flex pt-20">',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
    ));
}
/**
 * Post Readmore
 * */
if(!function_exists('finanzia_entry_readmore')){
    function finanzia_entry_readmore(){
    ?>
        <div class="cms-readmore m-tb-n7 pt-33 font-700">
            <a class="cms-link cms-hover-underline cms-hover-move-icon-right text-accent" href="<?php echo esc_url( get_permalink() ); ?>"><?php 
                echo esc_html__( 'Read More', 'finanzia' ); 
                // icon
                finanzia_svgs_icon([
                    'icon'  => 'core/long-arrow-right',
                    'class' => 'text-17'
                ]);
            ?></a>
        </div>
    <?php
    }
}
/**
 * Prints post meta
 */
if (!function_exists('finanzia_post_meta')) :
    function finanzia_post_meta($args = [])
    {
        $args = wp_parse_args($args, [
            'opt_prefix' => 'archive_',
            'class'      => '',
            'gap'        => '',
            'tax'        => 'category',
            'separator'  => '<div class="separator"></div>',
            'show_cat'   => true,
            'show_date'  => true,
            'link_class' => '',
            'cat_class'  => '',
            'cat_link_class' => ''
        ]);
        $classes = ['cms-post-meta', $args['class'], 'd-flex align-items-center'];
        if(!empty($args['gap'])) $classes[] = 'gap';
        $author_on     = (bool) finanzia_get_opt($args['opt_prefix'].'author_on', true);
        $categories_on = (bool) finanzia_get_opt($args['opt_prefix'].'categories_on', true);
        $date_on       = (bool) finanzia_get_opt($args['opt_prefix'].'date_on', true);
        $comments_on   = (bool) finanzia_get_opt($args['opt_prefix'].'comments_on', false);

        $metas = [];
        if ($author_on || $comments_on || $categories_on || $date_on) : ?>
            <div class="<?php echo implode(' ', array_filter($classes)); ?>" style="<?php echo esc_attr($args['gap']); ?>">
                <?php if ($author_on) : 
                    ob_start();
                ?>
                    <div class="meta-item author">
                        <?php finanzia_the_author_posts_link([
                            'text'       => '',
                            'link_class' => $args['link_class']
                        ]); ?>
                    </div>
                <?php 
                $metas[] = ob_get_clean(); 
                endif;
                if ($date_on && $args['show_date']) : 
                    ob_start();
                ?>
                    <div class="meta-item date"><?php echo get_the_date(); ?></div>
                <?php 
                    $metas[] = ob_get_clean(); 
                endif;
                if($args['show_cat'] && $categories_on){
                    ob_start();
                        $cat_classes = ['meta-item category empty-none', $args['cat_class']];
                        $cat_link_class = finanzia_nice_class([$args['link_class'], $args['cat_link_class']]);
                    ?>
                        <div class="<?php echo finanzia_nice_class($cat_classes); ?>"><?php finanzia_the_terms(get_the_ID(), $args['tax'], ', ', $cat_link_class); ?></div>
                    <?php
                    $metas[] = ob_get_clean(); 
                }
                if ($comments_on) :
                    ob_start();
                ?>
                    <div class="meta-item comment"><?php finanzia_comment_number(['link_class' => 'd-flex text-accent gap-5 '.$args['link_class'], 'title_class' => 'text-body order-first']); ?></div>
                <?php 
                    $metas[] = ob_get_clean();
                endif;
                // Render HTML
                printf('%s', implode($args['separator'], $metas));
            ?>
            </div>
        <?php endif;
    }
endif;
/**
 * Author Post link
 * 
 * */
if(!function_exists('finanzia_the_author_posts_link')){
    function finanzia_the_author_posts_link($args = []){
        $args = wp_parse_args($args, [
            'id'         => '',   
            'text'       => '',
            'link_class' => '',
            'object'     => '',
            'before'     => '',
            'after'      => ''   
        ]);
        if(! is_object($args['object'])){
            global $authordata;
            if ( ! is_object( $authordata ) ) {
                return '';
            }
            //$user_id = $authordata->ID;
            $user_id = get_post_field( 'post_author', $args['id'] );
        } else {
            $user_id = $args['object']->post_author;
        }

        $link = sprintf(
            '%1$s<a href="%2$s" title="%3$s" class="%4$s" rel="author">%5$s</a>',
            $args['text'],
            esc_url( get_author_posts_url( $user_id , get_the_author_meta('user_nicename',$user_id ) ) ),
            /* translators: %s: Author's display name. */
            esc_attr( sprintf( esc_html__( 'Posts by %s', 'finanzia' ), get_the_author_meta('display_name', $user_id ) ) ),
            $args['link_class'],
            get_the_author_meta('display_name', $user_id )
        );
        printf('%s', $args['before']);
        echo apply_filters( 'finanzia_the_author_posts_link', $link );
        printf('%s', $args['after']);
    }
}
/**
 * Post Comment Count
 * */
if(!function_exists('finanzia_comment_number')){
    function finanzia_comment_number($args=[]){
        $args = wp_parse_args($args, [
            'title_class' => '',
            'link_class'  => ''  
        ]);
        $number = get_comments_number();
        switch ($number) {
            case '1':
                $html = number_format_i18n($number).' <span class="'.$args['title_class'].'">'.esc_html__('Comment','finanzia').':</span>';
                break;
            default:
                $html = number_format_i18n($number).' <span class="'.$args['title_class'].'">'.esc_html__('Comments','finanzia').':</span>';
                break;
        }
    ?>
        <a href="<?php the_permalink(); ?>" class="<?php echo esc_attr($args['link_class']); ?>"><?php printf('%s', $html);?></a>
    <?php
    }
}
/**
 * Prints tag list
 */
if (!function_exists('finanzia_entry_tagged_in')){
    function finanzia_entry_tagged_in($args = []) {
        $show_tag  = (bool)finanzia_get_opt('post_tags_on', true);
        $tags_list = finanzia_get_the_tag_list([
            'taxonomy'   => 'post_tag',
            'echo'       => false,
            'ul_class'   => 'wp-tag-cloud',
            'link_class' => 'tag-cloud-link'
        ]);
        if (!$tags_list || !$show_tag) return;
        $args = wp_parse_args($args, [
            'class' => '',
            'title' => ''
        ]);
    ?>
        <div class="<?php echo implode(' ', array_filter(['cms-post-tags', $args['class']])) ?>">
            <?php printf('%1$s', $args['title']); ?>
            <div class="tagcloud">
                <?php printf('%2$s', '', $tags_list); ?>
            </div>
        </div>
    <?php 
    }
}
function finanzia_get_the_tag_list($args = []) {
    $args = wp_parse_args($args, [
        'post_id'    => null, 
        'taxonomy'   => '',
        'before'     => '',
        'after'      => '',
        'link_class' => '',
        'li_class'   => '',
        'ul_class'   => '',
        'echo'       => true
    ]);
    $terms = get_the_terms( $args['post_id'], $args['taxonomy'] );

    if ( is_wp_error( $terms ) ) {
        return $terms;
    }

    if ( empty( $terms ) ) {
        return false;
    }
    $ul_class = ['cms-term-list', $args['ul_class']];
    $li_class = ['cms-term-li',$args['li_class']];
    $a_class = ['cms-term-link', $args['link_class']];

    $links = array();

    foreach ( $terms as $term ) {
        $link = get_term_link( $term, $args['taxonomy'] );
        if ( is_wp_error( $link ) ) {
            return $link;
        }
        $links[] = '<li class="'.finanzia_nice_class($li_class).'"><a href="' . esc_url( $link ) . '" class="'.finanzia_nice_class($a_class).'" rel="'.$args['taxonomy'].'">' . $term->name . '</a></li>';
    }
    $term_links =  implode('', $links);
    ob_start();
    printf('%s', $args['before']);
?> 
    <ul class="<?php echo finanzia_nice_class($ul_class); ?>" role="list">
        <?php printf('%s', $term_links); ?>
    </ul>
<?php
    printf('%s', $args['after']);

    if($args['echo']){
        echo ob_get_clean();
    } else {
        return ob_get_clean();
    }
}
/**
 * List socials share for post.
 * 
 * 
 */
function finanzia_socials_share_default($args = []) {
    $args = wp_parse_args($args, [
        'class'       => '',
        'show'        => false,
        'title'       => '',
        'icon_size'   => 15,
        'inner_class' => '',
        'icon_class'  => ''
    ]);
    if(!$args['show']) return;
    $img_url = get_the_post_thumbnail_url();

    $link_classes = finanzia_nice_class(['cms-social-link', 'text-'.$args['icon_size'], $args['icon_class']]);
    ?>
    <div class="<?php echo implode(' ', array_filter(['cms-post-share', 'align-items-center', $args['class']])) ?>">
        <?php printf('%s', $args['title']); ?>
        <div class="<?php echo finanzia_nice_class(['cms-post--share d-flex gap-15 lh-0', $args['inner_class']]); ?>">
            <a title="<?php echo esc_attr__('Facebook', 'finanzia'); ?>" target="_blank" class="<?php echo esc_attr($link_classes); ?>"
               href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" 
               ><?php include get_template_directory() . '/assets/svgs/core/facebook.svg'; ?></a>
            <a title="<?php echo esc_attr__('Twitter', 'finanzia'); ?>" target="_blank" class="<?php echo esc_attr($link_classes); ?>"
               href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>" 
               ><?php include get_template_directory() . '/assets/svgs/core/twitter.svg'; ?></a>
            <a title="<?php echo esc_attr__('LinkedIn', 'finanzia'); ?>" target="_blank" class="<?php echo esc_attr($link_classes); ?>"
               href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" 
               ><?php include get_template_directory() . '/assets/svgs/core/linkedin.svg'; ?></a>
        </div>
    </div>
    <?php
}
function finanzia_social_share_pinterest(){
?>
    <a title="<?php echo esc_attr__('Pinterest', 'finanzia'); ?>" target="_blank"
               href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url); ?>&description=<?php the_title(); ?>%20" 
               class="d-none"><?php include get_template_directory() . '/assets/svgs/core/pinterest.svg'; ?></a>
<?php
}

/* Author Social */
function finanzia_get_user_social($args = []){
    $args = wp_parse_args($args, [
        'class'     => '',
        'gap'       => 10,
        'icon_size' => 20,
        'icon_class' => ''
    ]);
    //
    $user_facebook  = get_user_meta(get_the_author_meta('ID'), 'user_facebook', true);
    $user_twitter   = get_user_meta(get_the_author_meta('ID'), 'user_twitter', true);
    $user_linkedin  = get_user_meta(get_the_author_meta('ID'), 'user_linkedin', true);
    $user_skype     = get_user_meta(get_the_author_meta('ID'), 'user_skype', true);
    $user_youtube   = get_user_meta(get_the_author_meta('ID'), 'user_youtube', true);
    $user_vimeo     = get_user_meta(get_the_author_meta('ID'), 'user_vimeo', true);
    $user_tumblr    = get_user_meta(get_the_author_meta('ID'), 'user_tumblr', true);
    $user_rss       = get_user_meta(get_the_author_meta('ID'), 'user_rss', true);
    $user_pinterest = get_user_meta(get_the_author_meta('ID'), 'user_pinterest', true);
    $user_instagram = get_user_meta(get_the_author_meta('ID'), 'user_instagram', true);
    $user_yelp      = get_user_meta(get_the_author_meta('ID'), 'user_yelp', true);
    $user_tiktok    = get_user_meta(get_the_author_meta('ID'), 'user_tiktok', true);
    // 
    $classes    = ['user-social unstyled d-flex', 'align-items-start', 'gap-'.$args['gap'], 'lh-0', $args['class']];
    $icon_class = ['user-social-icon', 'text-'.$args['icon_size'], $args['icon_class']];

    ?>
    <div class="<?php echo finanzia_nice_class($classes); ?>">
        <?php if (!empty($user_facebook)) { ?>
            <a href="<?php echo esc_url($user_facebook); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/facebook.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_instagram)) { ?>
            <a href="<?php echo esc_url($user_instagram); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/instagram.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_tiktok)) { ?>
            <a href="<?php echo esc_url($user_tiktok); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/tik-tok.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_twitter)) { ?>
            <a href="<?php echo esc_url($user_twitter); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/twitter.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_linkedin)) { ?>
            <a href="<?php echo esc_url($user_linkedin); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/linkedin.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_rss)) { ?>
            <a href="<?php echo esc_url($user_rss); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/rss.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_skype)) { ?>
            <a href="<?php echo esc_url($user_skype); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/skype.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_pinterest)) { ?>
            <a href="<?php echo esc_url($user_pinterest); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/pinterest.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_vimeo)) { ?>
            <a href="<?php echo esc_url($user_vimeo); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/vimeo.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_youtube)) { ?>
            <a href="<?php echo esc_url($user_youtube); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/play.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_yelp)) { ?>
            <a href="<?php echo esc_url($user_yelp); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/yelp.svg'; ?></a>
        <?php } ?>
        <?php if (!empty($user_tumblr)) { ?>
            <a href="<?php echo esc_url($user_tumblr); ?>" class="<?php echo finanzia_nice_class($icon_class); ?>"><?php include get_template_directory() . '/assets/svgs/core/tumblr.svg'; ?></a>
        <?php } ?>

    </div> <?php
}

/**
 * Pagination Ajax
 * **/
add_action('wp_ajax_finanzia_get_pagination_html', 'finanzia_get_pagination_html');
add_action('wp_ajax_nopriv_finanzia_get_pagination_html', 'finanzia_get_pagination_html');
if (!function_exists('finanzia_get_pagination_html')) {
    function finanzia_get_pagination_html()
    {
        try {
            if (!isset($_POST['query_vars'])) {
                throw new Exception(__('Something went wrong while requesting. Please try again!', 'finanzia'));
            }
            $query = map_deep($_POST['query_vars'], 'sanitize_text_field');
            if(isset($_POST['filter']) && !empty($_POST['filter'])){
                $query['tax_query'] = [
                    'relation'       => 'OR',
                ];
                $tmp = explode('|', sanitize_text_field($_POST['filter']));
                if (isset($tmp[0]) && isset($tmp[1])) {
                    $query['tax_query'][] = array(
                        'taxonomy' => $tmp[1],
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => array($tmp[0]),
                    );
                }
            }
            $query = new WP_Query($query);
            ob_start();
            finanzia_posts_pagination($query, true);
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Successfully!', 'finanzia'),
                    'data' => array(
                        'html' => $html,
                        'query_vars' => $_POST['query_vars'],
                        'post' => $query->have_posts()
                    ),
                )
            );
        } catch (Exception $e) {
            wp_send_json(array('status' => false, 'message' => $e->getMessage()));
        }
        die;
    }
}
add_action('wp_ajax_finanzia_load_more_post_grid', 'finanzia_load_more_post_grid');
add_action('wp_ajax_nopriv_finanzia_load_more_post_grid', 'finanzia_load_more_post_grid');
if (!function_exists('finanzia_load_more_post_grid')) {
    function finanzia_load_more_post_grid()
    {
        try {
            if (!isset($_POST['settings'])) {
                throw new Exception(__('Something went wrong while requesting. Please try again!', 'finanzia'));
            }
            $settings = map_deep($_POST['settings'], 'sanitize_text_field');
            set_query_var('paged', $settings['paged']);
            extract(etc_get_posts_of_grid($settings['post_type'], [
                'source' => isset($settings['source']) ? $settings['source'] : '',
                'orderby' => isset($settings['orderby']) ? $settings['orderby'] : 'date',
                'order' => isset($settings['order']) ? $settings['order'] : 'desc',
                'limit' => isset($settings['limit']) ? $settings['limit'] : '6',
                'post_ids' => '',
            ]));
            ob_start();
            finanzia_get_post_grid($settings, $posts, $settings);
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Successfully!', 'finanzia'),
                    'data' => array(
                        'html' => $html,
                        'paged' => $settings['paged'],
                        'posts' => $posts,
                        'max' => $max,
                    ),
                )
            );
        } catch (Exception $e) {
            wp_send_json(array('status' => false, 'message' => $e->getMessage()));
        }
        die;
    }
}

/**
 * Prints posts pagination based on query
 *
 * @param WP_Query $query Custom query, if left blank, this will use global query ( current query )
 *
 * @return void
 */
/* Filter function to be used with number_format_i18n filter hook */
if( ! function_exists( 'finanzia_number_format_i18n_zero_prefix' ) ) {
    function finanzia_number_format_i18n_zero_prefix( $format ) {
        $number = intval( $format );
        if( intval( $number / 10 ) > 0 ) {
            return $format;
        }
        return '0' . $format;
    }
}
if(!function_exists('finanzia_posts_pagination')){
    function finanzia_posts_pagination($query = null, $ajax = false){
        if ($ajax) {
            add_filter('paginate_links', 'finanzia_ajax_paginate_links');
        }

        $classes = array();

        if (empty($query)) {
            $query = $GLOBALS['wp_query'];
        }

        if (empty($query->max_num_pages) || !is_numeric($query->max_num_pages) || $query->max_num_pages < 2) {
            return;
        }

        $paged = $query->get('paged', '');

        if (!$paged && is_front_page() && !is_home()) {
            $paged = $query->get('page', '');
        }

        $paged = $paged ? intval($paged) : 1;

        $pagenum_link = html_entity_decode(get_pagenum_link());
        $query_args = array();
        $url_parts = explode('?', $pagenum_link);

        if (isset($url_parts[1])) {
            wp_parse_str($url_parts[1], $query_args);
        }

        $pagenum_link = remove_query_arg(array_keys($query_args), $pagenum_link);
        $pagenum_link = trailingslashit($pagenum_link) . '%_%';
        $paginate_links_args = array(
            'base'      => $pagenum_link,
            'total'     => $query->max_num_pages,
            'current'   => $paged,
            'mid_size'  => 1,
            'add_args'  => array_map('urlencode', $query_args),
            'prev_text' => apply_filters('finanzia_pagination_prev_arrow','Prev'),
            'next_text' => apply_filters('finanzia_pagination_next_arrow','Next')
        );
        if ($ajax) {
            $paginate_links_args['format'] = '?page=%#%';
        }
        $links = paginate_links($paginate_links_args);
        if ($links):
        ?>
            <nav class="navigation posts-pagination <?php echo esc_attr($ajax ? 'ajax' : ''); ?>">
                <div class="posts-page-links d-flex">
                    <?php
                        printf('%s', $links);
                    ?>
                </div>
            </nav>
        <?php
        endif;
    }
}

if(!function_exists('finanzia_pagination_prev_arrow')){
    add_filter('finanzia_pagination_prev_arrow', 'finanzia_pagination_prev_arrow');
    function finanzia_pagination_prev_arrow(){
        return finanzia_svgs_icon([
            'icon'  => 'core/arrow-left',
            'class' => 'text-13',
            'echo'  => false 
        ]);
    }
}
if(!function_exists('finanzia_pagination_next_arrow')){
    add_filter('finanzia_pagination_next_arrow', 'finanzia_pagination_next_arrow');
    function finanzia_pagination_next_arrow(){
        return finanzia_svgs_icon([
            'icon'  => 'core/arrow-right',
            'class' => 'text-13',
            'echo'  => false 
        ]);
    }
}
/**
 * Single Post
 * 
 * Display navigation to next/previous post when applicable.
 */
function finanzia_post_nav_default($args = []){
    if(!finanzia_get_opt('post_navigation_on', true)) return;
    global $post;
    $previous = (is_attachment()) ? get_post($post->post_parent) : get_adjacent_post(false, '', true);
    $next = get_adjacent_post(false, '', false);

    if (!$next && !$previous) {
        return;
    }

    $args = wp_parse_args($args, [
        'class' => ''
    ]);

    $next_post = get_next_post();
    $previous_post = get_previous_post();

    if (!empty($next_post) || !empty($previous_post)) {
        ?>
        <div class="cms-nav-links d-flex gap justify-content-between font-700 <?php echo esc_attr($args['class']); ?>">
            <?php if (is_a($previous_post, 'WP_Post') && get_the_title($previous_post->ID) != '') {
                $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                $prev_img_url = wp_get_attachment_image_src($prev_img_id, 'thumbnail');
                ?>
                <a class="nav-item nav-post-prev d-flex gap-10 align-items-center cms-hover-move-icon-up-left text-accent" href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>">
                    <?php finanzia_svgs_icon([
                        'icon'  => 'core/arrow-left',
                        'class' => 'text-11'
                    ]); ?>
                    <?php echo esc_html__('Prev Post', 'finanzia'); ?>
                </a>
            <?php } else { echo  '<span></span>';} ?>
            <?php if (is_a($next_post, 'WP_Post') && get_the_title($next_post->ID) != '') {
                $next_img_id = get_post_thumbnail_id($next_post->ID);
                $next_img_url = wp_get_attachment_image_src($next_img_id, 'thumbnail');
                ?>
                <a class="nav-item nav-post-next d-flex gap-10 align-items-center cms-hover-move-icon-up text-accent" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>">
                    <?php echo esc_html__('Next Post', 'finanzia'); ?>
                    <?php finanzia_svgs_icon([
                        'icon'  => 'core/arrow-right',
                        'class' => 'text-11'
                    ]); ?>
                </a>
            <?php } ?>
        </div>
    <?php }
}
/**
 * Single Post Comments
 * 
 * Custom Comment List
 * 
*/
function finanzia_comment_list($comment, $args, $depth){
    $add_below = 'comment'; 
    $comment_classes = [empty($args['has_children'])?'':'parent'];
    ?>
    <div id="comment-<?php comment_ID(); ?>" <?php comment_class(implode(' ', array_filter($comment_classes)));?> >
        <div class="d-flex gap-30 gap-mobile-20">
            <div class="comment-avatar flex-auto"><?php if ($args['avatar_size'] != 0) {
                echo get_avatar($comment, 80, '', '', ['class' => 'cms-radius-16']);
            } ?></div>
            <div class="comment-content flex-basic flex-mobile-auto">
                <?php if(is_singular('product')){
                    woocommerce_review_display_rating();
                    echo '<div class="star-rating-clearfix clearfix"></div>';
                } ?>
                <div class="comment-heading d-flex gap-10 align-items-center mt-n5 pb-15 cms-post-meta">
                    <h5 class="comment-name cms-heading text-17 text-accent">
                        <?php printf('%s', get_comment_author_link()); ?>
                    </h5>
                    <div class="meta-separator separator"></div>
                    <div class="comment-meta text-13">
                        <?php echo get_comment_date('M j, Y'). ' - ' . get_comment_time(); ?>
                    </div>
                </div>
                <div class="comment-text text-15"><?php
                    // Comment text
                    comment_text();
                ?></div>
                <div class="comment-reply pt-10"><?php 
                    comment_reply_link(
                        array_merge($args, [
                          'add_below' => $add_below,
                          'depth'     => $depth,
                          'max_depth' => $args['max_depth'],
                          'reply_text' => esc_html__('Reply', 'finanzia').finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17', 'echo' => false])
                        ])
                    ); 
                ?></div>
            </div>
        </div>

<?php }
/**
 * Single Post Comments
 * 
 * Comment Form
 * Move comment field to bottom
 * 
 * **/
//add_filter( 'comment_form_fields', 'finanzia_comment_field_to_bottom' );
function finanzia_comment_field_to_bottom( $fields ) {
    //$comment_field = $fields['comment'];
    //unset( $fields['comment'] );
    //unset( $fields['cookies'] );
    //$fields['comment'] = $comment_field;
    return $fields;
}

/**
 * Single Post Comments
 * 
 * Comment Form
 * Comment form fields
**/
if(!function_exists('finanzia_comment_form_args')){
    function finanzia_comment_form_args($args = []){
        $args = wp_parse_args($args, []);
        global $post;
        $post_id       = $post->ID;
        $commenter     = wp_get_current_commenter();
        $user          = wp_get_current_user();
        $user_identity = $user->exists() ? $user->display_name : '';
        if ( ! isset( $args['format'] ) ) {
            $args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
        }

        $req   = get_option( 'require_name_email' );
        $html5 = 'html5' === $args['format'];

        // Define attributes in HTML5 or XHTML syntax.
        $required_attribute = ( $html5 ? ' required' : ' required="required"' );
        $checked_attribute  = ( $html5 ? ' checked' : ' checked="checked"' );

        // Identify required fields visually and create a message about the indicator.
        $required_indicator = ' *';//' ' . wp_required_field_indicator();
        $required_text      = ' ' . wp_required_field_message();

        $comment_note_before = sprintf(
            '<p class="comment-notes">%s%s</p>',
            sprintf(
                '<span id="email-notes">%s</span>',
                __( 'Your email address will not be published.', 'finanzia' )
            ),
            $required_text
        );

        $cms_comment_fields = array(
            'id_form'              => 'commentform',
            'title_reply_before'   => '<h3 id="reply-title" class="comment-reply-title d-flex align-items-center gap-10 text-26">',
            'title_reply_after'   => '</h3>'.$comment_note_before,
            'title_reply'          => is_singular('product') ? esc_attr__('Add A Review','finanzia') : esc_attr__( 'Leave A Reply', 'finanzia'),
            'title_reply_to'       => is_singular('product') ? esc_attr__('Leave A Review To','finanzia').'%s' : esc_attr__('Leave A Reply To','finanzia').'%s',
            'cancel_reply_link'    => is_singular('product') ? esc_attr__( 'Cancel Review', 'finanzia') : esc_attr__( 'Cancel Reply', 'finanzia'),
            'id_submit'            => 'submit',
            'class_submit'         => 'btn-cmt-submit btn btn-accent btn-hover-accent-darken text-white text-hover-white cms-hover-move-icon-right',
            'label_submit'         => is_singular('product') ? esc_attr__('Submit Review','finanzia') : esc_attr__('Submit Comment','finanzia'),
            'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">%4$s'.finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'echo' => false, 'class' => 'text-17 rtl-flip']).'</button>',
            'submit_field'         => '<div class="form-submit pt-30">%1$s %2$s</div>',
            'comment_notes_before' => '',
            'fields'               => [
                'open'   => '<div class="d-flex gutterX-30 gutterY-20 pt-20">',    
                'author' => sprintf(
                    '<div class="comment-form-author col-6 col-mobile-extra-6 col-mobile-12">%s</div>',
                    sprintf(
                        //'<label class="label flex-wrap gap-5">%s%s'.
                        '<input id="author" name="author" type="text" value="%s" size="30" maxlength="245" autocomplete="name"%s placeholder="%s"/>',
                        //.'</label>',
                        //esc_html__('Your Name', 'finanzia'),
                        //( $req ? $required_indicator : '' ),
                        esc_attr( $commenter['comment_author'] ),
                        ( $req ? $required_attribute : '' ),
                        __( 'Your Name', 'finanzia' )
                    )
                ),
                'email'  => sprintf(
                    '<div class="comment-form-email col-6 col-mobile-extra-6 col-mobile-12">%s</div>',
                    sprintf(
                        //'<label class="label flex-wrap gap-5">%s%s'.
                        '<input id="email" name="email" %s value="%s" size="30" maxlength="100" aria-describedby="email-notes" autocomplete="email"%s placeholder="%s" />',
                        //.'</label>',
                        //esc_html__('Email Address', 'finanzia'),
                        //( $req ? $required_indicator : '' ),
                        ( $html5 ? 'type="email"' : 'type="text"' ),
                        esc_attr( $commenter['comment_author_email'] ),
                        ( $req ? $required_attribute : '' ),
                        __( 'Email Address', 'finanzia' )
                    )
                ),
                'url'  => sprintf(
                    '<div class="comment-form-url col-12">%s</div>',
                    sprintf(
                        //'<label class="label flex-wrap gap-5">%s%s'.
                        '<input id="url" name="url" %s value="%s" size="30" maxlength="100" aria-describedby="email-notes" autocomplete="email"%s placeholder="%s" />',
                        //.'</label>',
                        //esc_html__('Website','finanzia'),
                        //( $req ? $required_attribute : '' ),
                        ( $html5 ? 'type="url"' : 'type="text"' ),
                        esc_attr( $commenter['comment_author_url'] ),
                        ( $req ? $required_attribute : '' ),
                        __( 'Website', 'finanzia' )
                    )
                ),
                'close' => '</div>'
            ],
            'comment_field' => sprintf(
                '<div class="comment-form-comment">%1$s%2$s%3$s</div>',
                do_action('finanzia_before_comment_field'),
                sprintf(
                    //'<label class="label flex-wrap gap-5">%s%s'.
                    '<textarea id="comment" name="comment" cols="45" rows="4" maxlength="65525" %s placeholder="%s"></textarea>',
                    //.'</label>',
                    //esc_html__('Comment','finanzia'),
                    //$required_indicator,
                    $required_attribute,
                    is_singular('product') ? esc_html__( 'Your Review', 'finanzia' ) : esc_html__( 'Your Comment', 'finanzia' )
                ),
                do_action('finanzia_after_comment_field')
            )
        );
        return $cms_comment_fields;
    }
}
/**
 * Single Post
 * 
 * Comment Form
 * Comment reply link
**/
add_filter( 'comment_reply_link', 'finanzia_comment_reply_link_class' );
if(!function_exists('finanzia_comment_reply_link_class')){
    function finanzia_comment_reply_link_class( $class ) {
        $class = str_replace( 'class="comment-reply-link', 'class="comment-reply-link cms-hover-move-icon-right cms-hover-underline d-inline-flex gap-10 align-items-center text-15 text-accent font-700', $class );
        return $class;
    }
}

/**
 * Single Post
 * 
 * Comment Form Styles
 * 
 * */
add_action('comment_form_before', 'finanzia_comment_form_before');
function finanzia_comment_form_before(){
    $form_style = [
        '--cms-form-field-height:58px',
        '--cms-form-field-border:none',
        '--cms-form-field-border-hover:none',
        '--cms-form-field-radius:0',
        '--cms-form-field-border-style:solid',
        '--cms-form-field-border-width:0 0 1px 0',
        '--cms-form-field-border-color:var(--cms-stroke-dark)',
        '--cms-form-field-textarea-border-width:1px',
        '--cms-form-field-padding-start:10px',
        '--cms-form-field-padding-end:10px',
    ];
?>
    <div class="cms-cmt-style" style="<?php echo implode(';', $form_style); ?>">
<?php }

add_action('comment_form_after', 'finanzia_comment_form_after');
function finanzia_comment_form_after(){
    // Close style for comment form '.cms-cmt-style'
?>
    </div>
<?php }

/**
 * Get category taxomomy name by post type
 * 
 * */
function finanzia_post_taxonomy_category(){
    switch (get_post_type()) {
        case 'cms-industry':
            return 'industry-category';
            break;
        case 'cms-service':
            return 'service-category';
            break;
        case 'cms-case':
            return 'case-category';
            break;
        case 'cms-career':
            return 'career-category';
            break;
        default:
            return 'category';
            break;
    }
}

/**
 * Custom Search Form
 * 
 * */
add_filter('search_form_args', 'finanzia_search_form_args');
function finanzia_search_form_args($args){
    ob_start();
        include get_template_directory() . '/assets/svgs/core/search.svg';
    $btn_icon = ob_get_clean();
    $args = wp_parse_args($args, [
        'class'       => 'cms-search-form d-flex gap',
        'placeholder' => finanzia_get_opt( 'search_field_placeholder', esc_html__('Search...','finanzia') ),
        'field_class' => 'cms-search-field',
        'btn_text'    => esc_html__('Search', 'finanzia'),
        'btn_icon'    => $btn_icon,
        'btn_class'   => 'cms-search-submit text-20 text-accent'
    ]);
    return $args;
}
/**
 * 
 *   Theme Configs
 * 
*/
if (!function_exists('finanzia_configs')) {
    function finanzia_configs($value)
    {
        // accent color 
        $accent_color   = apply_filters('finanzia_accent_color', [
            'regular' => '#223140',
            'darken'  => '#051423'
        ]);
        // primary color
        $primary_color   = apply_filters('finanzia_primary_color', [
            'regular'  => '#091019',
            'lighten'  => '#B1B9C1' 
        ]);
        // Custom Color
        $custom_color = apply_filters('finanzia_custom_color', [
            'green'       => '#6E997F',
            'light-green' => '#89B49B',
            'purple'      => '#717CA3',
            'light-purle' => '#8A93B1',
            'grey'        => '#EEF1F3',
            'stroke1'     => '#223140',
            'divider'     => '#E4E9F1',
            'divider-dark'=> '#2C3F51',
            'stroke-dark' => '#A7ADB3'
        ]);
        // Body
        $body_color = apply_filters('finanzia_body_color',[
            'regular' => '#42484E'
        ]);
        // logo
        $logo_w       = '160';
        $logo_h       = '32';
        $logo_w_sm    = '24';
        $logo_h_sm    = '32';
        $menu_color = ['regular' => $accent_color['regular'], 'hover' => $accent_color['regular'], 'active' => $accent_color['regular']];
        $transparent_menu_color = ['regular' => '#ffffff', 'hover' => '#ffffff', 'active' => '#ffffff'];
        $header_height = '93';
        $header_width = '320';

        // body typo
        $body_font_default = apply_filters('finanzia_body_font',[ 'font_family' => 'DM Sans', 'font_style' => '400normal' ]);
        $body_font         = finanzia_get_opts('body_font', 'default');
        $body_font_typo    = ($body_font=='custom') ? finanzia_get_opts('body_font_typo', $body_font_default, 'body_font') : $body_font_default;
        
        // heading typo
        $heading_font_default = apply_filters('finanzia_heading_font', ['font_family' => 'DM Sans', 'font_style' => '700normal']);
        $heading_font         = finanzia_get_opts('heading_font', 'default');
        $heading_font_typo    = ($heading_font =='custom') ? finanzia_get_opts('heading_font_typo', $heading_font_default, 'heading_font') : $heading_font_default;
        $heading_color        = apply_filters('finanzia_heading_color', [
            'regular' => $primary_color['regular']
        ]);
        // Buttons
        $btn_font     = apply_filters('finanzia_btn_font', 'DM Sans');
        // Link
        $link_color = [
            'regular' => $accent_color['regular'], 
            'hover'   => $accent_color['darken'], 
            'active'  => $accent_color['darken']
        ];
        // Meta
        $meta_color = apply_filters('finanzia_meta_color', $body_color['regular']);

        $accent_color_cf = [];
        foreach ($accent_color as $key => $accent_color_value) {
            $accent_color_cf[$key] =  finanzia_get_opts('accent_color', $accent_color, 'color_custom')[$key];
        }
        $primary_color_cf = [];
        foreach ($primary_color as $key => $primary_color_value) {
            $primary_color_cf[$key] =  finanzia_get_opts('primary_color', $primary_color, 'color_custom')[$key];
        }
        $custom_color_cf = [];
        foreach ($custom_color as $key => $custom_color_value) {
            $custom_color_cf[$key] =  finanzia_get_opts('custom_color', $custom_color, 'color_custom')[$key];
        }

        $heading_color_cf = [];
        foreach ($heading_color as $key => $heading_color_value) {
            $heading_color_cf[$key] =  finanzia_get_opts('heading_color', $heading_color, 'color_custom')[$key];
        }
        $configs = [
            // color
            'accent_color'    => $accent_color_cf,
            'primary_color'   => $primary_color_cf,
            'custom_color'    => $custom_color_cf,
            'heading_color'   => $heading_color_cf,
            'link_color' => [
                'regular' => finanzia_get_opts('link_color', $link_color, 'color_custom')['regular'],
                'hover'   => finanzia_get_opts('link_color', $link_color, 'color_custom')['hover'],
                'active'  => finanzia_get_opts('link_color', $link_color, 'color_custom')['active'],
            ],
            // body typo
            'body' => [
                'bg'          => '#fff',
                'family'      => $body_font_typo['font_family'],
                'size'        => '17px',
                'weight'      => substr($body_font_typo['font_style'], 0, 3),
                'style'       => substr($body_font_typo['font_style'], 3),
                'color'       => finanzia_get_opts('body_color', $body_color, 'color_custom')['regular'],
                'line-height' => '1.588235294117647',
            ],
            // Heading typo
            'heading' => [
                'family'      => $heading_font_typo['font_family'],
                'weight'      => substr($heading_font_typo['font_style'], 0, 3),
                'style'       => substr($heading_font_typo['font_style'], 3),
                'line-height' => '1.3'
            ],
            // Meta
            'meta'  => [
                'color' => finanzia_get_opts('meta_color', $meta_color)
            ],
            // Header 
            'header'    => [
                'height' => finanzia_get_opts('header_height', ['height' => $header_height], 'header_custom')['height'].'px'
            ],
            // logo
            'logo'  => [
                'width'     => finanzia_get_opts('logo_maxh',['width' => $logo_w, 'height' => $logo_h], 'header_custom')['width'],
                'height'    => finanzia_get_opts('logo_maxh',['width' => $logo_w, 'height' => $logo_h], 'header_custom')['height'],
                'width-mobile'  => finanzia_get_opts('logo_maxh_sm',['width' => $logo_w_sm, 'height' => $logo_h_sm],'header_custom')['width'],
                'height-mobile' => finanzia_get_opts('logo_maxh_sm',['width' => $logo_w_sm, 'height' => $logo_h_sm],'header_custom')['height']
            ],
            // menu color
            'menu_color' => [
                'regular' => finanzia_get_opts('main_menu_color', $menu_color, 'header_custom')['regular'],
                'hover'   => finanzia_get_opts('main_menu_color', $menu_color, 'header_custom')['hover'],
                'active'  => finanzia_get_opts('main_menu_color', $menu_color, 'header_custom')['active'],
            ],
            // transparent menu color
            'transparent_menu_color' => [
                'regular' => finanzia_get_opts('transparent_menu_color', $transparent_menu_color, 'header_custom')['regular'],
                'hover'   => finanzia_get_opts('transparent_menu_color', $transparent_menu_color, 'header_custom')['hover'],
                'active'  => finanzia_get_opts('transparent_menu_color', $transparent_menu_color, 'header_custom')['active'],
            ],
            // Dropdown

            // Page title
            'ptitle'  => [
                'color'      => '#fff',
                'bg-color'   => finanzia_get_opts('page_title_bg', ['background-color' => 'var(--cms-primary-regular)', 'background-image' => ''], 'custom_ptitle')['background-color'],
                'bg-image'   => 'url('.finanzia_get_opts('page_title_bg', ['background-color' => 'var(--cms-primary-regular)', 'background-image' => ''], 'custom_ptitle')['background-image'].')',
                'bg-overlay' => finanzia_get_opts('page_title_overlay', 'rgba(4,8,13, 0.25)', 'custom_ptitle')
            ]
        ];
        return $configs[$value];
    }
}
if(!function_exists('finanzia_theme_colors')){
    function finanzia_theme_colors($args = []){
        $args = wp_parse_args($args, [
            'custom' => true
        ]);
        $colors = [
            'accent'    => finanzia_configs('accent_color'),
            'primary'   => finanzia_configs('primary_color'),
            'heading'   => finanzia_configs('heading_color')
        ];
        $others = [
            'link' => finanzia_configs('link_color'),
            'body' => ['color' => finanzia_configs('body')['color']],
            'menu' => finanzia_configs('menu_color')
        ];

        $customs = apply_filters('finanzia_elementor_theme_custom_colors', []);
        $opts = ['' => esc_html__('Default','finanzia')];
        foreach ($colors as $key => $value) {
            if(is_array($value)){
                foreach ($value as $_key => $_value) {
                    $opts[$key.'-'.$_key] = $key.' '.$_key.'('.$_value.')';
                }
            } else {
                $opts[$key] = $key.'('.$value.')';
            }
        }
        // Custom Color
        $custom_color = finanzia_configs('custom_color');
        foreach ($custom_color as $key => $value) {
            $opts[$key] = $key.'('.$value.')';
        }
        //
        $opts['body-color']  = esc_html__('Body','finanzia');
        $opts['divider-30']  = esc_html__('Divider/Light Divider','finanzia');
        $opts['divider-55']  = esc_html__('Divider/Stroke Divider','finanzia');
        $opts['white']       = esc_html__('White','finanzia');
        $opts['transparent'] = esc_html__('Transparent','finanzia');
        if($args['custom']){
            $customs['custom'] = esc_html__('Custom','finanzia');
        }
        return array_merge($opts, $customs);
    }
}
if(!function_exists('finanzia_theme_custom_colors')){
    function finanzia_theme_custom_colors(){
        $color = [
            /*'divider-30' => [
                'title' => esc_html__('Divider/ Light Divider','finanzia'),
                'value' => 'rgba(var(--cms-divider-rgb), 0.3)'
            ]*/
        ];
        return apply_filters('finanzia_theme_custom_colors', $color);
    }
}
add_filter('finanzia_elementor_theme_custom_colors', 'finanzia_elementor_theme_custom_colors');
if(!function_exists('finanzia_elementor_theme_custom_colors')){
    function finanzia_elementor_theme_custom_colors(){
        $colors = finanzia_theme_custom_colors();
        $_colors = [];
        foreach ($colors as $key => $color) {
            $_colors[$key] = $color['title'];
        }
        return $_colors;
    }
}

if (!function_exists('finanzia_hex_to_rgb')) {
    function finanzia_hex_to_rgb($color)
    {

        $default = '0,0,0';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided 
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        $output = implode(",", $rgb);

        //Return rgb(a) color string
        return $output;
    }
}

if (!function_exists('finanzia_inline_styles')) {
    function finanzia_inline_styles()
    {
        ob_start();
        // CSS Variable
        $accent_colors          = finanzia_configs('accent_color');
        $primary_colors         = finanzia_configs('primary_color');
        $custom_colors          = finanzia_configs('custom_color');
        // Global
        $body                   = finanzia_configs('body');
        $heading                = finanzia_configs('heading');
        $heading_colors         = finanzia_configs('heading_color');
        $meta                   = finanzia_configs('meta');
        $link_color             = finanzia_configs('link_color');
        // Header
        $header                 = finanzia_configs('header');
        $logo                   = finanzia_configs('logo');
        $menu_color             = finanzia_configs('menu_color');
        $transparent_menu_color = finanzia_configs('transparent_menu_color');
        // Page Title
        $ptitle                 = finanzia_configs('ptitle');
        // Custom Color
        $customs_colors = finanzia_theme_custom_colors();
        echo ':root{';
        // color rgb
        foreach ($accent_colors as $key => $value) {
            printf('--cms-accent-%1$s-rgb: %2$s;', str_replace('#', '', $key), finanzia_hex_to_rgb($value));
        }
        foreach ($primary_colors as $key => $value) {
            printf('--cms-primary-%1$s-rgb: %2$s;', str_replace('#', '', $key), finanzia_hex_to_rgb($value));
        }
        foreach ($custom_colors as $key => $value) {
            printf('--cms-%1$s-rgb: %2$s;', str_replace('#', '', $key), finanzia_hex_to_rgb($value));
        }
        foreach ($heading_colors as $key => $value) {
            printf('--cms-heading-%1$s-rgb: %2$s;', str_replace('#', '', $key), finanzia_hex_to_rgb($value));
        }
        // color hex
        foreach ($accent_colors as $key => $value) {
            printf('--cms-accent-%1$s: %2$s;', str_replace('#', '', $key), $value);
        }
        foreach ($primary_colors as $key => $value) {
            printf('--cms-primary-%1$s: %2$s;', str_replace('#', '', $key), $value);
        }
        foreach ($custom_colors as $key => $value) {
            printf('--cms-%1$s: %2$s;', str_replace('#', '', $key), $value);
        }
        foreach ($heading_colors as $key => $value) {
            printf('--cms-heading-%1$s: %2$s;', str_replace('#', '', $key), $value);
        }
        // Body
        foreach ($body as $key => $value) {
            if($key === 'family') $value = $value.', sans-serif';
            printf('--cms-body-%1$s: %2$s;', $key, $value);
        }
        // Heading
        foreach ($heading as $key => $value) {
            if($key === 'family') $value = $value.', sans-serif';
            printf('--cms-heading-%1$s: %2$s;', $key, $value);
        }
        // meta
        foreach ($meta as $key => $value) {
            printf('--cms-meta-%1$s: %2$s;', $key, $value);
        }
        // link color
        foreach ($link_color as $color => $value) {
            printf('--cms-link-%1$s-color: %2$s;', $color, $value);
        }
        // Header
        foreach ($header as $key => $value) {
            printf('--cms-header-%1$s: %2$s;', $key, $value);
            printf('--cms-header-width: %2$s;', $key, $value);
        }
        // Logo
        foreach ($logo as $key => $value) {
            printf('--cms-logo-%1$s: %2$s;', $key, $value.'px');
        }
        // Menu color
        foreach ($menu_color as $color => $value) {
            printf('--cms-menu-%1$s: %2$s;', $color, $value);
        }
        // Menu color rgb
        foreach ($menu_color as $color => $value) {
            printf('--cms-menu-%1$s-rgb: %2$s;', str_replace('#', '', $color), finanzia_hex_to_rgb($value));
        }
        // Transparent Menu color
        foreach ($transparent_menu_color as $color => $value) {
            printf('--cms-menu-transparent-%1$s: %2$s;', $color, $value);
        }
        // Transparent Menu color rgb
        foreach ($transparent_menu_color as $color => $value) {
            printf('--cms-menu-transparent-%1$s-rgb: %2$s;', str_replace('#', '', $color), finanzia_hex_to_rgb($value));
        }
        // Page title
        foreach ($ptitle as $key => $value) {
            printf('--cms-ptitle-%1$s: %2$s;', $key, $value);
        }
        // Custom Color
        foreach ($customs_colors as $key => $value) {
            printf('--cms-%1$s: %2$s;', $key, $value['color']);
        }
        // Popup
        printf('--cms-popup-max-width:'.finanzia_get_opts('popup_max_w', ['width' => 620], 'popup_custom')['width'].'px;');
        // Content Width
        printf('--cms-content-width:880px;');
        echo '}';
        return ob_get_clean();
    }
}
// end function for inline style

/**
 * @param string $str - String containing line breaks
 * 
 */
function finanzia_nl2html($str,  $args = [])
{
    $args = wp_parse_args($args, [
        'item_before' => '<div>',
        'item_after'  => '</div>',
        'before'      => '',
        'after'       => ''
    ]);
    $bits = explode("\n", $str);

    if (empty($bits[0])) return;

    $newstring = [];
    foreach ($bits as $bit) {
        $newstring[] = $args['item_before'] . $bit . $args['item_after'];
    }
    return $args['before'] . implode('', $newstring) . $args['after'];
}

/**
 * Render Attributes
 * 
 * */
if(!function_exists('finanzia_render_attrs')){
    function finanzia_render_attrs($attrs = [], $echo = true){
        if(!is_array($attrs) || empty($attrs)) return;
        $atts = [];
        foreach ($attrs as $key => $attr) {
            $atts[] = $key.'="'.implode(' ', array_filter((array)$attr)).'"';
        }
        return implode(' ', array_filter($atts));
    }
}
/**
 * Render Iframe
 * */
function wealth_print_iframe($args = []){
    $args = wp_parse_args($args, [
        'loading'    => 'lazy',
        'src'        => '', 
        'title'      => '',
        'aria-label' => ''
    ]);
    $attrs = finanzia_render_attrs($args);

    printf('%1$s%2$s %3$s %4$s %5$s%6$s', '<i', 'frame', $attrs, '>', '</i', 'frame>');
}
/**
 * Theme Options
 * 
 * **/
/**
 * Get Page List
 * @return array
 */
if (!function_exists('finanzia_list_page')) {
    function finanzia_list_page($default = [])
    {
        $page_list = array();
        if (!empty($default))
            $page_list[$default['value']] = $default['label'];
        $pages = get_pages(array('hierarchical' => 0, 'posts_per_page' => '-1'));
        foreach ($pages as $page) {
            $page_list[$page->ID] = $page->post_title;
        }
        return $page_list;
    }
}

/**
 * Get Post List
 * @return array
 */
if (!function_exists('finanzia_list_post')) {
    function finanzia_list_post($post_type = 'post', $default = false)
    {
        $post_list = array();
        if ($default) {
            $post_list['none'] = esc_html__('None', 'finanzia');
            $post_list['-1'] = esc_html__('Default', 'finanzia');
        }
        $posts = get_posts(array('post_type' => $post_type, 'posts_per_page' => '-1'));
        foreach ($posts as $post) {
            $post_list[$post->ID] = $post->post_title;
        }
        return $post_list;
    }
}

/**
 * Get theme option based on its id.
 *
 * @param string $opt_id Required. the option id.
 * @param mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
function finanzia_get_opt($opt_id, $default = false){
    $opt_name = finanzia_get_opt_name();
    if (empty($opt_name)) {
        return $default;
    }
    global ${$opt_name};
    if (!isset(${$opt_name}) || !isset(${$opt_name}[$opt_id])) {
        $options = get_option($opt_name);
    } else {
        $options = ${$opt_name};
    }
    if (
        !isset($options) ||
        !isset($options[$opt_id]) ||
        $options[$opt_id] === ''
    ) {
        return $default;
    }
    if (is_array($options[$opt_id]) && is_array($default)) {
        foreach ($options[$opt_id] as $key => $value) {
            if (isset($default[$key]) && $value === '') {
                $options[$opt_id][$key] = $default[$key];
            }
        }
    }
    return $options[$opt_id];
}

/**
 * Get theme option based on its id.
 *
 * @param string $opt_id Required. the option id.
 * @param mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
function finanzia_get_page_opt($opt_id, $default = false){
    $page_opt_name = finanzia_get_page_opt_name();
    if (empty($page_opt_name)) {
        return $default;
    }
    $id = get_the_ID();
    if (!is_archive() && is_home()) {
        if (!is_front_page()) {
            $page_for_posts = get_option('page_for_posts');
            $id = $page_for_posts;
        }
    }
    // Search
    if(is_search()){
        $id = '';
    }
    // Get page option for Shop Page
    if (class_exists('WooCommerce') && is_shop()) {
        $id = get_option('woocommerce_shop_page_id');
    }

    return $options = !empty($id) ? get_post_meta(intval($id), $opt_id, true) : $default;
}

/**
 *
 * Get post format values.
 *
 * @param $post_format_key
 * @param bool $default
 *
 * @return bool|mixed
 */
function finanzia_get_post_format_value( $id = null, $post_format_key = '', $default = '' ) {
    global $post;
    if ( $id === null ) {
        $id = $post->ID;
    }

    return $value = ( ! empty( $id ) && '' !== get_post_meta( $id, $post_format_key, true ) ) ? get_post_meta( $id, $post_format_key, true ) : $default;
}

/**
 * Get option based on its id.
 * get option of theme and page
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 * @return mixed
 */
function finanzia_get_opts($opt_id, $default = false, $dependency = ''){
    $theme_opt = finanzia_get_opt($opt_id, $default);
    $_dependency = finanzia_get_page_opt($dependency);
    if($dependency === 'on' || $_dependency === 'on' || $_dependency === 'custom'){
        $page_opt = finanzia_get_page_opt($opt_id, $theme_opt);
        if ($page_opt !== null && $page_opt !== '' && $page_opt !== '-1' && $page_opt !== '0') {
        //if (!in_array($page_opt, [null,'','-1', 0]) ) {
            if (is_array($page_opt) && is_array($theme_opt)) {
                foreach ($page_opt as $key => $value) {
                    foreach ($theme_opt as $key => $value) {
                        if (empty($page_opt[$key]) || $page_opt[$key] === 'px') {
                            $page_opt[$key] = $theme_opt[$key];
                        }
                    }
                }
            }
            $theme_opt = $page_opt;
        }
    }
    return $theme_opt;
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function finanzia_get_opt_name_default(){
    return apply_filters('finanzia_opt_name', 'cms_theme_options');
}
function finanzia_get_opt_name(){
    if (isset($_POST['opt_name']) && !empty($_POST['opt_name'])) {
        return sanitize_text_field($_POST['opt_name']);
    }
    $opt_name = finanzia_get_opt_name_default();
    if (defined('ICL_LANGUAGE_CODE')) {
        if (ICL_LANGUAGE_CODE != 'all' && !empty(ICL_LANGUAGE_CODE)) {
            $opt_name = $opt_name . '_' . ICL_LANGUAGE_CODE;
        }
    }

    return $opt_name;
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function finanzia_get_page_opt_name(){
    return apply_filters('finanzia_page_opt_name', 'cms_page_options');
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function finanzia_get_post_opt_name(){
    return apply_filters('finanzia_post_opt_name', 'finanzia_post_options');
}
/*====== End Theme Option ==========*/
/**
 * Elementor
 * All function for Elementor
 * 
 * **/

/**
 * Ajax Pagination
 * Use in Element Post Grid/Blog
 * 
 * */
if (!function_exists('finanzia_ajax_paginate_links')) {
    function finanzia_ajax_paginate_links($link)
    {
        $parts = parse_url($link);
        if(isset($parts['query'])){
            parse_str($parts['query'], $query);
            if (isset($query['page']) && !empty($query['page'])) {
                return '#' . $query['page'];
            } else {
                return '#1';
            }
        }
    }
}

/**
 * Custom WP Menu
 * 
 * */
// Menu list for theme options, elementor element, ...
if(!function_exists('finanzia_menu_list')){
    function finanzia_menu_list(){
        $finanzia_menu_list = [
            '_1'      => esc_html__('Default', 'finanzia'),
            'primary' => esc_html__('Finanzia Primary Menu', 'finanzia')
        ];
        //$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        $menus  = wp_get_nav_menus();
        if ( is_array( $menus ) && ! empty( $menus ) ) {
            foreach ( $menus as $single_menu ) {
                if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
                    $finanzia_menu_list[ $single_menu->term_id ] = $single_menu->name;
                }
            }
        }
        return apply_filters('finanzia_menu_list', $finanzia_menu_list);
    }
}
// add class to li 
function add_additional_class_on_li($classes, $item, $args) {
    if(isset($args->li_class) && !empty($args->li_class)) {
        $classes[] = $args->li_class;
    }
    return $classes;
}
add_filter('nav_menu_css_class', 'add_additional_class_on_li', 1, 3);
// add class to link
add_filter('nav_menu_link_attributes', function ($atts, $item, $args, $depth) {
    $atts['class'] = 'cms-menu-link';
    // For Level 1
    if(isset($args->lv1_class) && !empty($args->lv1_class) && $depth === 0){
        $atts['class'] .= ' '.$args->lv1_class;
    }
    // For all
    if(isset($args->link_class) && !empty($args->link_class)){
        $atts['class'] .= ' '.$args->link_class;
    }
    return $atts;
}, 10, 4);

// Custom Menu title
add_filter('nav_menu_item_title', 'finanzia_nav_menu_item_title', 10, 2);
function finanzia_nav_menu_item_title($title){
    $title = '<span class="menu-title title flex-basic d-flex gap-10">'.$title.'</span>';
    return $title;
}
/**
 *  Menu type Category
 *  add post count to menu title
*/
//add_filter('the_title', 'finanzia_menu_item_category_count', 10, 2);
function finanzia_menu_item_category_count($title, $post_ID)
{
    if( 'nav_menu_item' == get_post_type($post_ID) )
    {
        if( 'taxonomy' == get_post_meta($post_ID, '_menu_item_type', true) && 'category' == get_post_meta($post_ID, '_menu_item_object', true) )
        {
            $category = get_category( get_post_meta($post_ID, '_menu_item_object_id', true) );
            $title .= sprintf('<span class="count">%d</span>', $category->count);
            //$title .= '<span class="arrow cmsi-arrow-circle-right rtl-flip text-26"></span>';
        }
    }
    return $title;
}
/**
 * Mega Menu
 * 
 * **/
class Finanzia_Mega_Menu_Walker extends Walker_Nav_Menu
{
    private $item;

    /**
     * Starts the list before the elements are added.
     *
     * @since 3.0.0
     *
     * @see Walker::start_lvl()
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of menu item. Used for padding.
     * @param array $args An array of wp_nav_menu() arguments.
     */
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $sub_menu_class = isset($args->sub_menu_class) ? $args->sub_menu_class : '';
        $sub_menu_classes = implode(' ', array_filter(['sub-menu',$sub_menu_class]));
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"$sub_menu_classes\">\n";
    }

    /**
     * @see Walker::start_el()
     */
    public function start_el(&$output, $item, $depth = 0, $args = array('icon_class'=>''), $id = 0)
    {
        $item_html = '';
        $megamenu = apply_filters('cms_enable_megamenu', false);

        if ('[divider]' === $item->title) {
            $output .= '<li class="menu-item-divider"></li>';
            return;
        }
        if ('[logo]' === $item->title) {
            $output .= '<li class="menu-item-logo"></li>';
            return;
        }

        $extra_menu_custom = apply_filters("cms_menu_edit", array());
        foreach ($extra_menu_custom as $key => $f) {
            $val = get_post_meta($item->ID, '_menu_item_' . $key, true);
            if (!empty($val)) {
                $item->classes[] = $val;
            }
        }
        // children/toggle icon 
        if($args->walker->has_children || (!empty($item->cms_megaprofile) && $megamenu) )
        {
            $args->old_link_after = $args->link_after;
            if($depth == 0){
                $args->link_after = $this->menu_parent_icon() . $args->link_after ;
            } else {
                $args->link_after = $this->menu_dropdown_parent_icon() . $args->link_after ;
            }
        }
        // custom icon for child-menu
        $cms_menu_child_icon = apply_filters('cms_menu_child_icon', false);
        if($cms_menu_child_icon && $depth > 0){
            $args->old_link_before = $args->link_before;
            $args->link_before = $cms_menu_child_icon . $args->link_before ;
        }
        // megamenu
        if (!empty($item->cms_megaprofile) && $megamenu) {
            $item->classes[] = 'megamenu';
            $item->classes[] = 'menu-item-has-children';
        }
        switch ($item->cms_megaprofile_full) {
            case '0':
                break;
            case '1':
                $item->classes[] = 'megamenu-full';
                break;
            default:
                $item->classes[] = 'megamenu-'.$item->cms_megaprofile_full;
                break;
        }

        if (!empty($item->cms_icon)) {
            $item->classes[] = 'has-icon';
            $icon_class = [
                'menu-icon',
                'order-'.$item->cms_icon_position,
                $item->cms_icon,
                $args->icon_class
            ];
            $item->title .= '<span class="' . implode(' ', array_filter($icon_class)) . '"></span>';
        }
        // Sub Menu
        parent::start_el($item_html, $item, $depth, $args, $id);

        // Link before
        if (isset($args->old_link_before)) {
            $args->link_before = $args->old_link_before;
            $args->old_link_before = '';
        }
        // link after
        if (isset($args->old_link_after)) {
            $args->link_after = $args->old_link_after;
            $args->old_link_after = '';
        }
        // mega menu
        if (!empty($item->cms_megaprofile)) {
            //$output = '';
            $megamenu_class = ['sub-menu sub-megamenu'];
            switch ($item->cms_megaprofile_full) {
                case '0':
                    $megamenu_class[] = 'cms-megamenu-auto';
                    break;
                case '1':
                    $megamenu_class[] = 'cms-megamenu-full';
                    break;
                default:
                    $megamenu_class[] = 'cms-megamenu-'.$item->cms_megaprofile_full;
                    break;
            }
            $megamenu_class = apply_filters('cms_megamenu_classes', $megamenu_class );
            $item_html .= '<div class="'.implode(' ', array_filter($megamenu_class)).'">';
                $item_html .= $this->get_megamenu($item->cms_megaprofile);
            $item_html .= '</div>';
        }

        $output .= $item_html;
    }

    public function get_megamenu($id)
    {
        $content = class_exists('\Elementor\Plugin') ? \Elementor\Plugin::$instance->frontend->get_builder_content( $id ) : '';
        $megamenu = apply_filters('cms_enable_megamenu', false);
        if ($megamenu && !empty($content))
            return  $content;
        else
            return false;
    }
    // Menu parent icon
    public function menu_parent_icon(){
        // icon
        return finanzia_svgs_icon([
            'icon'  => 'core/chevron-down',
            'class' => 'main-menu-toggle text-8',
            'echo'  => false
        ]);
    }
    // Menu Dropdown Parent Icon
    public function menu_dropdown_parent_icon(){
        // icon
        return finanzia_svgs_icon([
            'icon'  => 'core/chevron-right',
            'class' => 'main-menu-toggle text-6',
            'echo'  => false
        ]);
    }
}
/**
 * Menu Toggle
 * 
 */
class Finanzia_Toggle_Menu_Walker extends Walker_Nav_Menu
{
    private $item;

    /**
     * Starts the list before the elements are added.
     *
     * @since 3.0.0
     *
     * @see Walker::start_lvl()
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of menu item. Used for padding.
     * @param array $args An array of wp_nav_menu() arguments.
     */
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $sub_menu_class = isset($args->sub_menu_class) ? $args->sub_menu_class : '';
        $sub_menu_classes = implode(' ', array_filter(['sub-menu','sub-menu-toggle',$sub_menu_class]));
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"$sub_menu_classes\">\n";
    }

    /**
     * @see Walker::start_el()
     */
    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        $item_html = '';
        $megamenu = apply_filters('cms_enable_megamenu', false);

        if ('[divider]' === $item->title) {
            $output .= '<li class="menu-item-divider"></li>';
            return;
        }

        $extra_menu_custom = apply_filters("cms_menu_edit", array());
        foreach ($extra_menu_custom as $key => $f) {
            $val = get_post_meta($item->ID, '_menu_item_' . $key, true);
            if (!empty($val)) {
                $item->classes[] = $val;
            }
        }
        // children/toggle icon 
        if($args->walker->has_children || (!empty($item->cms_megaprofile) && $megamenu) )
        {
            $args->old_link_after = $args->link_after;
            if($depth == 0){
                $args->link_after = $this->menu_parent_icon($args) . $args->link_after ;
            } else {
                $args->link_after = $this->menu_dropdown_parent_icon($args) . $args->link_after ;
            }
        }
        
        // custom icon for child-menu
        /*$cms_menu_child_icon = apply_filters('cms_menu_child_icon', false);
        if($cms_menu_child_icon){
            $args->old_link_after = $args->link_after;
            $args->link_after = $cms_menu_child_icon . $args->link_after ;
        }*/
        // megamenu
        if (!empty($item->cms_megaprofile) && $megamenu) {
            $item->classes[] = 'megamenu';
            $item->classes[] = 'menu-item-has-children';
        }

        if (!empty($item->cms_icon)) {
            $item->classes[] = 'has-icon';
            $icon_class = [
                'menu-icon',
                'order-'.$item->cms_icon_position,
                $item->cms_icon,
                $args->icon_class
            ];
            $item->title .= '<i class="' . implode(' ', array_filter($icon_class)) . '"></i>';
        }
        // Menu Icon 
        if(isset($args->menu_icon) && !empty($args->menu_icon)){
            $item->title =  $args->menu_icon. $item->title ;
        }
        // Show Taxonomy Count
        $tax_count = isset($args->count) ? (int) $args->count : '';
        if($tax_count === 1 && $item->type == 'taxonomy'){
            $taxonomy = get_term($item->object_id);
            //$item->title .= sprintf('&nbsp;<span class="cms-menu-count tax-count">(%d)</span>', $taxonomy->count);
            $args->old_link_after = $args->link_after;
            $args->link_after = sprintf('<span class="cms-menu-count tax-count style-1">(%d)</span>', $taxonomy->count) . $args->link_after ;
        }
        if($tax_count === 2 && $item->type == 'taxonomy'){
            $taxonomy = get_term($item->object_id);
            //$item->title .= sprintf('&nbsp;<span class="cms-menu-count tax-count">(%d)</span>', $taxonomy->count);
            $args->old_link_after = $args->link_after;
            $args->link_after = '<span class="cms-menu-count tax-count style-2">'.sprintf( _n( '%s item', '%s items', $taxonomy->count, 'finanzia' ),  esc_html( $taxonomy->count ) ).'</span>' . $args->link_after ;
        }
        if($tax_count === 3 && $item->type == 'taxonomy'){
            $taxonomy = get_term($item->object_id);
            //$item->title .= sprintf('&nbsp;<span class="cms-menu-count tax-count">(%d)</span>', $taxonomy->count);
            $args->old_link_after = $args->link_after;
            $args->link_after = sprintf('<span class="cms-menu-count tax-count count">%d</span>', $taxonomy->count) . $args->link_after ;
        }
        // Show Taxonomy Image
        $tax_image = isset($args->tax_image) ? $args->tax_image : '';
        if($tax_image === '1' && $item->type == 'taxonomy'){
            $taxonomy = get_term($item->object_id);
            $thumbnail_id = get_term_meta( $taxonomy->term_id, 'thumbnail_id', true );
            //echo wp_get_attachment_image($thumbnail_id, 'full');
            $args->old_link_before = $args->link_before;
            $args->link_before = wp_get_attachment_image($thumbnail_id, 'full'). $args->link_before ;

        }
        parent::start_el($item_html, $item, $depth, $args, $id);

        if (isset($args->old_link_before)) {
            $args->link_before = $args->old_link_before;
            $args->old_link_before = '';
        }

        if (isset($args->old_link_after)) {
            $args->link_after = $args->old_link_after;
            $args->old_link_after = '';
        }

        if (!empty($item->cms_megaprofile)) {
            $item_html .= $this->get_megamenu($item->cms_megaprofile);
        }

        $output .= $item_html;
    }

    public function get_megamenu($id)
    {
        $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $id );
        $megamenu = apply_filters('cms_enable_megamenu', false);
        if ($megamenu)
            return '<ul class="sub-menu sub-megamenu sub-menu-toggle"><li>' . $content . '</li></ul>';
        else
            return false;
    }
    // Menu parent icon
    public function menu_parent_icon($args = array()){
        // icon
        $icon = (isset($args->parent_icon) && !empty($args->parent_icon)) ? $args->parent_icon : 'core/chevron-right';
        $icon_class = (isset($args->parent_icon_class) && !empty($args->parent_icon_class)) ? $args->parent_icon_class : 'text-6';
        return finanzia_svgs_icon([
            'icon'  => $icon,
            'class' => 'main-menu-toggle '.$icon_class,
            'echo'  => false
        ]);
    }
    // Menu Dropdown Parent Icon
    public function menu_dropdown_parent_icon($args = array()){
        // icon
        $icon = (isset($args->dropdown_parent_icon) && !empty($args->dropdown_parent_icon)) ? $args->dropdown_parent_icon : 'core/chevron-right';
        $icon_class = (isset($args->parent_icon_class) && !empty($args->parent_icon_class)) ? $args->parent_icon_class : 'text-6';
        return finanzia_svgs_icon([
            'icon'  => $icon,
            'class' => 'main-menu-toggle '.$icon_class,
            'echo'  => false
        ]);
    }
}
/**
 * Custom Menu Icons
 * Remove menu font icon
 * */
add_filter('cms_mega_menu/get_icons', 'finanzia_cms_mega_menu_icons');
if(!function_exists('finanzia_cms_mega_menu_icons')){
    function finanzia_cms_mega_menu_icons(){
        $icons = [];
        return $icons;
    }
}
add_filter('cms_menu_child_icon', 'finanzia_cms_menu_child_icon');
function finanzia_cms_menu_child_icon(){
    $icon = finanzia_svgs_icon([
        'icon'      => 'divider',
        'icon_size' => 15,
        'class'     => 'menu-child-icon flex-auto',
        'echo'      => false
    ]);
    return $icon;
}

/**
 * Widget Search
 * 
 * */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'CMS_Search' );
    });

    class CMS_Search extends WP_Widget
    {
        function __construct()
        {
            parent::__construct(
                'cms_search',
                esc_html__( '*CMS Search', 'finanzia' ),
                array(
                    'description'                 => esc_attr__( 'Shows search form.', 'finanzia' ),
                    'customize_selective_refresh' => true,
                )
            );
        }

        /**
         * Outputs the HTML for this widget.
         *
         * @param array $args An array of standard parameters for widgets in this theme
         * @param array $instance An array of settings for this widget instance
         * @return void Echoes it's output
         **/
        function widget( $args, $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'       => '',
                'placeholder' => esc_html__('Search...', 'finanzia')
            ) );

            $title = empty( $instance['title'] ) ? '' : $instance['title'];
            $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

            $placeholder = empty( $instance['placeholder'] ) ? '' : $instance['placeholder'];

            printf( '%s', $args['before_widget']);

            if(!empty($title)){
                printf( '%s %s %s', $args['before_title'] , $title , $args['after_title']);
            }

            // Form Style
            $form_style = [
                '--cms-form-field-height:68px',
                '--cms-form-field-border:0',
                '--cms-form-field-padding-end:68px',
                '--cms-form-field-padding-start:30px',
                '--cms-form-field-bg-color:white',
                '--cms-form-field-radius:35px',
                '--cms-form-btn-color:var(--cms-accent)',
                '--cms-form-btn-color-hover:var(--cms-accent)'
            ];
        ?>
        <form method="get" class="cms-wgsearch-form relative" action="<?php echo esc_url( home_url( '/' ) ); ?>" style="<?php echo implode(';', $form_style); ?>">
            <input type="text" name="s" class="cms-wgsearch-field cms-radius-12 w-100" placeholder="<?php echo esc_attr( $placeholder );?>"/>
            <button type="submit" class="cms-wgsearch-submit text-20 absolute top-right h-100">
                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
                    <path d="M13.516 0.030c-3.966 0.299-7.588 2.16-10.138 5.212-1.787 2.138-2.917 4.742-3.266 7.52-0.222 1.767-0.115 3.565 0.318 5.31 0.145 0.587 0.464 1.556 0.681 2.072 1.144 2.725 3.044 5.003 5.516 6.62 1.927 1.26 4.021 2.009 6.394 2.286 0.521 0.063 1.984 0.085 2.572 0.044 1.191-0.088 2.311-0.307 3.425-0.667 1.765-0.571 3.227-1.367 4.764-2.588l0.069-0.052 3.011 3.008c2.714 2.714 3.027 3.019 3.167 3.079 0.725 0.318 1.515-0.113 1.649-0.9 0.036-0.214 0.003-0.428-0.107-0.681-0.071-0.162-0.255-0.354-3.060-3.164l-2.983-2.991 0.176-0.206c0.099-0.113 0.305-0.373 0.461-0.576 2.572-3.373 3.535-7.701 2.64-11.861-0.587-2.728-1.935-5.201-3.927-7.199-2.514-2.528-5.752-4.007-9.331-4.268-0.445-0.030-1.589-0.030-2.031 0.003zM15.163 2.36c1.139 0.060 2.193 0.252 3.197 0.585 1.098 0.362 2.275 0.95 3.184 1.589 1.743 1.229 3.055 2.758 3.99 4.66 0.469 0.95 0.777 1.836 0.988 2.849 0.834 3.996-0.357 8.104-3.195 11.022-2.926 3.005-7.089 4.292-11.211 3.461-2.879-0.579-5.53-2.261-7.314-4.638-1.416-1.888-2.237-4.075-2.418-6.436-0.041-0.53-0.016-1.8 0.044-2.278 0.11-0.886 0.277-1.641 0.549-2.456 1.573-4.748 5.947-8.096 10.917-8.354 0.612-0.033 0.697-0.033 1.268-0.003z"></path>
                </svg>
            </button>
        </form>
        <?php
            // search form
            //get_search_form(['placeholder' => $placeholder]);
            // after
            printf('%s', $args['after_widget']);
        }

        /**
         * Deals with the settings when they are saved by the admin. Here is
         * where any validation should be dealt with.
         *
         * @param array $new_instance An array of new settings as submitted by the admin
         * @param array $old_instance An array of the previous settings
         * @return array The validated and (if necessary) amended settings
         **/
        function update( $new_instance, $old_instance )
        {
            $instance                = $old_instance;
            $instance['title']       = sanitize_text_field( $new_instance['title'] );
            $instance['placeholder'] = sanitize_text_field( $new_instance['placeholder'] );
            return $instance;
        }

        /**
         * Displays the form for this widget on the Widgets page of the WP Admin area.
         *
         * @param array $instance An array of the current settings for this widget
         * @return void Echoes it's output
         **/
        function form( $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'         => esc_html__( 'Search', 'finanzia' ),
                'placeholder'   => esc_html__( 'Search...', 'finanzia' ),
            ) );

            $title     = $instance['title'] ? esc_attr( $instance['title'] ) : '';
            $placeholder     = $instance['placeholder'] ? esc_attr( $instance['placeholder'] ) : esc_html__( 'Search...', 'finanzia' );
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'finanzia' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'placeholder' ) ); ?>"><?php esc_html_e( 'Placeholder:', 'finanzia' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'placeholder' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'placeholder' ) ); ?>" type="text" value="<?php echo esc_attr( $placeholder ); ?>" />
            </p>
            <?php
        }
    }
}
/**
 * Recent Posts widgets
 *
 * @package CMS Theme
 * @subpackage 
 * @since 1.0
 * 
 */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'CMS_Recent_Posts_Widget' );
    });

    class CMS_Recent_Posts_Widget extends WP_Widget
    {
        function __construct()
        {
            parent::__construct(
                'cms_recent_posts',
                esc_html__( '*CMS Recent Posts', 'finanzia' ),
                array(
                    'description' => esc_attr__( 'Shows your most recent posts.', 'finanzia' ),
                    'customize_selective_refresh' => true,
                )
            );
        }

        /**
         * Outputs the HTML for this widget.
         *
         * @param array $args An array of standard parameters for widgets in this theme
         * @param array $instance An array of settings for this widget instance
         * @return void Echoes it's output
         **/
        function widget( $args, $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'     => '',
                'number'    => 3,
                'post_type' => 'post',
                'post_in'   => '',
                'layout'    => '1',
            ) );

            $title = empty( $instance['title'] ) ? '' : $instance['title'];
            $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

            printf( '%s', $args['before_widget']);

            if(!empty($title)){
                printf( '%s %s %s', $args['before_title'] , $title , $args['after_title']);
            }

            $number = absint( $instance['number'] );
            /*if ( $number <= 0 || $number > 10) {
                $number = 4;
            }*/
            $post_type = $instance['post_type'];
            $post_in   = $instance['post_in'];
            $layout    = $instance['layout'];
            $sticky = '';
            if($post_in == 'featured') {
                $sticky = get_option( 'sticky_posts' );
            }
            $r = new WP_Query( array(
                'post_type'           => $post_type,
                'posts_per_page'      => $number,
                'no_found_rows'       => true,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => true,
                'post__in'            => $sticky,
                'post__not_in'        => array(get_the_ID())
            ) );

            if ( $r->have_posts() ) { ?>
                <div class="cms-posts layout-<?php echo esc_attr($layout);?>">
                    <?php while ( $r->have_posts() ) {
                        $r->the_post();
                        global $post;
                    ?>
                     <div class="cms-item d-flex gap-20">
                        <?php if(has_post_thumbnail()) { ?>
                            <div class="cms-thumb flex-auto max-w" style="--max-w:80px;"><?php finanzia_the_post_thumbnail(['size' => 'thumbnail', 'class' => 'max-w', 'style'=>'--max:80px;']); ?></div>
                        <?php } ?>
                        <div class="cms-content flex-basic d-flex flex-column justify-content-between">
                            <?php
                                printf(
                                    '<h6 class="cms-title text-accent text-hover-accent-darken text-16 lh-1375 mt-n5"><a href="%1$s" title="%2$s" class="text-line-3">%3$s</a></h6>',
                                    esc_url( get_permalink() ),
                                    esc_attr( get_the_title() ),
                                    get_the_title()
                                );
                                printf('<div class="cms--meta text-13 mb-n5">%1$s</div>', get_the_date('M j, Y'));
                            ?>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            <?php }
            wp_reset_postdata();
            printf('%s', $args['after_widget']);
        }

        /**
         * Deals with the settings when they are saved by the admin. Here is
         * where any validation should be dealt with.
         *
         * @param array $new_instance An array of new settings as submitted by the admin
         * @param array $old_instance An array of the previous settings
         * @return array The validated and (if necessary) amended settings
         **/
        function update( $new_instance, $old_instance )
        {
            $instance              = $old_instance;
            $instance['title']     = sanitize_text_field( $new_instance['title'] );
            $instance['number']    = absint( $new_instance['number'] );
            $instance['post_type'] = $new_instance['post_type'];
            $instance['post_in']   = $new_instance['post_in'];
            $instance['layout']    = $new_instance['layout'];
            return $instance;
        }

        /**
         * Displays the form for this widget on the Widgets page of the WP Admin area.
         *
         * @param array $instance An array of the current settings for this widget
         * @return void Echoes it's output
         **/
        function form( $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'         => esc_html__( 'Recent Posts', 'finanzia' ),
                'post_type'     => 'post',
                'post_in'       => 'recent',
                'layout'        => '1',
                'number'        => 3,
            ) );

            $title     = $instance['title'] ? esc_attr( $instance['title'] ) : esc_html__( 'Recent Posts', 'finanzia' );
            $number    = absint( $instance['number'] );
            $post_type = isset($instance['post_type']) ? esc_attr($instance['post_type']) : '';
            $post_in   = isset($instance['post_in']) ? esc_attr($instance['post_in']) : '';
            $layout    = isset($instance['layout']) ? esc_attr($instance['layout']) : '1';

            $post_type_list = etc_get_post_type_options();
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'finanzia' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('post_type')); ?>"><?php esc_html_e( 'Post Type', 'finanzia' ); ?></label>
                <select class="widefat" id="<?php echo esc_attr($this->get_field_id('post_type') ); ?>" name="<?php echo esc_attr($this->get_field_name('post_type') ); ?>">
                <?php 
                    foreach ($post_type_list as $key => $value) {
                    ?>
                        <option value="<?php echo esc_attr($key) ?>"<?php if( $post_type == $key ){ echo 'selected="selected"';} ?>><?php echo esc_html($value); ?></option>
                    <?php
                    }
                ?>
                </select>
            </p>
            <p><label for="<?php echo esc_attr($this->get_field_id('post_in')); ?>"><?php esc_html_e( 'Post in', 'finanzia' ); ?></label>
             <select class="widefat" id="<?php echo esc_attr($this->get_field_id('post_in') ); ?>" name="<?php echo esc_attr($this->get_field_name('post_in') ); ?>">
                <option value="recent"<?php if( $post_in == 'recent' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Recent', 'finanzia'); ?></option>
                <option value="featured"<?php if( $post_in == 'featured' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Featured', 'finanzia'); ?></option>
             </select>
             </p>
              <p><label for="<?php echo esc_attr($this->get_field_id('layout')); ?>"><?php esc_html_e( 'Layout', 'finanzia' ); ?></label>
             <select class="widefat" id="<?php echo esc_attr($this->get_field_id('layout') ); ?>" name="<?php echo esc_attr($this->get_field_name('layout') ); ?>">
                <option value="1"<?php if( $layout == '1' ){ echo 'selected="selected"';} ?>><?php esc_html_e('Default', 'finanzia'); ?></option>
             </select>
             </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'finanzia' ); ?></label>
                <input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' ) ); ?>" type="number" step="1" min="1" value="<?php echo esc_attr( $number ); ?>" size="3" />
            </p>

            <?php
        }
    }
}
/**
 * Widget Menu
 * 
 * */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'CMS_Menu_Widget' );
    });
    class CMS_Menu_Widget extends WP_Widget {
        public function __construct() {
            $widget_ops = array(
                'description'                 => __( 'Add a navigation menu to your sidebar.','finanzia' ),
                'customize_selective_refresh' => true,
                'show_instance_in_rest'       => true,
            );
            parent::__construct( 
                'cms_menu', 
                esc_html__( '*CMS Menu', 'finanzia' ), 
                $widget_ops 
            );
        }
        public function widget( $args, $instance ) {
            // Get menu.
            $nav_menu = ! empty( $instance['nav_menu'] ) ? wp_get_nav_menu_object( $instance['nav_menu'] ) : false;

            if ( ! $nav_menu ) {
                return;
            }
            $default_title = esc_html__( 'CMS Menu', 'finanzia' );
            $title         = ! empty( $instance['title'] ) ? $instance['title'] : '';
            $layout        = ! empty( $instance['layout'] ) ? $instance['layout'] : '1';
            $count         = ! empty( $instance['count'] ) ? $instance['count'] : '';
            $link_classes  = ! empty( $instance['link_classes'] ) ? $instance['link_classes'] : '';
            $link_classes  .= ' cms-hover-move-icon-up text-accent';

            // Menu icon
            switch ($layout) {
                case '2':
                    $menu_icon = finanzia_svgs_icon([
                        'icon'       => 'divider',
                        'icon_size'  => 15,
                        'icon_class' => 'menu-icon',
                        'class'      => 'pt-7', 
                        'echo'       => false 
                    ]);
                    break;
                
                default:
                    $menu_icon = '';
                    break;
            }


            /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
            $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

            printf('%s', $args['before_widget']);

            if ( $title ) {
                printf('%s', $args['before_title'] . $title . $args['after_title']);
            }

            $format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

            /**
             * Filters the HTML format of widgets with navigation links.
             *
             * @since 1.0
             *
             * @param string $format The type of markup to use in widgets with navigation links.
             *                       Accepts 'html5', 'xhtml'.
             */
            $format = apply_filters( 'navigation_widgets_format', $format );

            if ( 'html5' === $format ) {
                // The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
                $title      = trim( strip_tags( $title ) );
                $aria_label = $title ? $title : $default_title;

                $nav_menu_args = array(
                    'fallback_cb'          => '',
                    'menu'                 => $nav_menu,
                    'menu_class'           => 'cms-wg-menu cms-wg-menu-'.$layout,  
                    'menu_icon'            => $menu_icon,
                    'container'            => 'nav',
                    'container_aria_label' => $aria_label,
                    'items_wrap'           => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                    'count'                => $count, 
                    'walker'               => new Finanzia_Toggle_Menu_Walker,
                    'link_class'           => $link_classes,
                    'theme_location'       => '' 
                );
            } else {
                $nav_menu_args = array(
                    'fallback_cb'    => '',
                    'menu'           => $nav_menu,
                    'menu_class'     => 'cms-wg-menu-'.$layout,  
                    'menu_icon'      => $menu_icon,
                    'count'          => $count, 
                    'walker'         => new Finanzia_Toggle_Menu_Walker,
                    'link_class'     => $link_classes,
                    'theme_location' => ''
                );
            }
            wp_nav_menu(array_merge(['theme_location' => ''], $nav_menu_args));

            printf('%s', $args['after_widget']);
        }
        public function update( $new_instance, $old_instance ) {
            $instance = array();
            if ( ! empty( $new_instance['title'] ) ) {
                $instance['title'] = sanitize_text_field( $new_instance['title'] );
            }
            if ( ! empty( $new_instance['layout'] ) ) {
                $instance['layout'] = (int) $new_instance['layout'];
            }
            if ( ! empty( $new_instance['nav_menu'] ) ) {
                $instance['nav_menu'] = (int) $new_instance['nav_menu'];
            }
            if ( ! empty( $new_instance['count'] ) ) {
                $instance['count'] = (int) $new_instance['count'];
            }
            if ( ! empty( $new_instance['link_classes'] ) ) {
                $instance['link_classes'] = $new_instance['link_classes'];
            }
            return $instance;
        }
        public function form( $instance ) {
            global $wp_customize;
            $title    = isset( $instance['title'] ) ? $instance['title'] : '';
            $layout = isset( $instance['layout'] ) ? $instance['layout'] : '1';
            $nav_menu = isset( $instance['nav_menu'] ) ? $instance['nav_menu'] : '';
            $count    = isset( $instance['count'] ) ? $instance['count'] : '';
            $link_classes    = isset( $instance['link_classes'] ) ? $instance['link_classes'] : '';

            // Get menus.
            $menus = wp_get_nav_menus();

            $empty_menus_style     = '';
            $not_empty_menus_style = '';
            if ( empty( $menus ) ) {
                $empty_menus_style = ' style="display:none" ';
            } else {
                $not_empty_menus_style = ' style="display:none" ';
            }

            $nav_menu_style = '';
            if ( ! $nav_menu ) {
                $nav_menu_style = 'display: none;';
            }

            // If no menus exists, direct the user to go and create some.
            ?>
            <p class="nav-menu-widget-no-menus-message" <?php echo esc_attr($not_empty_menus_style); ?>>
                <?php
                if ( $wp_customize instanceof WP_Customize_Manager ) {
                    $url = 'javascript: wp.customize.panel( "nav_menus" ).focus();';
                } else {
                    $url = admin_url( 'nav-menus.php' );
                }

                printf(
                    /* translators: %s: URL to create a new menu. */
                    __( 'No menus have been created yet. <a href="%s">Create some</a>.' , 'finanzia'),
                    // The URL can be a `javascript:` link, so esc_attr() is used here instead of esc_url().
                    esc_attr( $url )
                );
                ?>
            </p>
            <div class="nav-menu-widget-form-controls" <?php echo esc_attr($empty_menus_style); ?>>
                <p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','finanzia' ); ?></label>
                    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr( $title ); ?>" />
                </p>
                <p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'layout' )); ?>"><?php esc_html_e( 'Layout' ,'finanzia'); ?></label>
                    <select id="<?php echo esc_attr($this->get_field_id( 'layout' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'layout' )); ?>">
                        <option value="1" <?php selected( $layout, 1 ); ?>><?php esc_html_e( 'Layout 1','finanzia' ); ?></option>
                        <option value="2" <?php selected( $layout, 2 ); ?>><?php esc_html_e( 'Layout 2','finanzia' ); ?></option>
                    </select>
                </p>
                <p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'nav_menu' )); ?>"><?php esc_html_e( 'Select Menu:' ,'finanzia'); ?></label>
                    <select id="<?php echo esc_attr($this->get_field_id( 'nav_menu' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'nav_menu' )); ?>">
                        <option value="0"><?php esc_html_e( '&mdash; Select &mdash;','finanzia' ); ?></option>
                        <?php foreach ( $menus as $menu ) : ?>
                            <option value="<?php echo esc_attr( $menu->term_id ); ?>" <?php selected( $nav_menu, $menu->term_id ); ?>>
                                <?php echo esc_html( $menu->name ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </p>
                <p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'count' )); ?>"><?php esc_html_e( 'Show taxonomy items count?' ,'finanzia'); ?></label>
                    <select id="<?php echo esc_attr($this->get_field_id( 'count' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'count' )); ?>">
                        <option value="0"><?php esc_html_e( 'None','finanzia' ); ?></option>
                        <option value="1" <?php selected( $count, 1 ); ?>><?php esc_html_e( 'Number with ()','finanzia' ); ?></option>
                        <option value="2" <?php selected( $count, 2 ); ?>><?php esc_html_e( 'Number with Text','finanzia' ); ?></option>
                        <option value="3" <?php selected( $count, 3 ); ?>><?php esc_html_e( 'Number Circle','finanzia' ); ?></option>
                    </select>
                </p>
                <p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'link_classes' )); ?>"><?php esc_html_e( 'Link CSS class:','finanzia' ); ?></label>
                    <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_classes' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_classes' )); ?>" value="<?php echo esc_attr( $link_classes ); ?>" />
                </p>
                <?php if ( $wp_customize instanceof WP_Customize_Manager ) : ?>
                    <p class="edit-selected-nav-menu" style="<?php echo esc_attr($nav_menu_style); ?>">
                        <button type="button" class="button"><?php esc_html_e( 'Edit Menu','finanzia' ); ?></button>
                    </p>
                <?php endif; ?>
            </div>
            <?php
        }
    }
}
/**
 * Widget Categories
 * */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'CMS_Categories_Widget' );
    });
    class CMS_Categories_Widget extends WP_Widget
    {
        function __construct()
        {
            parent::__construct(
                'cms_categories',
                esc_html__( '*CMS Categories', 'finanzia' ),
                array(
                    'description' => esc_attr__( 'A list or dropdown of categories.', 'finanzia' ),
                    'customize_selective_refresh' => true,
                )
            );
        }

        function widget( $args, $instance )
        {
            static $first_dropdown = true;

            $default_title = esc_html__( 'Categories', 'finanzia' );
            $title         = ! empty( $instance['title'] ) ? $instance['title'] : $default_title;

            /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
            $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

            $count        = ! empty( $instance['count'] ) ? '1' : '0';
            $hierarchical = ! empty( $instance['hierarchical'] ) ? '1' : '0';
            $dropdown     = ! empty( $instance['dropdown'] ) ? '1' : '0';
            $included_cateogries     = ! empty( $instance['included_cateogries'] ) ? $instance['included_cateogries'] : '';

            printf('%s', $args['before_widget']);

            if ( $title ) {
                printf('%s',  $args['before_title'] . $title . $args['after_title']);
            }

            $cat_args = array(
                'orderby'      => 'name',
                'show_count'   => $count,
                'hierarchical' => $hierarchical,
                'include' => $included_cateogries,
                //'orderby' => 'term_order'
            );

            if ( $dropdown ) {
                printf( '<form action="%s" method="get">', esc_url( home_url() ) );
                $dropdown_id    = ( $first_dropdown ) ? 'cat' : "{$this->id_base}-dropdown-{$this->number}";
                $first_dropdown = false;

                echo '<label class="screen-reader-text" for="' . esc_attr( $dropdown_id ) . '">' . $title . '</label>';

                $cat_args['show_option_none'] = esc_html__( 'Select Category', 'finanzia' );
                $cat_args['id']               = $dropdown_id;
                wp_dropdown_categories( apply_filters( 'widget_categories_dropdown_args', $cat_args, $instance ) );

                echo '</form>';
                ?>

                <script>
                /* <![CDATA[ */
                (function() {
                    var dropdown = document.getElementById( "<?php echo esc_js( $dropdown_id ); ?>" );
                    function onCatChange() {
                        if ( dropdown.options[ dropdown.selectedIndex ].value > 0 ) {
                            dropdown.parentNode.submit();
                        }
                    }
                    dropdown.onchange = onCatChange;
                })();
                /* ]]> */
                </script>

            <?php
            } else {
                $format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

                /** This filter is documented in wp-includes/widgets/class-wp-nav-menu-widget.php */
                $format = apply_filters( 'navigation_widgets_format', $format );

                if ( 'html5' === $format ) {
                    // The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
                    $title      = trim( strip_tags( $title ) );
                    $aria_label = $title ? $title : $default_title;
                    echo '<nav aria-label="' . esc_attr( $aria_label ) . '">';
                }
                ?>

                <ul class="cms-category">
                    <?php
                    $cat_args['title_li'] = '';
                    wp_list_categories( apply_filters( 'widget_categories_args', $cat_args, $instance ) );
                    ?>
                </ul>

                <?php
                if ( 'html5' === $format ) {
                    echo '</nav>';
                }
            }

            printf('%s', $args['after_widget']);
        }

        function update( $new_instance, $old_instance )
        {
            $instance                 = $old_instance;
            $instance['title']        = sanitize_text_field( $new_instance['title'] );
            $instance['count']        = ! empty( $new_instance['count'] ) ? 1 : 0;
            $instance['hierarchical'] = ! empty( $new_instance['hierarchical'] ) ? 1 : 0;
            $instance['dropdown']     = ! empty( $new_instance['dropdown'] ) ? 1 : 0;
            $instance['included_cateogries']     = ! empty( $new_instance['included_cateogries'] ) ? $new_instance['included_cateogries'] : '';

            return $instance;
        }

        function form( $instance )
        {
            // Defaults.
            $instance     = wp_parse_args( (array) $instance, array( 'title' => '' ) );
            $count        = isset( $instance['count'] ) ? (bool) $instance['count'] : false;
            $hierarchical = isset( $instance['hierarchical'] ) ? (bool) $instance['hierarchical'] : false;
            $dropdown     = isset( $instance['dropdown'] ) ? (bool) $instance['dropdown'] : false;
            $included_cateogries     = isset( $instance['included_cateogries'] ) ? $instance['included_cateogries'] : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title', 'finanzia' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />
            </p>

            <p>
                <input type="checkbox" class="checkbox" id="<?php echo esc_attr($this->get_field_id( 'dropdown' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dropdown' )); ?>"<?php checked( $dropdown ); ?> />
                <label for="<?php echo esc_attr($this->get_field_id( 'dropdown' )); ?>"><?php echo esc_html__( 'Display as dropdown', 'finanzia' ); ?></label>
                <br />

                <input type="checkbox" class="checkbox" id="<?php echo esc_attr($this->get_field_id( 'count' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'count' )); ?>"<?php checked( $count ); ?> />
                <label for="<?php echo esc_attr($this->get_field_id( 'count' )); ?>"><?php echo esc_html__( 'Show post counts', 'finanzia' ); ?></label>
                <br />

                <input type="checkbox" class="checkbox" id="<?php echo esc_attr($this->get_field_id( 'hierarchical' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hierarchical' )); ?>"<?php checked( $hierarchical ); ?> />
                <label for="<?php echo esc_attr($this->get_field_id( 'hierarchical' )); ?>"><?php echo esc_html__( 'Show hierarchy', 'finanzia' ); ?></label>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('included_cateogries')); ?>"><?php echo esc_html__( 'Included Categories', 'finanzia' ); ?></label>
                <?php
                $cat_args = array(
                    'walker'       => new Finanzia_Walker_CategoryDropdown,
                    'id'           => $this->get_field_id('included_cateogries'),
                    'name'         => $this->get_field_name('included_cateogries') . '[]',
                    'orderby'      => 'name',
                    'show_count'   => true,
                    'hierarchical' => true,
                    'hide_empty'   => false,
                    'multiple'     => true,
                    'selected'     => $included_cateogries,
                );
                wp_dropdown_categories($cat_args);
                ?>
            </p>
            <?php
        }
    }
}

/**
 * Widget Categories
 * Custom HTML output
*/
if(!function_exists('finanzia_widget_categories_args')){
    add_filter('widget_categories_args', 'finanzia_widget_categories_args');
    add_filter('woocommerce_product_categories_widget_args', 'finanzia_widget_categories_args');
    //add_filter('widget_cms_taxonomies_args', 'finanzia_widget_categories_args');
    function finanzia_widget_categories_args($cat_args){
        $cat_args['walker'] = new Finanzia_Categories_Walker_Dropdown;
        return $cat_args; 
    }
}

class Finanzia_Walker_CategoryDropdown extends Walker {

    /**
     * What the class handles.
     *
     * @since 2.1.0
     * @var string
     *
     * @see Walker::$tree_type
     */
    public $tree_type = 'category';

    /**
     * Database fields to use.
     *
     * @since 2.1.0
     * @todo Decouple this
     * @var string[]
     *
     * @see Walker::$db_fields
     */
    public $db_fields = array(
        'parent' => 'parent',
        'id'     => 'term_id',
    );

    /**
     * Starts the element output.
     *
     * @since 2.1.0
     * @since 5.9.0 Renamed `$category` to `$data_object` and `$id` to `$current_object_id`
     *              to match parent class for PHP 8 named parameter support.
     *
     * @see Walker::start_el()
     *
     * @param string  $output            Used to append additional content (passed by reference).
     * @param WP_Term $data_object       Category data object.
     * @param int     $depth             Depth of category. Used for padding.
     * @param array   $args              Uses 'selected', 'show_count', and 'value_field' keys, if they exist.
     *                                   See wp_dropdown_categories().
     * @param int     $current_object_id Optional. ID of the current category. Default 0.
     */
    public function start_el( &$output, $data_object, $depth = 0, $args = array(), $current_object_id = 0 ) {
        // Restores the more descriptive, specific name for use within this method.
        $category = $data_object;
        $pad      = str_repeat( '&nbsp;', $depth * 3 );

        /** This filter is documented in wp-includes/category-template.php */
        $cat_name = apply_filters( 'list_cats', $category->name, $category );

        if ( isset( $args['value_field'] ) && isset( $category->{$args['value_field']} ) ) {
            $value_field = $args['value_field'];
        } else {
            $value_field = 'term_id';
        }

        $output .= "\t<option class=\"level-$depth\" value=\"" . esc_attr( $category->{$value_field} ) . '"';

        // Type-juggling causes false matches, so we force everything to a string.

        $selected = $args['selected'];
        if(is_array($selected)){
            if (in_array((string) $category->{$value_field}, $selected)) {
                $output .= ' selected="selected"';
            }
        }
        else{
            if ( (string) $category->{$value_field} === (string) $args['selected'] ) {
                $output .= ' selected="selected"';
            }
        }
        
        $output .= '>';
        $output .= $pad . $cat_name;
        if ( $args['show_count'] ) {
            $output .= '&nbsp;&nbsp;(' . number_format_i18n( $category->count ) . ')';
        }
        $output .= "</option>\n";
    }
}

/**
 * Finanzia_Categories_Walker_Tree
 *
 * @package CMS Theme
 * @subpackage 
 * @since 1.0
 *
 */
class Finanzia_Categories_Walker_Tree extends Walker_Category {
    /**
     * Starts the list before the elements are added.
     *
     * @since 2.1.0
     *
     * @see Walker::start_lvl()
     *
     * @param string $output Used to append additional content. Passed by reference.
     * @param int    $depth  Optional. Depth of category. Used for tab indentation. Default 0.
     * @param array  $args   Optional. An array of arguments. Will only append content if style argument
     *                       value is 'list'. See wp_list_categories(). Default empty array.
     */
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        if ( 'list' !== $args['style'] ) {
            return;
        }

        $indent  = str_repeat( "\t", $depth );
        $output .= "$indent<ul class='cms-children cms-tree'>\n";
    }
    /**
     * Starts the element output.
     *
     * @since 2.1.0
     *
     * @see Walker::start_el()
     *
     * @param string $output   Used to append additional content (passed by reference).
     * @param object $category Category data object.
     * @param int    $depth    Optional. Depth of category in reference to parents. Default 0.
     * @param array  $args     Optional. An array of arguments. See wp_list_categories(). Default empty array.
     * @param int    $id       Optional. ID of the current category. Default 0.
     */
    public function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {
        /** This filter is documented in wp-includes/category-template.php */
        $cat_name = apply_filters(
            'list_cats',
            esc_attr( $category->name ),
            $category
        );
 
        // Don't generate an element if the category name is empty.
        if ( ! $cat_name ) {
            return;
        }
 
        $link = '<a href="' . esc_url( get_term_link( $category ) ) . '" ';
        if ( $args['use_desc_for_title'] && ! empty( $category->description ) ) {
            /**
             * Filters the category description for display.
             *
             * @since 1.2.0
             *
             * @param string $description Category description.
             * @param object $category    Category object.
             */
            $link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
        }
 
        $link .= '>';

        if ( $args['has_children'] && $args['hierarchical'] && ( empty( $args['max_depth'] ) || $args['max_depth'] > $depth + 1 ) ) {
            $link .= '<span class="title">'.$cat_name.'</span>';
            if ( ! empty( $args['show_count'] ) ) {
                $link .= ' <span class="count">' . number_format_i18n( $category->count ) . '</span>';
            }
        } else {
            $link .= '<span class="title">'.$cat_name.'</span>';
            if ( ! empty( $args['show_count'] ) ) {
                $link .= ' <span class="count">' . number_format_i18n( $category->count ) . '</span>';
            }
        }

        $link .= '</a>';

        if ( ! empty( $args['feed_image'] ) || ! empty( $args['feed'] ) ) {
            $link .= ' ';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= '(';
            }
 
            $link .= '<a href="' . esc_url( get_term_feed_link( $category->term_id, $category->taxonomy, $args['feed_type'] ) ) . '"';
 
            if ( empty( $args['feed'] ) ) {
                $alt = ' alt="' . sprintf(__( 'Feed for all posts filed under %s','finanzia' ), $cat_name ) . '"';
            } else {
                $alt = ' alt="' . $args['feed'] . '"';
                $name = $args['feed'];
                $link .= empty( $args['title'] ) ? '' : $args['title'];
            }
 
            $link .= '>';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= $name;
            } else {
                $link .= "<img src='" . $args['feed_image'] . "'$alt" . ' />';
            }
            $link .= '</a>';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= ')';
            }
        }
        if ( 'list' == $args['style'] ) {
            $output .= "\t<li";
            $css_classes = array(
                'cms-item',
                'cms-menu-item'
            );
            if($args['has_children']){
                $css_classes[] =  'parents';
            }
            if ( ! empty( $args['current_category'] ) ) {
                // 'current_category' can be an array, so we use `get_terms()`.
                $_current_terms = get_terms( $category->taxonomy, array(
                    'include' => $args['current_category'],
                    'hide_empty' => false,
                ) );
 
                foreach ( $_current_terms as $_current_term ) {
                    if ( $category->term_id == $_current_term->term_id ) {
                        $css_classes[] = 'current current-cat';
                    } elseif ( $category->term_id == $_current_term->parent ) {
                        $css_classes[] = 'current-parent current-cat-parent';
                    }
                    while ( $_current_term->parent ) {
                        if ( $category->term_id == $_current_term->parent ) {
                            $css_classes[] =  'current-ancestor current-cat-ancestor';
                            break;
                        }
                        $_current_term = get_term( $_current_term->parent, $category->taxonomy );
                    }
                }
            }
 
            /**
             * Filters the list of CSS classes to include with each category in the list.
             *
             * @since 4.2.0
             *
             * @see wp_list_categories()
             *
             * @param array  $css_classes An array of CSS classes to be applied to each list item.
             * @param object $category    Category data object.
             * @param int    $depth       Depth of page, used for padding.
             * @param array  $args        An array of wp_list_categories() arguments.
             */
            $css_classes = implode( ' ', apply_filters( 'cms_tree_category_css_class', $css_classes, $category, $depth, $args ) );
 
            $output .=  ' class="' . $css_classes . '"';
            $output .= ">$link\n";
        } elseif ( isset( $args['separator'] ) ) {
            $output .= "\t$link" . $args['separator'] . "\n";
        } else {
            $output .= "\t$link<br />\n";
        }
    }
}
/**
 * Finanzia_Categories_Walker_Dropdown
 *
 * @version 1.0
 * @package 
 * @since   1.0
 *
 */
class Finanzia_Categories_Walker_Dropdown extends Walker_Category {
    /**
     * Starts the list before the elements are added.
     *
     * @since 2.1.0
     *
     * @see Walker::start_lvl()
     *
     * @param string $output Used to append additional content. Passed by reference.
     * @param int    $depth  Optional. Depth of category. Used for tab indentation. Default 0.
     * @param array  $args   Optional. An array of arguments. Will only append content if style argument
     *                       value is 'list'. See wp_list_categories(). Default empty array.
     */
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        if ( 'list' !== $args['style'] ) {
            return;
        }

        $indent  = str_repeat( "\t", $depth );
        $output .= "$indent<ul class='children cms-dropdown'>\n";
    }
    /**
     * Starts the element output.
     *
     * @since 2.1.0
     *
     * @see Walker::start_el()
     *
     * @param string $output   Used to append additional content (passed by reference).
     * @param object $category Category data object.
     * @param int    $depth    Optional. Depth of category in reference to parents. Default 0.
     * @param array  $args     Optional. An array of arguments. See wp_list_categories(). Default empty array.
     * @param int    $id       Optional. ID of the current category. Default 0.
     */
    public function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {
        /** This filter is documented in wp-includes/category-template.php */
        $cat_name = apply_filters(
            'list_cats',
            esc_attr( $category->name ),
            $category
        );
 
        // Don't generate an element if the category name is empty.
        if ( ! $cat_name ) {
            return;
        }
 
        $link = '<a href="' . esc_url( get_term_link( $category ) ) . '" ';
        if ( $args['use_desc_for_title'] && ! empty( $category->description ) ) {
            /**
             * Filters the category description for display.
             *
             * @since 1.2.0
             *
             * @param string $description Category description.
             * @param object $category    Category object.
             */
            $link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
        }
 
        $link .= '>';

        $title_class = 'title';
        // 'current_category' can be an array, so we use `get_terms()`.
        $_current_terms = get_terms( $category->taxonomy, array(
            'include' => $args['current_category'],
            'hide_empty' => false,
        ) );
        foreach ( $_current_terms as $_current_term ) {
            if ( $category->term_id == $_current_term->term_id && is_category()) {
                $title_class .= ' current';
            }
        }

        if ( $args['has_children'] && $args['hierarchical'] && ( empty( $args['max_depth'] ) || $args['max_depth'] > $depth + 1 ) ) {
            $link .= '<span class="'.$title_class.'">'.$cat_name.'</span>';
            if ( ! empty( $args['show_count'] ) ) {
                //$link .= ' <span class="count">' . number_format_i18n( $category->count ) . '</span>';
            }
            $dropdown_arrow = '<span class="cms-menu-toggle"></span>';
        } else {
            $link .= '<span class="'.$title_class.'">'.$cat_name.'</span>';
            if ( ! empty( $args['show_count'] ) ) {
                $link .= ' <span class="count">' . number_format_i18n( $category->count ) . '</span>';
            }
            $dropdown_arrow = '';
        }

        $link .= $dropdown_arrow.'</a>';
        
        if ( ! empty( $args['feed_image'] ) || ! empty( $args['feed'] ) ) {
            $link .= ' ';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= '(';
            }
 
            $link .= '<a href="' . esc_url( get_term_feed_link( $category->term_id, $category->taxonomy, $args['feed_type'] ) ) . '"';
 
            if ( empty( $args['feed'] ) ) {
                $alt = ' alt="' . sprintf(__( 'Feed for all posts filed under %s','finanzia' ), $cat_name ) . '"';
            } else {
                $alt = ' alt="' . $args['feed'] . '"';
                $name = $args['feed'];
                $link .= empty( $args['title'] ) ? '' : $args['title'];
            }
 
            $link .= '>';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= $name;
            } else {
                $link .= "<img src='" . $args['feed_image'] . "'$alt" . ' />';
            }
            $link .= '</a>';
 
            if ( empty( $args['feed_image'] ) ) {
                $link .= ')';
            }
        }
        if ( 'list' == $args['style'] ) {
            $output .= "\t<li";
            $css_classes = array(
                'cms-list-item',
                'cms-widget-menu-item'
            );
            if($args['has_children']){
                $css_classes[] = 'parents';
            }
            if ( ! empty( $args['current_category'] ) ) {
                // 'current_category' can be an array, so we use `get_terms()`.
                $_current_terms = get_terms( $category->taxonomy, array(
                    'include' => $args['current_category'],
                    'hide_empty' => false,
                ) );
 
                foreach ( $_current_terms as $_current_term ) {
                    if ( $category->term_id == $_current_term->term_id ) {
                        $css_classes[] = 'current current-cat';
                    } elseif ( $category->term_id == $_current_term->parent ) {
                        $css_classes[] = 'current-parent current-cat-parent';
                    }
                    while ( $_current_term->parent ) {
                        if ( $category->term_id == $_current_term->parent ) {
                            $css_classes[] =  'current-ancestor current-cat-ancestor';
                            break;
                        }
                        $_current_term = get_term( $_current_term->parent, $category->taxonomy );
                    }
                }
            }
 
            /**
             * Filters the list of CSS classes to include with each category in the list.
             *
             * @since 4.2.0
             *
             * @see wp_list_categories()
             *
             * @param array  $css_classes An array of CSS classes to be applied to each list item.
             * @param object $category    Category data object.
             * @param int    $depth       Depth of page, used for padding.
             * @param array  $args        An array of wp_list_categories() arguments.
             */
            $css_classes = implode( ' ', apply_filters( 'cms_dropdown_category_css_class', $css_classes, $category, $depth, $args ) );
 
            $output .=  ' class="' . $css_classes . '"';
            $output .= ">$link\n";
        } elseif ( isset( $args['separator'] ) ) {
            $output .= "\t$link" . $args['separator'] . "\n";
        } else {
            $output .= "\t$link<br />\n";
        }
    }
}

/**
 * Widget Tag Cloud WP 
 * Change separator text, font size, ...
 * Hook filter: widget_tag_cloud_args, woocommerce_product_tag_cloud_widget_args
 * 
 * @package CMS Theme
 * @subpackage 
 * @since 1.0
 * 
*/
add_filter('widget_tag_cloud_args', 'finanzia_widget_tag_cloud_args');
add_filter('woocommerce_product_tag_cloud_widget_args', 'finanzia_widget_tag_cloud_args');
if(!function_exists('finanzia_widget_tag_cloud_args')){
    function finanzia_widget_tag_cloud_args($args){
        $_args =[
            'smallest'  => '13',
            'largest'   => '13',
            'unit'      => 'px',
            'separator' => '',
            'format'    => 'list' // list, flat
        ];
        $args = wp_parse_args($args, $_args);
        return $args;
    }
}

if(!function_exists('finanzia_wp_dropdown_cats')){
    add_filter('wp_dropdown_cats', 'finanzia_wp_dropdown_cats', 10, 2);
    function finanzia_wp_dropdown_cats($output, $parsed_args){
        $output = preg_replace('/<select([^>]*)>/', '<select$1 egrid-products-category-filter>', $output);
        if(isset($parsed_args['multiple']) && $parsed_args['multiple'] == true){
            $output = preg_replace('/<select([^>]*)>/', '<select$1 multiple>', $output);
        }

        return $output;
    }
}

/**
 * Widget API: Finanzia_Widget_Media_Gallery class
 *
 * @package CMS Theme
 * @subpackage 
 * @since 1.0.0
 */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'Finanzia_Widget_Media_Gallery' );
    });
    class Finanzia_Widget_Media_Gallery extends WP_Widget_Media {
        /**
         * Constructor.
         *
         * @since 1.0.0
         */
        public function __construct() {
            parent::__construct(
                'cms_media_gallery',
                __( '*CMS Gallery', 'finanzia' ),
                array(
                    'description' => __( 'Displays an image gallery.','finanzia' ),
                    'mime_type'   => 'image',
                )
            );

            $this->l10n = array_merge(
                $this->l10n,
                array(
                    'no_media_selected' => __( 'No images selected', 'finanzia' ),
                    'add_media'         => _x( 'Add Images', 'label for button in the gallery widget; should not be longer than ~13 characters long', 'finanzia' ),
                    'replace_media'     => '',
                    'edit_media'        => _x( 'Edit Gallery', 'label for button in the gallery widget; should not be longer than ~13 characters long' , 'finanzia'),
                )
            );
        }
        /**
         * Get schema for properties of a widget instance (item).
         *
         * @since 1.0.0
         *
         * @see WP_REST_Controller::get_item_schema()
         * @see WP_REST_Controller::get_additional_fields()
         * @link https://core.trac.wordpress.org/ticket/35574
         *
         * @return array Schema for properties.
         */
        public function get_instance_schema() {
            $schema = array(
                'title'          => array(
                    'type'                  => 'string',
                    'default'               => '',
                    'sanitize_callback'     => 'sanitize_text_field',
                    'description'           => __( 'Title for the widget', 'finanzia' ),
                    'should_preview_update' => false,
                ),
                'custom_url'          => array(
                    'type'                  => 'string',
                    'default'               => '',
                    'sanitize_callback'     => 'sanitize_text_field',
                    'description'           => __( 'Custom URL', 'finanzia' ),
                    'should_preview_update' => false,
                ),
                'image_size_w'          => array(
                    'type'                  => 'string',
                    'default'               => 90,
                    //'sanitize_callback'     => 'sanitize_text_field',
                    'description'           => __( 'Image Size Width', 'finanzia' ),
                    //'should_preview_update' => false,
                ),
                'image_size_h'          => array(
                    'type'                  => 'string',
                    'default'               => 90,
                    //'sanitize_callback'     => 'sanitize_text_field',
                    'description'           => __( 'Image Size Height', 'finanzia' ),
                    //'should_preview_update' => false,
                ),
                'ids'            => array(
                    'type'              => 'array',
                    'items'             => array(
                        'type' => 'integer',
                    ),
                    'default'           => array(),
                    'sanitize_callback' => 'wp_parse_id_list',
                ),
                'columns'        => array(
                    'type'    => 'integer',
                    'default' => 3,
                    'minimum' => 1,
                    'maximum' => 6,
                ),
                'size'           => array(
                    'type'    => 'string',
                    'enum'    => array_merge( get_intermediate_image_sizes()), // array( 'full', 'custom' ) 
                    'default' => 'thumbnail',
                ),
                'link_type'      => array(
                    'type'                  => 'string',
                    'enum'                  => array( 'none' ), //'post', 'file',
                    'default'               => 'none',
                    'media_prop'            => 'link',
                    'should_preview_update' => false,
                ),
                'orderby_random' => array(
                    'type'                  => 'boolean',
                    'default'               => false,
                    'media_prop'            => '_orderbyRandom',
                    'should_preview_update' => false,
                ),
            );

            /** This filter is documented in wp-includes/widgets/class-wp-widget-media.php */
            $schema = apply_filters( "widget_{$this->id_base}_instance_schema", $schema, $this );

            return $schema;
        }

        /**
         * Render the media on the frontend.
         *
         * @since 1.0.0
         *
         * @param array $instance Widget instance props.
         */
        public function render_media( $instance ) {
            $instance = array_merge( wp_list_pluck( $this->get_instance_schema(), 'default' ), $instance );
            $shortcode_atts = array_merge(
                $instance,
                array(
                    'link' => $instance['link_type'],
                )
            );
            // @codeCoverageIgnoreStart
            if ( $instance['orderby_random'] ) {
                $shortcode_atts['orderby'] = 'rand';
            }
            // @codeCoverageIgnoreEnd
            //echo gallery_shortcode( $shortcode_atts );
            // Custom layout
            $custom_image_size_w = !empty($instance['image_size_w']) && is_numeric($instance['image_size_w']) ? $instance['image_size_w'] : '';
            $custom_image_size_h = !empty($instance['image_size_h']) && is_numeric($instance['image_size_h']) ? $instance['image_size_h'] : $custom_image_size_w;
            $custom_image_size = [$custom_image_size_w, $custom_image_size_h];
            //
            $image_size = (!empty($custom_image_size_w) || !empty($custom_image_size_h)) ? $custom_image_size : $instance['size'];
        ?>
            <div class="cms-wg-gallery d-flex flex-col-<?php echo esc_attr($instance['columns']); ?> gutter-10">
                <?php foreach ($instance['ids'] as $key => $id) {
                ?>
                    <a href="<?php echo esc_url($instance['custom_url']) ?>">
                        <span class="gallery-icon text-20 d-flex align-items-center justify-content-center circle absolute center cms-transition"><?php 
                            include get_template_directory().'/assets/svgs/core/instagram.svg';
                        ?></span>
                        <?php 
                            echo wp_get_attachment_image($id, $image_size, false, ['loading' => 'lazy']); 
                        ?>
                    </a>
                <?php
                } ?>
            </div>
        <?php
        }

        /**
         * Loads the required media files for the media manager and scripts for media widgets.
         *
         * @since 1.0.0
         */
        public function enqueue_admin_scripts() {
            parent::enqueue_admin_scripts();

            $handle = 'cms-media-gallery-widget';
            wp_enqueue_script( $handle );

            $exported_schema = array();
            foreach ( $this->get_instance_schema() as $field => $field_schema ) {
                $exported_schema[ $field ] = wp_array_slice_assoc( $field_schema, array( 'type', 'default', 'enum', 'minimum', 'format', 'media_prop', 'should_preview_update', 'items' ) );
            }
            wp_add_inline_script(
                $handle,
                sprintf(
                    'wp.mediaWidgets.modelConstructors[ %s ].prototype.schema = %s;',
                    wp_json_encode( $this->id_base ),
                    wp_json_encode( $exported_schema )
                )
            );

            wp_add_inline_script(
                $handle,
                sprintf(
                    '
                        wp.mediaWidgets.controlConstructors[ %1$s ].prototype.mime_type = %2$s;
                        _.extend( wp.mediaWidgets.controlConstructors[ %1$s ].prototype.l10n, %3$s );
                    ',
                    wp_json_encode( $this->id_base ),
                    wp_json_encode( $this->widget_options['mime_type'] ),
                    wp_json_encode( $this->l10n )
                )
            );
        }
        /**
     * Render form template scripts.
     *
     * @since 4.9.0
     */
    public function render_control_template_scripts() {
        //parent::render_control_template_scripts();
        ?>
        <script type="text/html" id="tmpl-widget-media-<?php echo esc_attr( $this->id_base ); ?>-control">
            <# var elementIdPrefix = 'el' + String( Math.random() ) + '_' #>
            <p>
                <label for="{{ elementIdPrefix }}title"><?php esc_html_e( 'Title:', 'finanzia' ); ?></label>
                <input id="{{ elementIdPrefix }}title" type="text" class="widefat title">
            </p>
            <p>
                <label for="{{ elementIdPrefix }}custom_url"><?php esc_html_e( 'Custom URL', 'finanzia' ); ?></label>
                <input id="{{ elementIdPrefix }}custom_url" type="text" class="widefat custom_url">
            </p>
            <table>
                <tr><td colspan="2"><strong><?php esc_html_e( 'Image Size (Number Only!)', 'finanzia' ); ?></strong></td></tr>
                <tr>
                    <td>
                        <?php // Image size Width ?>
                        <label for="{{ elementIdPrefix }}image_size_w"><?php esc_html_e( 'Width', 'finanzia' ); ?></label>
                        <input id="{{ elementIdPrefix }}image_size_w" type="number" class="widefat image_size_w">
                        <?php // Image Size Height ?>
                    </td>
                    <td>
                        <label for="{{ elementIdPrefix }}image_size_h"><?php esc_html_e( 'Height', 'finanzia' ); ?></label>
                        <input id="{{ elementIdPrefix }}image_size_h" type="number" class="widefat image_size_h">
                    </td>
                </tr>
            </table>
            <p></p>
            <div class="media-widget-preview <?php echo esc_attr( $this->id_base ); ?>">
                <div class="attachment-media-view">
                    <button type="button" class="select-media button-add-media not-selected">
                        <?php echo esc_html( $this->l10n['add_media'] ); ?>
                    </button>
                </div>
            </div>
            <p class="media-widget-buttons">
                <button type="button" class="button edit-media selected">
                    <?php echo esc_html( $this->l10n['edit_media'] ); ?>
                </button>
            <?php if ( ! empty( $this->l10n['replace_media'] ) ) : ?>
                <button type="button" class="button change-media select-media selected">
                    <?php echo esc_html( $this->l10n['replace_media'] ); ?>
                </button>
            <?php endif; ?>
            </p>
            <div class="media-widget-fields">
            </div>
        </script>
        <script type="text/html" id="tmpl-wp-media-widget-gallery-preview">
            <#
            var ids = _.filter( data.ids, function( id ) {
                return ( id in data.attachments );
            } );
            #>
            <# if ( ids.length ) { #>
                <ul class="gallery media-widget-gallery-preview" role="list">
                    <# _.each( ids, function( id, index ) { #>
                        <# var attachment = data.attachments[ id ]; #>
                        <# if ( index < 6 ) { #>
                            <li class="gallery-item">
                                <div class="gallery-icon">
                                    <img alt="{{ attachment.alt }}"
                                        <# if ( index === 5 && data.ids.length > 6 ) { #> aria-hidden="true" <# } #>
                                        <# if ( attachment.sizes.thumbnail ) { #>
                                            src="{{ attachment.sizes.thumbnail.url }}" width="{{ attachment.sizes.thumbnail.width }}" height="{{ attachment.sizes.thumbnail.height }}"
                                        <# } else { #>
                                            src="{{ attachment.url }}"
                                        <# } #>
                                        <# if ( ! attachment.alt && attachment.filename ) { #>
                                            aria-label="
                                            <?php
                                            echo esc_attr(
                                                sprintf(
                                                    /* translators: %s: The image file name. */
                                                    esc_html__( 'The current image has no alternative text. The file name is: %s' , 'finanzia'),
                                                    '{{ attachment.filename }}'
                                                )
                                            );
                                            ?>
                                            "
                                        <# } #>
                                    />
                                    <# if ( index === 5 && data.ids.length > 6 ) { #>
                                    <div class="gallery-icon-placeholder">
                                        <p class="gallery-icon-placeholder-text" aria-label="
                                        <?php
                                            printf(
                                                /* translators: %s: The amount of additional, not visible images in the gallery widget preview. */
                                                __( 'Additional images added to this gallery: %s', 'finanzia' ),
                                                '{{ data.ids.length - 5 }}'
                                            );
                                        ?>
                                        ">+{{ data.ids.length - 5 }}</p>
                                    </div>
                                    <# } #>
                                </div>
                            </li>
                        <# } #>
                    <# } ); #>
                </ul>
            <# } else { #>
                <div class="attachment-media-view">
                    <button type="button" class="placeholder button-add-media"><?php echo esc_html( $this->l10n['add_media'] ); ?></button>
                </div>
            <# } #>
        </script>
        <?php
        }
        protected function has_content( $instance ) {
            if ( ! empty( $instance['ids'] ) ) {
                $attachments = wp_parse_id_list( $instance['ids'] );
                foreach ( $attachments as $attachment ) {
                    if ( 'attachment' !== get_post_type( $attachment ) ) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}
/**
 * Follow Us widgets
 *
 * @package CMS Theme
 * @subpackage 
 * @since 1.0
 * 
 */
if(function_exists('etc_register_wp_widget')){
    add_action( 'widgets_init', function(){
        etc_register_wp_widget( 'CMS_Follow_Us_Widget' );
    });

    class CMS_Follow_Us_Widget extends WP_Widget
    {
        function __construct()
        {
            parent::__construct(
                'cms_follow_us',
                esc_html__( '*CMS Follow Us', 'finanzia' ),
                array(
                    'description' => esc_attr__( 'Shows your social networks.', 'finanzia' ),
                    'customize_selective_refresh' => true,
                )
            );
        }

        /**
         * Outputs the HTML for this widget.
         *
         * @param array $args An array of standard parameters for widgets in this theme
         * @param array $instance An array of settings for this widget instance
         * @return void Echoes it's output
         **/
        function widget( $args, $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'   => '',
                'url1'    => 'https://facebook.com/cmssuperheroes',
                'icon1'   => 'facebook',
                'url2'    => 'https://instagram.com/',
                'icon2'   => 'instagram',
                'url3'    => 'https://tiktok.com/',
                'icon3'   => 'tik-tok', 
                'url4'    => 'https://twitter.com/',
                'icon4'   => 'twitter', 
                'url5'    => '',
                'icon5'   => '',
                'url6'    => '',
                'icon6'   => '', 
            ) );
            $title = empty( $instance['title'] ) ? '' : $instance['title'];
            $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

            printf( '%s', $args['before_widget']);

            if(!empty($title)){
                printf( '%s %s %s', $args['before_title'] , $title , $args['after_title']);
            }
        ?>
        <div class="cms-wg-follow-us">
            <?php  if(!empty($instance['url1']) && !empty($instance['icon1'])){ ?>
                <a href="<?php echo esc_url($instance['url1']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon1'].'.svg';
                ?></a>
            <?php }
            if(!empty($instance['url2']) && !empty($instance['icon2'])){ ?>
                <a href="<?php echo esc_url($instance['url2']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon2'].'.svg';
                ?></a>
            <?php }
            if(!empty($instance['url3']) && !empty($instance['icon3'])){ ?>
                <a href="<?php echo esc_url($instance['url3']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon3'].'.svg';
                ?></a>
            <?php }
            if(!empty($instance['url4']) && !empty($instance['icon4'])){ ?>
                <a href="<?php echo esc_url($instance['url4']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon4'].'.svg';
                ?></a>
            <?php }
            if(!empty($instance['url5']) && !empty($instance['icon5'])){ ?>
                <a href="<?php echo esc_url($instance['url5']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon5'].'.svg';
                ?></a>
            <?php }
            if(!empty($instance['url6']) && !empty($instance['icon6'])){ ?>
                <a href="<?php echo esc_url($instance['url6']) ?>" target="_blank" class="text-20"><?php
                    include get_template_directory().'/assets/svgs/core/'.$instance['icon6'].'.svg';
                ?></a>
            <?php } ?>
        </div>
        <?php
            printf('%s', $args['after_widget']);
        }

        /**
         * Deals with the settings when they are saved by the admin. Here is
         * where any validation should be dealt with.
         *
         * @param array $new_instance An array of new settings as submitted by the admin
         * @param array $old_instance An array of the previous settings
         * @return array The validated and (if necessary) amended settings
         **/
        function update( $new_instance, $old_instance )
        {
            $instance          = $old_instance;
            $instance['title'] = sanitize_text_field( $new_instance['title'] );

            $instance['url1']  = $new_instance['url1'];
            $instance['icon1'] = $new_instance['icon1'];
            $instance['url2']  = $new_instance['url2'];
            $instance['icon2'] = $new_instance['icon2'];
            $instance['url3']  = $new_instance['url3'];
            $instance['icon3'] = $new_instance['icon3'];
            $instance['url4']  = $new_instance['url4'];
            $instance['icon4'] = $new_instance['icon4'];
            $instance['url5']  = $new_instance['url5'];
            $instance['icon5'] = $new_instance['icon5'];
            $instance['url6']  = $new_instance['url6'];
            $instance['icon6'] = $new_instance['icon6'];

            return $instance;
        }

        /**
         * Displays the form for this widget on the Widgets page of the WP Admin area.
         *
         * @param array $instance An array of the current settings for this widget
         * @return void Echoes it's output
         **/
        function form( $instance )
        {
            $instance = wp_parse_args( (array) $instance, array(
                'title'   => esc_html__( 'CMS Follow Us', 'finanzia' ),
                'url1'    => 'https://facebook.com/cmssuperheroes',
                'icon1'   => 'facebook',
                'url2'    => 'https://instagram.com/',
                'icon2'   => 'instagram',
                'url3'    => 'https://tiktok.com/',
                'icon3'   => 'tik-tok', 
                'url4'    => 'https://twitter.com/',
                'icon4'   => 'twitter', 
                'url5'    => '',
                'icon5'   => '',
                'url6'    => '',
                'icon6'   => '', 
            ) );
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'finanzia' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />
            </p>
            <?php for ($i=1; $i <= 6 ; $i++) { ?>
                <table>
                    <tr><td colspan="2"><strong><?php echo esc_html__('Network','finanzia').' '.$i; ?></strong></td></tr>
                    <tr>
                        <td>
                            <label for="<?php echo esc_attr($this->get_field_id( 'url'.$i ) ); ?>"><?php echo esc_html__( 'Url', 'finanzia' ); ?></label>
                            <input class="" id="<?php echo esc_attr($this->get_field_id( 'url'.$i ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'url'.$i ) ); ?>" type="text" value="<?php echo esc_attr( $instance['url'.$i]); ?>" />
                        </td>
                        <td>
                            <label for="<?php echo esc_attr($this->get_field_id( 'icon'.$i ) ); ?>"><?php echo esc_html__( 'Icon', 'finanzia' ); ?></label>
                            <input class="" id="<?php echo esc_attr($this->get_field_id( 'icon'.$i ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon'.$i ) ); ?>" type="text" value="<?php echo esc_attr( $instance['icon'.$i] ); ?>" />
                        </td>
                    </tr>
                </table>
                <?php
            }
        }
    }
}
/**
 * Media 
 * Custom Image attributes
 * Lazy loading 
 * 
 * */
add_filter('wp_lazy_loading_enabled', '__return_true');
add_filter('wp_get_attachment_image_attributes', function($attr){ $attr['loading'] = 'lazy'; return $attr;});
?>