<?php 
/**
 * Custom WooCommerce Currency Switcher
 * 
 * https://currency-switcher.com/codex/
 * 
 * **/
if(!function_exists('finanzia_woocs_currency_switcher')){
	function finanzia_woocs_currency_switcher($args = []){
		$args = wp_parse_args($args, [
			'class'			   => '',
			'item_class'	   => '',
			'link_class'	   => '',
			'sub_link_class'   => '',			
			'show_flags'       => 'yes',
			'show_money_signs' => 'no',
			'show_text'        => 'yes',
			'text_as'          => 'description', // value: name / description
			'dropdown_pos'	   => 'bottom'	
		]);
		global $WOOCS;
		$all_currencies   = $WOOCS->get_currencies();
		$current_currency = $WOOCS->current_currency;
		$empty_flag       = WOOCS_LINK . 'img/no_flag.png';
		$show_flags       = $args['show_flags'];
		$show_money_signs = $args['show_money_signs'];
		$show_text        = $args['show_text'];
		$text_as          = $args['text_as'];

		$item_classes = ['cms-woocs-item', $args['item_class']];
		$link_classes = ['cms-woocs-current', $args['link_class']];
		$sub_link_classes = ['cms-woocs', $args['sub_link_class']];
 	?>
	<ul class="cms-woocs-menu cms-dropdown dropdown-<?php echo esc_attr($args['dropdown_pos']);?> cms-touchedside">
		<li class="<?php echo finanzia_nice_class(array_merge($item_classes, ['current-item'])); ?>">
			<?php 
				foreach ($all_currencies as $key => $currency) {
					if (isset($currency['hide_on_front']) && $currency['hide_on_front']) {
	                        continue;
	                    }
			            $option_txt = $currency[$args['text_as']];
			            if ($show_money_signs === 'yes') {
			                if (!empty($option_txt)) {
			                    $option_txt .= ', ' . $currency['symbol'];
			                } else {
			                    $option_txt = $currency['symbol'];
			                }
			            }
			            //***
			            if (isset($txt_type)) {
			                if ($txt_type == 'desc') {
			                    if (!empty($currency['description'])) {
			                        $option_txt = $currency['description'];
			                    }
			                }
			            }
			            // Flag
			            $flag_url = !empty($currency['flag']) ? $currency['flag'] : $empty_flag;
					if($current_currency === $key){
					?>
					<a href="#" class="<?php echo finanzia_nice_class($link_classes); ?>" data-currency="<?php echo esc_attr($currency['name']) ?>" title="<?php echo esc_attr($currency['name']) . ', ' . esc_attr($currency['symbol']) . ' ' . esc_attr($currency['description']) ?>" onclick="event.preventDefault()">
	        			<?php if($show_flags === 'yes') { ?>
	        				<img src="<?php echo esc_attr($flag_url) ?>" alt="<?php echo esc_attr($currency['name']) . ', ' . esc_attr($currency['symbol']) ?>" class="pr-10" />
	        			<?php } ?>
	        			<?php if($show_text === 'yes') { ?>
	        				<span class="cms-hidden-laptop"><?php echo esc_html($option_txt); ?></span>
	        				<span class="cms-hidden-desktop"><?php echo esc_html('('.$currency['name'].' '.$currency['symbol'].')');?></span>
	        			<?php } ?>
	        			<span class="cmsi-chevron-down text-10"></span>
	        		</a>
					<?php
					}
				}
			?>
			<ul class="dropdown cms--touchedside">
				<?php
					foreach ($all_currencies as $key => $currency) {
						if (isset($currency['hide_on_front']) AND $currency['hide_on_front']) {
			                        continue;
			                    }
			            $option_txt = $currency[$args['text_as']];
			            if ($show_money_signs === 'yes') {
			                if (!empty($option_txt)) {
			                    $option_txt .= ', ' . $currency['symbol'];
			                } else {
			                    $option_txt = $currency['symbol'];
			                }
			            }
			            //***
			            if (isset($txt_type)) {
			                if ($txt_type == 'desc') {
			                    if (!empty($currency['description'])) {
			                        $option_txt = $currency['description'];
			                    }
			                }
			            }
			            // Flag
			            $flag_url = !empty($currency['flag']) ? $currency['flag'] : $empty_flag;

			            if($current_currency !== $key){
			        ?>
			        	<li class="<?php echo finanzia_nice_class($item_classes); ?>">
			        		<a href="#" class="<?php echo finanzia_nice_class($sub_link_classes); ?>" data-currency="<?php echo esc_attr($currency['name']) ?>" title="<?php echo esc_attr($currency['name']) . ', ' . esc_attr($currency['symbol']) . ' ' . esc_attr($currency['description']) ?>" class="">
			        			<?php //if($show_flags === 'yes') { ?>
			        				<img src="<?php echo esc_attr($flag_url) ?>" alt="<?php echo esc_attr($currency['name']) . ', ' . esc_attr($currency['symbol']) ?>" class="pr-10" />
			        			<?php //} ?>
			        			<?php //echo esc_html($option_txt); 
			        				echo esc_html($currency['name'].' '.esc_attr($currency['symbol']));
			        			?>
			        		</a>
			        	</li>
			        <?php
			        	}
					}
				?>
			</ul>
		</li>
	</ul>
	<?php
	}
}
?>