<?php
/**
 * Functions and definitions
 *
 * @package CMS Theme
 * @subpackage Finanzia
 * 
 */
//
remove_action( 'plugins_loaded', '_wp_add_additional_image_sizes', 0 );
if ( ! function_exists( 'finanzia_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function finanzia_setup() {
		// Make theme available for translation.
		load_theme_textdomain( 'finanzia', get_template_directory() . '/languages' );
		// Theme Support
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support(
			'html5',
			[
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
				'navigation-widgets'
			]
		);
		add_theme_support(
			'custom-logo',
			[
				'height'      => 100,
				'width'       => 350,
				'flex-height' => true,
				'flex-width'  => true,
			] 
		);
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Finanzia Primary Menu', 'finanzia' )
		) );
		/*
		 * WooCommerce.
		 */
		if ( apply_filters( 'finanzia_add_woocommerce_support', true ) ) {
			add_theme_support(
				'woocommerce',
				apply_filters(
					'finanzia_woocommerce_args',
					array(
						'thumbnail_image_width'         => 768,
						'single_image_width'            => 768,
						'gallery_thumbnail_image_width' => 150,
						'product_grid'                  => array(
							'default_columns' => 3,
							'default_rows'    => 3,
							'min_columns'     => 1,
							'max_columns'     => 5,
							'min_rows'        => 1,
						),
					)
				)
			);
			//add_theme_support( 'wc-product-gallery-zoom' );
			if(!class_exists('\Elementor\Plugin')){
				add_theme_support( 'wc-product-gallery-lightbox' );
			}
			add_theme_support( 'wc-product-gallery-slider' );
		}
	}
endif;
add_action( 'after_setup_theme', 'finanzia_setup' );

/**
 * Update Wordpress Configs
 * Change thumbnail size
 * Size list
 * https://developer.wordpress.org/reference/functions/add_image_size/#reserved-image-size-names
 * 
 * */
add_action('after_switch_theme', 'finanzia_thumbnail_size');
if(!function_exists('finanzia_thumbnail_size')){
    function finanzia_thumbnail_size(){
        /* Change default image thumbnail sizes in wordpress */
        $thumbnail_size = array(
            // Large
            'large_size_w'        => 840,
            'large_size_h'        => 560,
            'large_crop'          => 1, 
            // Medium Large
            //'medium_large_size_w' => 768,
            //'medium_large_size_h' => 768,
            'medium_large_crop'   => 1, 
            // Medium
            'medium_size_w'       => 768,
            'medium_size_h'       => 768,
            'medium_crop'         => 1, 
            // thumbnail
            'thumbnail_size_w'    => 150,
            'thumbnail_size_h'    => 150,
            'thumbnail_crop'      => 1,
            /**
             * thumb
             * default no custom
             * use for special products layout
             * 
             */
            //'thumb_size_w'    => 150,
            //'thumb_size_h'    => 150,
            //'thumb_crop'      => 1,
        );
        foreach ($thumbnail_size as $option => $value) {
            if (get_option($option, '') != $value)
                update_option($option, $value);
        }
    }
}
/**
 * Custom default Woo thumbnail size
 * 
 * https://woocommerce.com/document/image-sizes-theme-developers/
 *
 */
// Loop Products thumbnail 
add_filter('woocommerce_get_image_size_thumbnail', function($size){
    $size['width']  = 768;
    $size['height'] = 768;
    $size['crop']   = ['center','center'];
    return $size;
});
// Image Sizes - Single
add_filter( 'woocommerce_get_image_size_single', function ( $size ) {
    $size['width']  = 768;
    $size['height'] = 768;
    $size['crop']   = ['center','center'];
    return $size;
} );
// Gallery Image Thumb Sizes - Loop
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function ( $size ) {
    $size['width']  = 150;
    $size['height'] = 150;
    $size['crop']   = ['center','center'];
    return $size;
} );
add_filter('woocommerce_gallery_thumbnail_size', function($size){
    $size['width']  = 150;
    $size['height'] = 150;
    $size['crop']   = ['center','center'];
    return $size;
});
// Remove 2X image size
function wealth_remove_extra_image_sizes() {
    $sizes = ['1536x1536', '2048x2048', 'trp-custom-language-flag'];
    foreach ( $sizes as $size ) {
        remove_image_size( $size );
    }
}
add_action('init', 'wealth_remove_extra_image_sizes');

/**
 *  Custom theme thumbnail size
 * https://developer.wordpress.org/reference/functions/add_image_size/#reserved-image-size-names
 * 
 **/
add_action( 'after_setup_theme', 'finanzia_thumbnail_custom_sizes' );
add_action( 'after_switch_theme', 'finanzia_thumbnail_custom_sizes' );
if(!function_exists('finanzia_thumbnail_custom_sizes')){
	function finanzia_thumbnail_custom_sizes(){
		// Custom Thumbnail size
		//add_image_size('woocommerce_thumbnail_square', 660, 660, array( 'center', 'center' ));
	}
}
/**
 *  Show custom size in list
 * https://developer.wordpress.org/reference/functions/add_image_size/#for-media-library-images-admin
 * 
 **/
add_filter( 'image_size_names_choose', 'finanzia_image_size_names_choose' );
function finanzia_image_size_names_choose( $sizes ) {
    return array_merge( $sizes, array(
        'medium_large' => esc_html__('Medium Large','finanzia'),
    ) );
}
// Primary Location
add_action( 'cms_locations', function ( $cms_locations ) {
	return $cms_locations;
} );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 */
function finanzia_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'finanzia_content_width', 840 );
}
add_action( 'after_setup_theme', 'finanzia_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
function finanzia_scripts() {
	$theme = wp_get_theme( get_template() );
	$min = defined('DEV_MODE') && DEV_MODE == true ? '' : '.min';
	$theme_css_dependentcy = [];
	if(class_exists('\Elementor\Plugin')){
		$theme_css_dependentcy[] = 'elementor-frontend';
		wp_enqueue_style('e-animation-fadeInLeft');
		wp_enqueue_style('e-animation-fadeInRight');
		wp_enqueue_style('e-animation-fadeInUp');
	}
	// Theme style
	wp_enqueue_style( 'finanzia-heading-font', 'https://use.typekit.net/ewt3tpu.css', '', $theme->get( 'Version' ) );
	wp_enqueue_style( 'finanzia', get_template_directory_uri() . '/assets/css/theme.css', $theme_css_dependentcy, $theme->get( 'Version' ) );
	wp_add_inline_style('finanzia', finanzia_inline_styles() );
	// WP Comment
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	// modernizr
    wp_enqueue_script('modernizr',get_template_directory_uri().'/assets/js/modernizr.js', [],'3.6.0', true );

	/* Theme JS */
	wp_enqueue_script( 'finanzia-main', get_template_directory_uri() . '/assets/js/main'.$min.'.js', array( 'jquery' ), $theme->get( 'Version' ), true );
	wp_localize_script( 'finanzia-main', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

	/*
	 * Elementor Widget JS
	 */
	// Elementor Custom
    wp_register_script('cms-elementor-custom', get_template_directory_uri() . '/elementor/js/elementor-custom.js', [ 'jquery' ], $theme->get( 'Version' ), true);
	// CMS Post Carousel Widget
	wp_register_script( 'cms-post-carousel-widget-js', get_template_directory_uri() . '/elementor/js/cms-post-carousel-widget.js', [ 'jquery' ], $theme->get( 'Version' ) , true );
	// Galleries
    wp_register_script('cms-galleries', get_template_directory_uri() . '/elementor/js/cms-galleries.js', [ 'jquery' ], $theme->get( 'Version' ), true);
	// Google Maps Widget
	$api    = finanzia_get_opt( 'gm_api_key', 'AIzaSyC08_qdlXXCWiFNVj02d-L2BDK5qr6ZnfM' );
	$api_js = "https://maps.googleapis.com/maps/api/js?sensor=false&key=" . $api;
	wp_register_script( 'maps-googleapis', $api_js, [], date( "Ymd" ) );
	wp_register_script( 'custom-gm-widget-js', get_template_directory_uri() . '/elementor/js/custom-gm-widget.js', [
		'maps-googleapis',
		'jquery'
	], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-post-grid-widget-js', get_template_directory_uri() . '/elementor/js/cms-post-grid-widget.js', [
		'isotope',
		'jquery'
	], $theme->get( 'Version' ), true );
    // multiScroll
    wp_register_script( 'multiScroll', get_template_directory_uri() . '/elementor/js/multiscroll/jquery.multiscroll'.$min.'.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    // jquery-parallax-scroll-js
    wp_enqueue_script( 'jquery-parallax-scroll', get_template_directory_uri() . '/elementor/js/parallax-scroll/jquery.parallax-scroll.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    // Video Player
    wp_register_script( 'youtube-iframe-api-js', 'https://www.youtube.com/iframe_api', array(), $theme->get( 'Version' ), true );
    wp_register_script( 'cms-video-widget-js', get_template_directory_uri() . '/elementor/js/cms-video-widget.js', [ 'jquery', 'youtube-iframe-api-js' ], $theme->get( 'Version' ) , true );
    // Chartjs
    wp_register_script( 'chartjs', get_template_directory_uri() . '/elementor/js/chart.min.js', array( 'jquery' ), $theme->get( 'Version' ), true );
    wp_register_script( 'cms-chartjs', get_template_directory_uri() . '/elementor/js/cms-chart.js', array( 'chartjs' ), $theme->get( 'Version' ), true );
    wp_register_script( 'cms-process-widget-js', get_template_directory_uri() . '/elementor/js/cms-process-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    wp_register_script( 'cms-service-scroll-widget-js', get_template_directory_uri() . '/elementor/js/cms-service-scroll-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    wp_register_script( 'cms-process-slider-widget-js', get_template_directory_uri() . '/elementor/js/cms-process-slider-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    wp_register_script( 'cms-accordion-sticky-widget-js', get_template_directory_uri() . '/elementor/js/cms-accordion-sticky-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
    wp_register_script( 'cms-theme-process-scroll', get_template_directory_uri() . '/elementor/js/cms-theme-process-scroll.js', [ 'jquery' ], $theme->get( 'Version' ), true );
}
add_action( 'wp_enqueue_scripts', 'finanzia_scripts' );

/**
 * Theme Scripts
 * 
 */
function finanzia_theme_scripts() {
	$theme = wp_get_theme( get_template() );
    // GSAP
    wp_register_script( 'gsap', get_template_directory_uri().'/assets/theme/gsap/gsap.min.js',[],'3.12.5',true);
	wp_register_script( 'gsap-sticky-scroll', get_template_directory_uri() .'/elementor/js/cms-gsap-sticky-scroll.js', [ 'gsap' ], '3.12.5', true );
	// Hover
    wp_register_script( 'cms-hover', get_template_directory_uri().'/elementor/js/cms-hover.js',[],$theme->get( 'Version' ),true);
}
add_action( 'wp_enqueue_scripts', 'finanzia_theme_scripts');

/**
 * Default Font 
 * */
if(!function_exists('finanzia_default_fonts')){
	function finanzia_default_fonts(){
		$body_font    = str_replace(' ', '+',finanzia_configs('body')['family']);
		$heading_font = str_replace(' ', '+',finanzia_configs('heading')['family']);

		$body_font_opts = finanzia_get_opts('body_font', 'default');
		$heading_font_opts = finanzia_get_opts('heading_font', 'default');
		
	?>
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<?php if($body_font_opts=='default'){ ?>
		<link href="https://fonts.googleapis.com/css2?family=<?php echo esc_html($body_font); ?>:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap" rel="stylesheet">
	<?php }
		if($heading_font_opts=='default'){
	?>
		<link href="https://fonts.googleapis.com/css2?family=<?php echo esc_html($heading_font); ?>:wght@300..700&display=swap" rel="stylesheet">
	<?php
		}
	}
}
add_action('wp_footer','finanzia_default_fonts');

/**
 * Widgets
 * Just show widgets if it enable via theme option
 * **/
function finanzia_widgets(){
    // Register Theme Sidebars
    if(class_exists('Theme_Core_Options')){
    	$all = apply_filters('finanzia_register_sidebar_all_post_type', false);
    	if($all){
	        $all_post_type = finanzia_all_post_types();
	        unset($all_post_type['product']);
	        foreach ($all_post_type as $key => $value) {
	            register_sidebar([
	                'name'          => sprintf( esc_html__( '%s Sidebar', 'finanzia' ), $value ),
	                'id'            => 'sidebar-'.$key,
	                'description'   => sprintf(esc_html__( 'Add widgets here to show in %1$s archive page and single %2$s page', 'finanzia' ), strtoupper(str_replace('-', ' ', $key)), $value),
	                'class'         => 'cms-post-type-widget',
	                'title_class'   => ''
	            ]);
	        }
	    } else {
	    	register_sidebar([
                'name'          => esc_html__( 'Blog Sidebar', 'finanzia' ),
                'id'            => 'sidebar-post',
                'description'   => esc_html__( 'Add widgets here to show in Blog archive page and single post page', 'finanzia' ),
                'class'         => 'cms-post-type-widget',
                'before_widget' => '<div id="%1$s" class="cms-widget cms-blog-widget bg-grey p-40 p-lr-smobile-20 %2$s">',
        		'after_widget'  => '</div>',
            ]);
	    }

        // WooCommerce Sidebar
        if(class_exists('WooCommerce')){
            register_sidebar([
                'name'          => esc_html__( 'Shop Sidebar', 'finanzia' ),
                'id'            => 'sidebar-product',
                'description'   => esc_html__( 'Add widgets here to show in WooCommerce archive and single product page', 'finanzia'),
                'class'         => 'cms-post-type-widget',
                'before_widget' => '<div id="%1$s" class="cms-widget cms-shop-widget %2$s">',
        		'after_widget'  => '</div>',
        		'before_title'  => '<h3 class="cms-shop-wgtitle">',
        		'after_title'	=> '</h3>'
            ]);
        }
    }
}
add_action( 'widgets_init', 'finanzia_widgets', 11 );
/* Disable Widgets Block Editor */
add_filter( 'use_widgets_block_editor', '__return_false' );
/**
 * Change default widget title structure
*/
if(!function_exists('finanzia_widgets_structure')){
    add_filter('widget_display_callback', 'finanzia_widgets_structure');
    add_filter('register_sidebar_defaults', 'finanzia_widgets_structure');
    function finanzia_widgets_structure($args){
        $args = wp_parse_args($args, [
            'class'       => '',  
            'title_class' => ''
        ]);
        $widget_title_tag = 'h4';
        $title_class = [
            'cms-wgtitle',
            isset($args['title_class']) ? $args['title_class'] : ''
        ];
        $args['before_title'] = '<h3 class="'.implode(' ', array_filter($title_class)).'">';
        $args['after_title'] = '</h3>';
        return $args;
    }
}
/**
 * Remove Some CSS
 * 
*/
if(!function_exists('etc_remove_scripts')){
    add_action( 'wp_enqueue_scripts', 'etc_remove_scripts', 999 );
    add_action( 'wp_footer', 'etc_remove_styles', 999 );
    add_action( 'wp_header', 'etc_remove_styles', 999 );
    function etc_remove_scripts() {
        $default = ['isotope' ];
        $scripts  = apply_filters( 'etc_remove_scripts', $default );
        foreach ( $scripts as $script ) {
            wp_dequeue_script( $script );
            //wp_finanzia_deregister_script( $script );
        }
    }
}
if(!function_exists('etc_remove_styles')){
    add_action( 'wp_enqueue_scripts', 'etc_remove_styles', 999 );
    add_action( 'wp_footer', 'etc_remove_styles', 999 );
    add_action( 'wp_header', 'etc_remove_styles', 999 );
    function etc_remove_styles() {
        $default = ['gglcptch', 'isotope' ];
        $styles  = apply_filters( 'etc_remove_styles', $default );
        foreach ( $styles as $style ) {
            wp_dequeue_style( $style );
            //wp_finanzia_deregister_style( $style );
        }
    }
}
if(!function_exists('finanzia_remove_styles')){
    add_filter('etc_remove_styles', 'finanzia_remove_styles');
    function finanzia_remove_styles($styles){
        $_styles = [
            // newsletter
            'newsletter',
            // elementor
            'elementor-frontend-legacy',
            // woo
            'woocommerce-smallscreen',
            'woocommerce-general',
            'woocommerce-layout',
            'wc-blocks-vendors-style',
            'wc-blocks-style',
            // theme core
            'oc-css',
            'etc-main-css',
            'progressbar-lib-css',
            'slick-css',
            'tco-main-css',
            // language switcher
            //'trp-floater-language-switcher-style',
            //'trp-language-switcher-style',
            // csh login
            //'widget_style',
            //'cshlg_layout_1',
            // WPC Smart Wishlist
            //'woosw-frontend',
            // WPC Smart Quick View
            //'woosq-frontend',
            // WPC Badge Management
            //'wpcbm-frontend',
            // WPC Variations Swatches
            //'wpcvs-frontend',
            // WPC Product Size Chart
            //'wpcsc-frontend'
        ];
        $styles = array_merge($styles, $_styles);
        return $styles;
    }
}

/**
 *  Add admin styles 
 * 
 * */
function finanzia_admin_style() {
	$theme = wp_get_theme( get_template() );
	//admin
	wp_enqueue_style( 'finanzia-admin-style', get_template_directory_uri() . '/assets/admin/admin.css' );
	// import demo
	wp_enqueue_style( 'finanzia-get-started-css', get_template_directory_uri() . '/assets/admin/get-started.css' );
	wp_enqueue_script( 'finanzia-get-started-js', get_template_directory_uri() . '/assets/admin/get-started.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	wp_localize_script( 'finanzia-get-started-js', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
	// Widget Gallery
	wp_enqueue_script('cms-media-gallery-widget', get_template_directory_uri() . '/assets/admin/media-gallery-widget.js',  array( 'media-widgets' ) );
}
add_action( 'admin_enqueue_scripts', 'finanzia_admin_style' );

/**
 * Check if is build with Elementor
 * 
 * **/
if(!function_exists('finanzia_is_built_with_elementor')){
    function finanzia_is_built_with_elementor(){
    	if(cms_is_blog() || is_404()) return false;
        if ( class_exists('\Elementor\Plugin') && \Elementor\Plugin::$instance->documents->get( get_the_ID() )->is_built_with_elementor() ) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * Check if is Elementor preview mode
 * 
 * **/
if(!function_exists('finanzia_is_elementor_preview_mode')){
    function finanzia_is_elementor_preview_mode(){
    	if(!class_exists('\Elementor\Plugin')) return false;
        return \Elementor\Plugin::$instance->preview->is_preview_mode();
    }
}

/**
 * Custom Elementor Editor
 * */
add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'finanzia-elementor-custom-editor', get_template_directory_uri() . '/assets/admin/elementor-panel.css', array(), '1.0.0' );
});
add_action('elementor/preview/enqueue_styles',  function() {
	wp_enqueue_style( 'finanzia-elementor-custom-editor', get_template_directory_uri() . '/assets/admin/elementor-panel.css', array(), '1.0.0' );
    wp_enqueue_style( 'finanzia-elementor-custom-editor', get_template_directory_uri() . '/assets/admin/elementor-preview.css', array(), '1.0.0' );
});
/**
 * Custom template tags for this theme.
 * 
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Theme Functions
 */
require_once get_template_directory() . '/inc/theme-functions.php';

/**
 * Breadcrumb.
 */
require_once get_template_directory() . '/inc/classes/class-breadcrumb.php';

/**
 * Add Template Woocommerce
 */
add_filter('is_woocommerce', 'finanzia__is_woocommerce');
function finanzia__is_woocommerce(){
	if(class_exists('WooCommerce') && (is_product_taxonomy() || is_product() )){
		return true;
	}
	return false;
}
if(!function_exists('finanzia_is_woocommerce')){
	function finanzia_is_woocommerce(){
		if(class_exists('WooCommerce') && ( is_woocommerce() || is_shop() || is_cart() || is_checkout() || is_account_page() || is_singular('product'))){
			return true;
		}
		return false;
	}
}
if(!function_exists('finanzia_is_shop')){
	function finanzia_is_shop(){
		if(class_exists('WooCommerce') && ( is_shop())){
			return true;
		}
		return false;
	}
}
if ( class_exists( 'WooCommerce' ) ) {
	require_once( get_template_directory() . '/woocommerce/wc-function-hooks.php' );
}
/**
 * Contact Form 7
 * */
if(class_exists('WPCF7')){
	require_once( get_template_directory() . '/inc/extensions/cf7.php' );
}
/**
 * Translate Presss
 * */
if(class_exists('TRP_Translate_Press')){
	require_once( get_template_directory() . '/inc/extensions/translatepress.php' );
}
/**
 * FOX - WooCommerce Currency Swithcher
 * 
 * */
if(class_exists('WOOCS_STARTER')){
	require_once( get_template_directory() . '/inc/extensions/woocs.php' );
}
/**
 * Theme Options
 */
require get_template_directory() . '/inc/theme-options/theme-options.php';

/**
 * Post Type Options
 */
// Page Options
require get_template_directory() . '/inc/post-type-options/page-options.php';
// Single Product Options
require get_template_directory() . '/inc/post-type-options/product-options.php';

// CMS Service Options
require get_template_directory() . '/inc/post-type-options/service-options.php';
// CMS Industry Options
require get_template_directory() . '/inc/post-type-options/industry-options.php';
// CMS Case Options
require get_template_directory() . '/inc/post-type-options/case-options.php';
// CMS Career Options
require get_template_directory() . '/inc/post-type-options/career-options.php';

/**
 * CSS Generator.
 */
if ( ! class_exists( 'CSS_Generator' ) ) {
	require_once get_template_directory() . '/inc/classes/class-css-generator.php';
}
/**
 * Contact Form 7
 * Remove auto p
 * */
add_filter('wpcf7_autop_or_not', '__return_false');
/**
 * Enable Custom Post type
 * 
 * **/
// Portfolio
add_filter('finanzia_enable_portfolio', 'finanzia_enable_portfolio');
if(!function_exists('finanzia_enable_portfolio')){
	function finanzia_enable_portfolio(){
		return false;
	}
}
// Service
add_filter('finanzia_enable_service', 'finanzia_enable_service');
if(!function_exists('finanzia_enable_service')){
	function finanzia_enable_service(){
		return true;
	}
}
// Industry
add_filter('finanzia_enable_industry', 'finanzia_enable_industry');
if(!function_exists('finanzia_enable_industry')){
	function finanzia_enable_industry(){
		return true;
	}
}
// Case
add_filter('finanzia_enable_case', 'finanzia_enable_case');
if(!function_exists('finanzia_enable_case')){
	function finanzia_enable_case(){
		return true;
	}
}
// Career
add_filter('finanzia_enable_career', 'finanzia_enable_career');
if(!function_exists('finanzia_enable_career')){
	function finanzia_enable_career(){
		return true;
	}
}
// Header Top
add_filter('finanzia_enable_header_top', 'finanzia_enable_header_top');
if(!function_exists('finanzia_enable_header_top')){
	function finanzia_enable_header_top(){
		return true;
	}
}
// Footer
add_filter('finanzia_enable_footer', 'finanzia_enable_footer');
if(!function_exists('finanzia_enable_footer')){
	function finanzia_enable_footer(){
		return true;
	}
}
// Side Navigation
add_filter('finanzia_enable_sidenav', 'finanzia_enable_sidenav');
if(!function_exists('finanzia_enable_sidenav')){
	function finanzia_enable_sidenav(){
		return true;
	}
}
// Pop Up
add_filter('finanzia_enable_popup', 'finanzia_enable_popup');
if(!function_exists('finanzia_enable_popup')){
	function finanzia_enable_popup(){
		return true;
	}
}
// CMS element Template
add_filter('finanzia_enable_etemplate', 'finanzia_enable_etemplate');
if(!function_exists('finanzia_enable_etemplate')){
	function finanzia_enable_etemplate(){
		return true;
	}
}
/**
 * Enable mega menu
 **/
add_filter('cms_enable_megamenu', 'finanzia_enable_megamenu');
if(!function_exists('finanzia_enable_megamenu')){
    function finanzia_enable_megamenu(){
        return true;
    }
}
/**
 * Mega menu Full Width
 * 
 * */
add_filter('cms_enable_megamenu_full_width', 'finanzia_enable_megamenu_full_width');
if(!function_exists('finanzia_enable_megamenu_full_width')){
	function finanzia_enable_megamenu_full_width(){
		return true;
	}
}
add_filter('megamenu_full_width_opts', 'finanzia_megamenu_full_width_opts');
if(!function_exists('finanzia_megamenu_full_width_opts')){
	function finanzia_megamenu_full_width_opts($opts){
		$opts[] = [
	        'name' => 'container',
	        'title' => esc_html__('Container', 'finanzia')
	    ];
		return $opts;
	}
}
/* Enable onepage */
add_filter('cms_enable_onepage', 'finanzia_enable_onepage');
if(!function_exists('finanzia_enable_onepage')){
    function finanzia_enable_onepage(){
        return false;
    }
}
/*
 * Get Started
 */
if(is_admin()){
	require_once get_template_directory() . '/inc/get-started.php';
}

/**
 * Register block styles.
 */
if ( ! function_exists( 'finanzia_block_styles' ) ) :
	/**
	 * Register custom block styles
	 *
	 * @since Finanzia 1.0
	 * @return void
	 */
	function finanzia_block_styles() {
		register_block_style(
			'core/finanzia',
			array(
				'name'         => 'arrow-icon-finanzia',
				'label'        => __( 'Arrow icon', 'finanzia' )
			)
		);
	}
endif;
//add_action( 'init', 'finanzia_block_styles' );
/**
 * Register pattern categories.
 */
if ( ! function_exists( 'finanzia_pattern_categories' ) ) :
	/**
	 * Register pattern categories
	 *
	 * @since 1.0
	 * @return void
	 */
	function finanzia_pattern_categories() {
		register_block_pattern_category(
			'finanzia_page',
			array(
				'label'       => _x( 'Pages', 'Block pattern category', 'finanzia' ),
				'description' => __( 'A collection of full page layouts.', 'finanzia' ),
			)
		);
	}
endif;
//add_action( 'init', 'finanzia_pattern_categories' );
/**
 * Registers an editor stylesheet for the theme.
 */
function finanzia_theme_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
//add_action( 'admin_init', 'finanzia_theme_add_editor_styles' );
if ( ! function_exists( 'finanzia_setup_gutenblocks' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function finanzia_setup_gutenblocks() {
		/**
		 * Gutenberg
		 * Block 
		 * */
		add_theme_support( "wp-block-styles" );
		add_theme_support( "responsive-embeds");
		add_theme_support( "align-wide" );
		add_theme_support( "custom-header", [] );
		add_theme_support( "custom-background", [] );
	}
endif;
//add_action( 'after_setup_theme', 'finanzia_setup_gutenblocks' );

if(!function_exists('finanzia_pagination_data')){
	add_filter('etc-pagination-data', 'finanzia_pagination_data');
	function finanzia_pagination_data() {
		return [
			'get_posts_action'      => 'finanzia_load_more_post_grid',
			'get_pagination_action' => 'finanzia_get_pagination_html',
		];
	}
}
/**
 * use for get svg file content
 * */
require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';