<?php
// Video Banner
$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		'cms-evideo-'.$settings['layout'],
		'd-flex gap-40',
		'align-items-center'
	]
]);
$video_text = $widget->get_setting('video_text', 'Play Video');
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text', 'none' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading empty-none',
		'text-'.$widget->get_setting('smallheading_color','accent'),
		'font-500',
		'm-tb-n7 pb-15'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-21 m-tb-n5',
		'text-'.$widget->get_setting('heading_color','heading')
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('description_color','body'),
		'm-tb-n7 pt-25'
	])
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="flex-auto d-flex">
		<?php 
			finanzia_elementor_image_render($settings, [
				'size'			=> 'custom',
				'custom_size'   => ['width' => 120,'height' => 120],
				'img_class'     => 'circle'
		  	]);
		  	finanzia_elementor_button_video_render($widget, $settings, [
				'name'       => 'video_link',
				// icon
				'icon'       => $widget->get_setting('video_icon'),
				'icon_size'	 => 10,
				'icon_color' => '',
				'icon_class' => 'order-last pb-5',
				// text
				'text'       => $video_text,
				'text_class' => 'text-15 font-700 lh-147 text-'.$widget->get_setting('video_text_color', 'white'),
				// other
				'layout'        => '',
				'class'         => 'ml-n50 hover-icon-bounce',
				'inner_class'   => 'box-120 circle bg-accent relative text-'.$widget->get_setting('video_text_color', 'white'),
				// content
				'content_class' => 'd-flex gap-10 align-items-end',
				'content_after' => '<div class="cms--ripple text-accent text-hover-accent"></div>',
				//
				'default'       => true,
				// Stroke
				'stroke'        => false
			])
		?>
	</div>
	<div class="flex-basic">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo nl2br( $settings['description_text'] ); ?></div>
	</div>
</div>