<?php
// Video Banner
$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		'cms-evideo-'.$settings['layout'],
		'relative',
		'cms-gradient-black-bt',
		'overflow-hidden'
	]
]);
$video_text = $widget->get_setting('video_text', 'Always high quality manufacturing');
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
<?php 
	finanzia_elementor_image_render($settings, [
		'custom_size'   => ['width' => 510,'height' => 640],
		'img_class'     => 'img-cover',
		'before'        => '',
		'max_height'	=> true,
		'after'         => finanzia_elementor_button_video_render($widget, $settings, [
			'name'       => 'video_link',
			// icon
			'icon'       => $widget->get_setting('video_icon'),
			'icon_size'	 => 14,
			'icon_color' => '',
			'icon_class' => 'absolute center z-top',
			// text
			'text'       => $video_text,
			'text_class' => 'text-'.$widget->get_setting('video_text_color', 'white').' text-nowrap absolute cms-transition',
			// other
			'layout'        => 'circle-text',
			'class'         => 'cms-overlay',
			'inner_class'   => 'absolute center text-hover-accent text-'.$widget->get_setting('video_text_color', 'primary-darken'),
			// content
			'content_class' => '',
			//
			'echo'          => false,
			'default'       => true,
			// Stroke
			'stroke'        => false,
			'stroke_opts'   => [
				'width'       => 140,
				'height'      => 140,
				'color'       => 'var(--cms-'.$widget->get_setting('video_text_color', 'white').')',
				'color_hover' => 'var(--cms-'.$widget->get_setting('video_text_color', 'white').')'		
			],
			// Circle Settings
			'circle_settings' => [
				'class'      => 'cms-shadow-1 font-700 p-15 text-hover-accent cms-transition',
			    'dimensions' => 160,
			    'background' => 'white',
			    'color'      => 'primary-darken',
			    'text'		 => $video_text,
			    'text_size'	 => 30,
			    'echo'       => true,
			    'before'     => '',
			    'after'      => '',
			    // 
			    'svg_class'  => 'cms-spin ls-8',
			    //
			    'icon'		 => false,	
			    'icon_size'  => 40,
			    'icon_color' => 'accent'
			]
    	])
  	]);
?>
</div>