<?php
// Video Banner
$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		'cms-evideo-'.$settings['layout'],
		($settings['video_fit'] === 'yes') ? 'cms-evideo-fit' : '',
		'cms-sticky-grow'
	],
	'style' => 'height:300vh'
]);
// Wrap
$widget->add_render_attribute('wrap-inner', [
	'class' => [
		'cms-sticky--grow',
		'cms-radius-48',
		'text-white',
		'bg-accent-darken',
		'h-tablet-extra-100vh',
		'cms-sticky',
		'p-tb-110 p-tb-tablet-60',
		'overflow-hidden',
		'd-flex'
	],
	'style' => '--cms-sticky:0;'
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','white'),
		'elementor-invisible',
		'max-w'
	],
	'style' => '--max-w:660px;',
	'data-settings' => json_encode([
		'animation'       => 'fadeInUp',
		'animation_delay' => 300
	])
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc pt-20 empty-none',
		'text-'.$widget->get_setting('description_color','white'),
		'elementor-invisible'
	]),
	'data-settings' => json_encode([
		'animation'       => 'fadeInUp',
		'animation_delay' => 300
	])
]);
// YT Video
$widget->add_render_attribute('yt-video-playback',[
	'class'          => [
		($settings['lightbox'] != 'yes') ? 'cms-evideo-playback' : '',
		'overflow-hidden absolute center',
		// sticky grow-up
		'cms-sticky--grow-up',
		'cms-gradient-accent-bt cms-gradient-render'
	],
	'style' => 'width:730px;height: 487px;'
]);
$widget->add_render_attribute('yt-video',[
	'class'          => 'yt-video',
	'data-video-url' => $widget->get_setting('video_link'),
	'style'          => 'width: 100%;height:100%;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap-inner')); ?>>
		<?php  if($settings['lightbox'] !='yes'){ ?>
			<div <?php etc_print_html($widget->get_render_attribute_string('yt-video-playback')); ?>>
				<div <?php etc_print_html($widget->get_render_attribute_string('yt-video')); ?>></div>
			</div>
		<?php } 
			// Button Video
	    	if($settings['lightbox'] =='yes'){
	    	 	finanzia_elementor_button_video_render($widget, $settings, [
					'name'       => 'video_link',
					// icon
					'icon'       => $widget->get_setting('video_icon'),
					'icon_size'	 => 15,
					'icon_color' => $widget->get_setting('video_text_color', 'white'),
					'icon_class' => '',
					// text
					'text'       => $widget->get_setting('video_text'),
					'text_class' => 'text-'.$widget->get_setting('video_text_color', 'white'),
					// other
					'layout'        => '3',
					'class'         => 'absolute center box-96 circle bg-'.$widget->get_setting('stroke_color','white-15'),
					'inner_class'   => 'box-96 circle cms-transition cms-ripple text-'.$widget->get_setting('video_bg_color','accent').' bg-'.$widget->get_setting('video_bg_color','accent'),
					// content
					'content_class' => '',
					'content_before'=> '<span class="cms--ripple text-white text-hover-'.$widget->get_setting('video_bg_color','accent').'"></span>',
					//
					'echo'          => true,
					'default'       => true,
					'stroke'        => false
			    ]);
	    	}
		?>
		<div class="container relative z-top">
			<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		</div>
		<div class="container relative z-top align-self-end d-flex justify-content-end">
			<div class="max-w" style="--max-w:510px">
				<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo nl2br( $settings['description_text'] ); ?></div>
				<div class="d-flex gap-30 empty-none pt-35 elementor-invisible" data-settings='{"_animation":"fadeInUp"}'><?php
			    	// Link
				    finanzia_elementor_link_render($widget, $settings, [
						'name' 		=> 'link1_',
						'mode'		=> 'btn',
						'text_icon'	=> finanzia_svgs_icon([
							'icon'       => 'core/arrow-right',
							'icon_class' => '',
							'echo'       => false,
							'class'      => 'text-11'
						]),
						'class' => [
							'btn-lg cms-hover-move-icon-up',
						],
						'btn_color'        => 'white',
						'text_color'       => 'accent-darken',
						'btn_color_hover'  => 'accent',
						'text_color_hover' => 'white'
					]);
					// Link
				    finanzia_elementor_link_render($widget, $settings, [
						'name' 		=> 'link2_',
						'mode'		=> 'btn',
						'text_icon'	=> '',
						'class' => [
							'btn-lg',
						],
						'btn_prefix'       => 'btn-outline-',
						'btn_color'        => 'white',
						'text_color'       => 'white',
						'btn_color_hover'  => 'white',
						'text_color_hover' => 'accent'
					]);
				?></div>
			</div>
		</div>
	</div>
</div>
