<?php
$teams       = $widget->get_setting('teams', []);
//
$thumbnail_custom_dimension = [
 'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : 290,
 'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : 350
];
// Heading
$widget->add_render_attribute('heading', [
    'class' => [
        'team-heading cms-nl2br',
        'd-flex gutterX-40 gutterY-20',
        'pb-40',
        'cms-sticky'
    ]
]);
$widget->add_render_attribute('small-title', [
    'class'=>[
        'cms-smallheading empty-none',
        'text-'.$widget->get_setting('smalltitle_color','body'),
        'text-15',
        'col-5 col-tablet-4 col-mobile-extra-12'
    ]
]);
$widget->add_render_attribute('title', [
    'class'=>[
        'cms-heading empty-none',
        'text-'.$widget->get_setting('title_color','heading'),
        'm-tb-n7',
    ]
]);
$widget->add_render_attribute('desc', [
    'class'=>[
        'cms-desc empty-none',
        'text-'.$widget->get_setting('text_color','body'),
        'pt-23 mt-n5'
    ]
]);
?>
<div class="d-flex flex-nowrap justify-content-between flex-column">
    <div <?php etc_print_html($widget->get_render_attribute_string('heading')); ?>>
        <div <?php etc_print_html($widget->get_render_attribute_string('small-title')); ?>><?php etc_print_html($settings['small_title']); ?></div>
        <div class="col-7 col-tablet-8 col-mobile-extra-12">
            <h2 <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($settings['title']); ?></h2>
            <div <?php etc_print_html($widget->get_render_attribute_string('desc')); ?>><?php etc_print_html($settings['text']) ?></div>
            <div class="d-flex pt-30 gap-30"><?php 
                // Button
                finanzia_elementor_link_render($widget, $settings, [
                    'name'      => 'btn_',
                    'mode'      => 'btn',
                    'text_icon' => finanzia_svgs_icon([
                        'icon'       => 'core/long-arrow-right',
                        'icon_class' => '',
                        'echo'       => false,
                        'class'      => 'text-17'
                    ]),
                    'class'            => 'cms-hover-move-icon-right',
                    'btn_color'        => 'accent',
                    'text_color'       => 'white',
                    'btn_color_hover'  => 'accent-darken',
                    'text_color_hover' => 'white'
                ]);
                finanzia_elementor_link_render($widget, $settings, [
                    'name'      => 'btn2_',
                    'mode'      => 'btn',
                    'text_icon' => '',
                    'class'            => '',
                    'btn_prefix'       => 'btn-outline-', 
                    'btn_color'        => 'accent',
                    'text_color'       => 'accent',
                    'btn_color_hover'  => 'accent',
                    'text_color_hover' => 'white'
                ]);
            ?></div>
        </div>
    </div>
    <div class="cms-theme-teams pt" style="--pt:185px;--pt-tablet:80px;--pt-mobile-extra:20px;">
        <?php
            foreach ($teams as $key => $team) {
                $item_key = $widget->get_repeater_setting_key( 'item', 'cms_team', $key );
                $widget->add_render_attribute( $item_key,[
                    'class' => [
                        'cms-team-item',
                        'p-tb-20',
                        'bdr-b-1 bdr-divider',
                        'cms-hover-divider',
                        'divider-bottom',
                        'divider-4',
                        'divider-accent',
                        'cms-hover-change'
                    ],
                    'data-target' => 'cms-'.$team['_id']
                ]);
                if($key==0){
                    $widget->add_render_attribute( $item_key,[
                        'class' => [
                            'bdr-t-1'
                        ]
                    ]); 
                }
                // link
                $link_key = $widget->get_repeater_setting_key( 'link', 'cms_team', $key );
                $widget->add_render_attribute( $link_key, [
                    'class' => [
                        'team-name d-block overflow-hidden',
                        'mb-30',
                        'cms-hidden-min-mobile-extra',
                        'text-accent'
                    ]
                ]);
                $widget->add_link_attributes( $link_key, $team['link'] );
                //
                $link_key2 = $widget->get_repeater_setting_key( 'link2', 'cms_team', $key );
                $widget->add_render_attribute( $link_key2, [
                    'class' => [
                        'team-name relative',
                        'team-heading cms-heading text-21 text-accent',
                        'col-6 col-smobile-12'
                    ]
                ]);
                $widget->add_link_attributes( $link_key2, $team['link'] );

                ob_start();
                    for ($i = 1; $i <= 4; $i++) {
                        $social_icon = isset($team["social_icon_{$i}"]) ? $team["social_icon_{$i}"] : null;
                        $social_link = isset($team["social_link_{$i}"]) ? $team["social_link_{$i}"] : null;
                        if($social_icon && !empty($social_icon['value']) && $social_link){
                            if ( ! empty( $social_link['url'] ) ) {
                                $social_link_key = $widget->get_repeater_setting_key( "social_link_{$i}", 'cms_team', $key );
                                $widget->add_link_attributes( $social_link_key, $social_link );
                                $widget->add_render_attribute( $social_link_key, [
                                    'class' => [
                                        'team-social text-divider text-hover-accent text-on-hover-accent',
                                        'cms-hover-zoomout',
                                        'd-flex'
                                    ]
                                ]);
                                ?>
                                    <a <?php etc_print_html($widget->get_render_attribute_string( $social_link_key )); ?>><?php 
                                        finanzia_elementor_icon_render( $social_icon, [], [ 'aria-hidden' => 'true', 'class' => 'cms-eicon', 'icon_size' => 20 ] ); 
                                    ?></a>
                                <?php
                            }
                        }
                    }
                $socials_html = ob_get_clean();
                if(!empty($socials_html)){
                    $_socials_html = ob_start();
                    ?>
                        <div class="team-socials d-flex align-items-center gap-10 flex-auto flex-smobile-full"><?php etc_print_html($socials_html); ?></div>
                    <?php
                    $_socials_html = ob_get_clean();
                } else {
                    $_socials_html = '';
                }
                ?>
                <div <?php etc_print_html($widget->get_render_attribute_string( $item_key )); ?>>
                    <div class="team-content d-flex gapX-40 gapY-10 justify-content-between align-items-center">
                        <div class="cms-img-cursor flex-basic d-flex gapX-40 gapY-10">
                            <?php 
                                $team['image_size'] = $widget->get_setting('image_size');
                                $team['image_custom_dimension'] = $thumbnail_custom_dimension;
                            ?>
                            <span class="cms-cursor-pointer">
                                <span class="cms-cursor--pointer"><?php
                                    finanzia_elementor_image_render($team,[
                                        'name'           => 'image',
                                        'image_size_key' => 'image',
                                        'img_class'      => '',
                                        'custom_size'    => $thumbnail_custom_dimension,
                                        'max_height'     => false,
                                        //'before'         => '<a '.$widget->get_render_attribute_string( $link_key ).'>',
                                        //'after'          => '</a>'
                                    ]);
                                ?></span>
                            </span>
                            <a <?php etc_print_html($widget->get_render_attribute_string( $link_key2 )); ?>>
                                <?php echo esc_html($team['name']); ?>
                                <div class="team-desc empty-none pt-15 text-15 mb-n5 w-100"><?php 
                                    etc_print_html($team['description']); 
                                ?></div>
                            </a>
                            <div class="team-position empty-none text-15 m-tb-n5 col-6 col-smobile-12"><?php 
                                etc_print_html($team['position']); 
                            ?></div>
                        </div>
                        <?php etc_print_html($_socials_html); ?>
                    </div>
                </div>
            <?php
            }
        ?>
    </div>
</div>