<?php
$html_id     = etc_get_element_id($settings);
$tax         = array();
$source      = $widget->get_setting('source', '');
$orderby     = $widget->get_setting('orderby', 'date');
$order       = $widget->get_setting('order', 'desc');
$limit       = $widget->get_setting('limit', 3);
$layout_type = 'grid';

extract(etc_get_posts_of_grid('cms-service', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['service-category']));

$thumbnail_size             = $widget->get_setting('thumbnail_size','custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height'] : 380
];

$num_line        = !empty($settings['num_line']['size']) ? $settings['num_line']['size'] : 3;
$readmore_text   = $widget->get_setting('readmore_text', esc_html__('Read More','finanzia'));
$pagination_type = $widget->get_setting('pagination_type', 'pagination');

$posts_data = array(
    'post_type'                  => 'cms-service',
    'taxonomy'                   => 'service-category',
    //
    'startPage'                  => $paged,
    'maxPages'                   => $max,
    'total'                      => $total,
    'perpage'                    => $limit,
    'nextLink'                   => $next_link,
    'pagination_type'            => $pagination_type,
    //
    'layout'                     => $settings['layout'],
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_line'                   => $num_line,
    'readmore_text'              => $readmore_text,
    //
    'item_class'                 => 'flex-auto layout-'.$settings['layout']
);
$widget->add_render_attribute( 'heading', [
    'class' => [
        'bdr-b-1 bdr-divider-dark',
        'pb-60 mb-70 pb-tablet-30 mb-tablet-40'
    ]
]);
// Small Heading
//$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
    'class' => [
        'cms-smallheading text-15',
        'text-'.$widget->get_setting('smallheading_color','accent'),
        'pb-15 mt-n7',
        'empty-none'
    ]
]);
// Large Heading
//$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
    'class' => [
        'cms-heading empty-none',
        'text-'.$widget->get_setting('heading_color','heading')
    ]
]);
// Description
//$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
    'class' => array_filter([
        'cms-desc empty-none',
        'font-700',
        'text-'.$widget->get_setting('desc_color','body'),
        'mt-n7'
    ])
]);
// Description #2
//$widget->add_inline_editing_attributes( 'desc2' );
$widget->add_render_attribute( 'desc2', [
    'class' => array_filter([
        'cms-desc2 empty-none pt-25',
        'text-'.$widget->get_setting('desc2_color','body'),
        'mt-n7'
    ])
]);
// Content attributes
$widget->add_render_attribute('content',[
    'class' => [
        'cms-grid-content',
        'd-flex flex-nowrap flex-tablet-wrap',
        'flex-col-tablet-2 flex-col-mobile-1',
        'bg-accent-darken',
        'text-white',
        'mr-ncontainer2',
        'ml',
        'max-w'
    ],
    'style'           => [
        '--ml:70px;--ml-tablet:0;',
        '--max-w:510px;--max-w-tablet:100%;'
    ],
    'data-break'      => '1024'
]);
?>
<div class="cms-theme-service-scroll" data-breakpoint="1024">
    <div <?php etc_print_html( $widget->get_render_attribute_string( 'heading' ) ); ?>>
        <div class="max-w" style="--max-w:660px">
            <div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
            <h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
        </div>
    </div>
    <div class="d-flex gutter">
        <div class="col-4 col-tablet-12">
            <div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
            <div <?php etc_print_html( $widget->get_render_attribute_string( 'desc2' ) ); ?>><?php 
                echo nl2br( $settings['desc2'] ); 
            ?></div>
            <?php 
            finanzia_elementor_link_render($widget, $settings, [
                'name'      => 'link1_',
                'mode'      => 'btn',
                'text_icon' => finanzia_svgs_icon([
                    'icon'       => 'core/long-arrow-right',
                    'icon_class' => '',
                    'echo'       => false,
                    'class'      => 'text-17'
                ]),
                'class'            => ['mt-33','cms-hover-move-icon-right'],
                'btn_color'        => 'primary',
                'text_color'       => 'white',
                'btn_color_hover'  => 'accent',
                'text_color_hover' => 'white'
            ]);
            ?>
        </div>
        <div class="col-8 col-tablet-12">
            <div <?php etc_print_html($widget->get_render_attribute_string('content')); ?>><?php
                // extract($posts_data);
                foreach ($posts as $key => $post){
                ?>
                    <div class="<?php echo implode(' ', array_filter(['cms-item', $posts_data['item_class'], 'relative'])); ?> bdr-t-10 bdr-l-1 bdr-b-1 bdr-divider-dark">
                        <div class="cms--item bg-accent-darken bg-hover-accent cms-transition hover-image-zoom-out cms-hover-change p-50 p-lr-smobile-20 bdr-r-1 bdr-divider-dark h-100 d-flex flex-column justify-content-between">
                            <div>
                                <h3 class="heading text-line-3 text-26 lh-1154 bdr-b-2 bdr-divider-dark bdr-on-hover-divider-30 pb-20 mb-23 cms-transition"><a class="cms-hover-underline title text-white text-hover-white" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                                <div class="cms-excerpt text-primary-lighten text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> mb-n7"><?php 
                                    echo wp_kses_post($post->post_excerpt);
                                ?></div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center pt-80">
                                <?php
                                    $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                                    if(!empty($icon)){
                                        finanzia_post_icon_render([
                                            'id'         => $post->ID, 
                                            'class'      => '',
                                            'icon_color' => '',
                                            'before'     => '',
                                            'after'      => ''   
                                        ]);
                                    } else {
                                        // Post Image
                                        finanzia_elementor_post_thumbnail_render($settings, [
                                            'post_id'     => $post->ID,
                                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                            'img_class'   => '', 
                                            'max_height'  => true,
                                            'before'      => '',
                                            'after'       => ''
                                        ]);
                                    }
                                ?>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link cms-hover-move-icon-right cms-hover-show"><?php 
                                    //icon
                                    finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'box-87 circle bg-white bg-hover-accent-darken text-17 text-primary text-hover-white cms-transition']); 
                                    //text
                                    etc_print_html('<span class="screen-reader-text">'.$posts_data['readmore_text'].'</span>');
                                ?></a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>