<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-ecounter',
		'cms-ecounter-'.$settings['layout']
	]
]);
// Number
$widget->add_render_attribute('counter--number',[
	'class' => [
		'cms-counter-numbers heading text-size lh-07',
		'text-'.$widget->get_setting('number_color','primary'),
		'd-flex'
	],
	'style' => [
		'--text-size:80px;'
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', [
	'class' => [
		'cms-counter-title',
		'text-'.$widget->get_setting('title_color','heading'),
		'pb m-tb-n7'
	],
	'style' => [
		'--pb:100px;'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', [
	'class' => [
		'cms-counter-desc',
		'text-'.$widget->get_setting('desc_color','body'),
		'text-15',
		'pt-33 mb-n7',
		'bdr-t-1 bdr-divider-30'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php
		// Start Item
		$count = 0;
		foreach ($counters as $key => $counter) {
			$count ++;
			$item_offset_top = $key*30;
			$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
		    $widget->add_render_attribute( $data_counter, [
		        'class'          => [
		        	'cms-counter-number elementor-counter-number'
		        ],
		        'data-duration'  => $counter['duration'],
		        'data-to-value'  => $counter['ending_number'],
		        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
		    ] );
		    // Items
		    $counter_item_key = $widget->get_repeater_setting_key( 'counter-item', 'cms_counter', $key );
			$widget->add_render_attribute( $counter_item_key,[
				'class' => [
					'counter-item',
					'cms-sticky',
					($key > 0) ? 'mt' : ''
				],
				'style' => [
					'--mt:110px;--mt-tablet:50px;',
					'--cms-sticky:'.$widget->get_setting('offset_top', 110) + $item_offset_top.'px;',
					'--cms-sticky-laptop:'.$widget->get_setting('offset_top_laptop', 110) + $item_offset_top.'px;',
					'--cms-sticky-tablet-extra:'.$widget->get_setting('offset_top_tablet_extra', 60) + $item_offset_top.'px;',
					'--cms-sticky-tablet:'.$widget->get_setting('offset_top_tablet', 40) + $item_offset_top.'px;',
					'--cms-sticky-mobile-extra:'.$widget->get_setting('offset_top_mobile_extra', 40) + $item_offset_top.'px;',
					'--cms-sticky-mobile:'.$widget->get_setting('offset_top_mobile', 40) + $item_offset_top.'px;',
				]
			]);
			$counter__item_key = $widget->get_repeater_setting_key( 'counter--item', 'cms_counter', $key );
			$widget->add_render_attribute( $counter__item_key,[
				'class' => [
					'counter--item',
					'hover-icon-bounce',
					'p-40 p-lr-smobile-20',
					'cms-backdrop-1'
				]
			]);
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string($counter_item_key)); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string($counter__item_key)); ?>>
				<?php
				// Title
				if ( $counter['title'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
				<?php endif; ?>
				<div class="d-flex justify-content-between align-items-end gap-40 pb-40">
					<?php 
						// Counter Icon
						finanzia_elementor_icon_image_render($widget, $settings, [
							'name'	  	  => 'counter_icon',
							'size'        => 17,
							'color'       => $widget->get_setting('icon_color', 'primary-lighten'),
							'color_hover' => $widget->get_setting('icon_color', 'primary-lighten'),
							'class'       => ''
						], $counter);
					?>
					<div <?php etc_print_html($widget->get_render_attribute_string('counter--number')) ?>>
					    <span class="prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
					    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
					    <span class="suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
					</div>
				</div>
				<?php
				// Description
				if ( $counter['description'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
				<?php endif; 
				// Link
				finanzia_elementor_link_render($widget, $counter, [
					'name'		=> 'link1_',
					'loop' 		=> true,
					'loop_key'  => $key,
					'color'		=> false,
					'class'     => ['cms-link', 'mt-25 mb-n7', 'text-15 font-700']		
				]);
				?>
			</div>
		</div>
	<?php
		} // end foreach
	?>
	<div class="cms-sticky-fix cms-sticky" style="height:100px"></div>
</div>

