<?php
$html_id            = etc_get_element_id( $settings );
$active_section     = $widget->get_settings('active_section', 1);
$accordions         = $widget->get_settings('contents');
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-accordion-sticky-',
		'cms-accordion-sticky-'.$settings['layout']
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
		$count = 0;
		foreach ( $accordions as $key => $value ):
			$count ++;
			$_id        = 'cms-accordion-'.$value['_id'];
			$ac_title   = isset( $value['ac_title'] ) ? $value['ac_title'] : '';
			$ac_content = isset( $value['ac_content'] ) ? $value['ac_content'] : '';
			$ac_content2 = isset( $value['ac_content2'] ) ? $value['ac_content2'] : '';
			$ac_border_color = isset( $value['ac_border_color'] ) ? $value['ac_border_color'] : 'primary-lighten';

			$sticky = ($key*97)+100;
			$sticky_tablet = ($key*97)+30;
			// item
			$item_key = $widget->get_repeater_setting_key( 'item_key', 'cms_accordion', $key );
			$widget->add_render_attribute( $item_key, [
				'class' => [ 
					'cms-accordion-item',
					'cms-shadow-2 bg-white',
					'bdr-b-40 bdr-'.$ac_border_color,
					'p-50 p-lr-smobile-20',
					($key>0) ? 'mt-40':'',
					'cms-sticky'
				],
				'style' => [
					'--cms-sticky:'.$sticky.'px;',
					'--cms-sticky-tablet:'.$sticky_tablet.'px;',
				]
			]);
			// item title
			$title_key = $widget->get_repeater_setting_key( 'title_key', 'cms_accordion', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => [ 
					'cms-accordion-title',
					'text-23 text-tablet-19 font-700 text-primary',
					'bdr-b-1 bdr-divider',
					'pb-20 mt-n10',
					'mb'
				],
				'data-target' => '#'.$_id,
				'style'		  => '--mb:110px;--mb-tablet:40px;'
			]);
			// content #1
			$content_key1 = $widget->get_repeater_setting_key( 'ac_content1', 'cms_accordion', $key );
			$widget->add_render_attribute( $content_key1, [
				'class' => [ 
					'cms-accordion-content-1 empty-none',
					'font-700',
					'text-primary',
					'mt-n7'
				]
			] );
			// content
			$content_key2 = $widget->get_repeater_setting_key( 'ac_content2', 'cms_accordion', $key );
			$widget->add_render_attribute( $content_key2, [
				'id'    => $_id,
				'class' => [ 
					'cms-accordion-content-2 empty-none',
					'text-body',
					'pt-25 mb-n7'
				]
			] );
		?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( $item_key ) ); ?>>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>>
		    	<?php echo esc_html( $ac_title ); ?>
		    </div>
		    <div class="d-flex align-items-end gap" style="--cms-gap:60px;--cms-gap-tablet:30px;--cms-gap-mobile:20px;">
		    	<div class="flex-auto text-size text-primary-lighten lh-07 font-500 mobile-absolute bottom" style="--text-size:100px;"><?php
		    		finanzia_leading_zero($count);
		    	?></div>
		    	<div class="flex-basic relative z-top">
				    <div <?php etc_print_html( $widget->get_render_attribute_string( $content_key1 ) ); ?>><?php 
						echo wpautop( $ac_content );
					?></div>
					<div <?php etc_print_html( $widget->get_render_attribute_string( $content_key2 ) ); ?>><?php 
						echo wpautop( $ac_content2 );
					?></div>
				</div>
			</div>
		</div>
		<?php
		endforeach;
	?>
	<div class="cms-accordion-item-fix" style="height:50vh;"></div>
</div>