<?php 
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-text-scroll',
		'cms-text-scroll-'.$settings['layout']
	]
]);
// Text wrap
$widget->add_render_attribute('text-wrap', [
	'class' => [
		'cms-swiper-container swiper-container',
		'text-'.$widget->get_setting('text_color', 'primary'),
		'text-'.$settings['text_style'],
		'text-100 text-tablet-80 text-smobile-40 cms-heading'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'text-55 lh-1182'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc pt-20 empty-none',
		'text-'.$widget->get_setting('description_color','body')
	])
]);
// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
	case 'page':
		$page = !empty($link1_page) ? get_page_by_path($link1_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_inline_editing_attributes( 'link1_text' );
$widget->add_render_attribute( 'link1_text', [
	'class' => [
		'btn',
		'btn-outline-'.$widget->get_setting('link1_color','primary'),
		'text-'.$widget->get_setting('link1_color','primary'),
		'btn-hover-'.$widget->get_setting('link1_color_hover', 'primary'),
		'text-hover-white',
		'mt-30',
		'empty-none'
	],
	'href'	=> $url
]);
// Scroll Texts
$cms_texts = $widget->get_setting('cms_texts', []);
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['banner_custom_dimension']['width']) ? $settings['banner_custom_dimension']['width'] : '',
    'height' => !empty($settings['banner_custom_dimension']['height']) ? $settings['banner_custom_dimension']['height'] : ''
];
// Banner position
$banner_classes = [
	'banner flex-basic',
	$settings['banner_position']
];
switch ($settings['banner_position']) {
	case 'order-first':
		$banner_classes[] = 'pr-70 pr-tablet-extra-0';
		break;
	
	default:
		$banner_classes[] = 'pl-70 pl-tablet-extra-0';
		break;
}
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-text-scroll-heading d-flex justify-content-end gap">
		<?php 
			finanzia_elementor_image_render($settings, [
				'name'                => 'ebanner',
				'size'                => 'custom',
				'custom_size'         => ['width' => 930, 'height' => 720],
				'img_class'           => '',
				'as_background'       => true,
				'as_background_class' => '',
				'max_height'          => true,
				'before'              => '<div class="'.implode(' ', $banner_classes).'">',
				'after'               => '</div>'
			]);
		?>
		<div class="content flex-auto pt-90 pt-laptop-30 pt-tablet-extra-0 pb-tablet-30">
			<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo nl2br( $settings['description_text'] ); ?></div>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link1_text' ) ); ?>><?php 
				echo esc_html( $settings['link1_text'] ); 
			?></a>
		</div>
	</div>
	<div <?php etc_print_html($widget->get_render_attribute_string('text-wrap')); ?>>
		<div class="cms-swiper-wrapper swiper-wrapper">
			<?php foreach ($cms_texts as $key => $value) { ?>
				<div class="cms-swiper-slide swiper-slide d-flex gap-40">
					<div class="text empty-none"><?php echo nl2br($value['text']); ?></div>
					<?php
						finanzia_elementor_image_render($value, [
							'name'           => 'banner1',
							'image_size_key' => 'banner1',	
							'custom_size'    => $thumbnail_custom_dimension,
							'img_class'		   => '',
							'before'				 => '<div class="banner">',
							'after'					 => '</div>'
						]);
					?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>