<?php
$teams       = $widget->get_setting('teams', []);
$layout_mode = $widget->get_setting('layout_mode', 'carousel');
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-9',
    'box-58 circle',
    'text-'.$widget->get_setting('arrow_color','accent-darken'),
    'bdr-1 bdr-'.$widget->get_setting('arrow_color','accent-darken'),
    'bg-'.$widget->get_setting('arrow_bg_color','white'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bdr-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'cms-carousel-dots-primary cms-carousel-dots-active-accent-regular',
        'justify-content-start gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ]
]);
//
$thumbnail_custom_dimension = [
 'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : 290,
 'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : 370
];
// wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-eteam',
        'cms-eteam-'.$settings['layout'],
        'relative'
    ]
]);
// Grid Wrap
$widget->add_render_attribute('grid-wrap',[
    'class' => [
        'cms-eteam',
        'cms-eteam-'.$settings['layout'],
        'cms-team-grid',
        'd-flex gutter',
        finanzia_elementor_get_grid_columns($widget, $settings, [
            'default' => 3
        ])
    ]
]);
// Carousels
$widget->add_render_attribute('carousel-wrap',[
    'class' => [
        'cms-eteam',
        'cms-eteam-'.$settings['layout'],
        'cms-carousel swiper'
    ]
]);
// team item Classes
$team_item_classes = [
    'cms-team-item',
    ($settings['layout_mode'] === 'carousel') ? 'cms-swiper-item swiper-slide' : ''
];
?>
<?php switch ($settings['layout_mode']) {
    case 'grid':
?>
    <div <?php etc_print_html($widget->get_render_attribute_string('grid-wrap')) ?>>
<?php
        break;
    default:
?>
    <div <?php etc_print_html($widget->get_render_attribute_string('carousel-wrap')) ?>>
        <div class="swiper-wrapper">
<?php
        break;
} ?>
    <?php
    foreach ($teams as $key => $team) {
        $item_key = $widget->get_repeater_setting_key( 'item', 'cms_team', $key );
        $widget->add_render_attribute( $item_key,[
            'class' => $team_item_classes
        ]);

        // link
        $link_key = $widget->get_repeater_setting_key( 'link', 'cms_team', $key );
        $widget->add_render_attribute( $link_key, 'class', 'team-name d-block text-center overflow-hidden' );
        $widget->add_link_attributes( $link_key, $team['link'] );

        $link_key2 = $widget->get_repeater_setting_key( 'link2', 'cms_team', $key );
        $widget->add_render_attribute( $link_key2, 'class', 'team-name cms-hover-underline' );
        $widget->add_link_attributes( $link_key2, $team['link'] );

        ob_start();
            for ($i = 1; $i <= 4; $i++) {
                $social_icon = isset($team["social_icon_{$i}"]) ? $team["social_icon_{$i}"] : null;
                $social_link = isset($team["social_link_{$i}"]) ? $team["social_link_{$i}"] : null;
                if($social_icon && !empty($social_icon['value']) && $social_link){
                    if ( ! empty( $social_link['url'] ) ) {
                        $social_link_key = $widget->get_repeater_setting_key( "social_link_{$i}", 'cms_team', $key );
                        $widget->add_link_attributes( $social_link_key, $social_link );
                        $widget->add_render_attribute( $social_link_key, 'class', 'team-social d-flex text-white text-hover-white cms-hover-zoomout' );
                        ?>
                            <a <?php etc_print_html($widget->get_render_attribute_string( $social_link_key )); ?>><?php 
                                finanzia_elementor_icon_render( $social_icon, [], [ 
                                    'aria-hidden' => 'true', 
                                    'class'       => 'cms-eicon', 
                                    'icon_size'   => 20 
                                ]); 
                            ?></a>
                        <?php
                    }
                }
            }
        $socials_html = ob_get_clean();
        if(!empty($socials_html)){
            $_socials_html = ob_start();
            ?>
                <div class="absolute bottom-center w-100 p-lr-40 p-lr-smobile-20"><div class="team-socials bg-accent d-flex gap-20 justify-content-center p-tb-20 mb-30 cms-hover-show move-up cms-transition cms-radius-12"><?php etc_print_html($socials_html); ?></div></div>
            <?php
            $_socials_html = ob_get_clean();
        } else {
            $_socials_html = '';
        }
        //
        ?>
        <div <?php etc_print_html($widget->get_render_attribute_string( $item_key )); ?>>
            <div class="cms-team--item cms-hover-change hover-image-zoom-out text-center">
                <div class="relative overflow-hidden"><?php 
                    $team['image_size'] = $widget->get_setting('image_size');
                    $team['image_custom_dimension'] = $thumbnail_custom_dimension;
                    finanzia_elementor_image_render($team,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'swiper-nav-vert img-cover',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'max_height'     => false,
                        'before'         => '<a '.$widget->get_render_attribute_string( $link_key ).'>',
                        'after'          => '</a>'.$_socials_html  
                    ]);
                ?></div>
                <div class="team-content pt-30">
                    <h4 class="team-heading cms-heading text-21 mt-n7">
                        <a <?php etc_print_html($widget->get_render_attribute_string( $link_key2 )); ?>>
                            <?php echo esc_html($team['name']); ?>
                        </a>
                    </h4>
                    <div class="team-position empty-none text-21 pt-8 mb-n7"><?php 
                        etc_print_html($team['position']); 
                    ?></div>
                    <div class="team-desc empty-none pt-25 text-15 empty-none"><?php 
                        etc_print_html($team['description']); 
                    ?></div>
                </div>
            </div>
        </div>
        <?php
    }
    ?>
<?php switch ($settings['layout_mode']) {
    case 'grid':
    // close .cms-grid
?>
    </div>
<?php
        break;
    default:
    // close .cms-carouse .swiper-wrapper
?>
        </div>
    </div>
    <div class="cms-swiper-buttons-dots d-flex gap-20 align-items-center justify-content-between empty-none pt" style="--pt:23px;"><?php
        // Dots
        if ($dots == 'yes') { ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
        <?php } 
        // Arrows
        if ($arrows == 'yes'){ ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-prev.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_prev,
                        'icon_size' => 10
                    ], 
                    'div'
                );
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-next.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_next,
                        'icon_size' => 10
                    ], 
                    'div'
                );
            ?></div>
        <?php } 
    ?></div>
<?php
        break;
} ?>