<?php 
$cms_tabs = $widget->get_setting('cms_tabs', []);
$tabs = $widget->get_setting('tabs', []);
$active_tab = $settings['active_tab'];
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-tabs',
		'cms-tabs-'.$settings['layout']
	]
]);
// Content Title
$content_title_color = $widget->get_setting('content_title_color', 'heading');
$widget->add_render_attribute('content-title',[
	'class' => [
		'cms-heading',
		'text-'.$content_title_color,
		'empty-none',
		'm-tb-n7'
	]
]);
// Content Text
$widget->add_render_attribute('content-desc',[
	'class' => [
		'cms-desc empty-none',
		'text-'.$widget->get_setting('content_text_color', 'body'),
		'text-15',
		'pt-30 m-tb-n7'
	]
]);
// Buttons
$btn_classes = [
	'btn btn-smd',
	'btn-outline-'.$widget->get_setting('link_bg_color','primary'),
	'text-'.$widget->get_setting('link_text_color', 'primary'),
	'btn-hover-'.$widget->get_setting('link_bg_color_hover', 'accent'),
	'text-hover-'.$widget->get_setting('link_text_color_hover', 'white'),
	'mt-30',
	'cms-hover-move-icon-right'
];
// Tab Title icon
$title_icon_classes = finanzia_nice_class([ 
	'tab-title-icon pb-70 pb-tablet-40',
	'text-'.$widget->get_setting('tab_title_color', 'heading'),
	'text-hover-'.$widget->get_setting('tab_title_color_hover', 'primary'),
	'text-active-'.$widget->get_setting('tab_title_color_hover', 'primary')
]);
// Tab Title text
$widget->add_render_attribute('tab-title-text',[
	'class' => [
		'tab-title-text',
		'text-15',
		'm-tb-n7'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-tabs-title d-flex flex-col-3 flex-col-mobile-1 relative z-top cms-hidden-max-mobile">
		<?php 
		$count = 0;
		foreach ($cms_tabs as $key => $cms_tab) {
			$count ++;
			$is_active = ( $key + 1 ) === $active_tab ? true : false;
			$title = !empty($cms_tab['tab_title']) ? $cms_tab['tab_title'] : 'Tab #'.($key+1);
			// title
			$title_key = $widget->get_repeater_setting_key( 'tab_title', 'cms_tabs', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => array_filter([ 
					'cms-tab-title',
					'text-'.$widget->get_setting('tab_title_color', 'heading'),
					'text-hover-'.$widget->get_setting('tab_title_color_hover', 'primary'),
					'text-active-'.$widget->get_setting('tab_title_color_hover', 'primary'),
					'bg-'.$widget->get_setting('tab_title_bg_color', 'white'),
					'bg-hover-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					'bg-active-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					$is_active ? 'active' : '',
					'text-15',
					'relative',
					'cms-hover-change',
					($key == 0) ? 'pr-70 pr-tablet-20' : 'p-lr-70 p-lr-tablet-20',
					'p-lr-mobile-20'
				]),
				'data-target' => '#cms-'.$cms_tab['_id'],
				'data-active' => $is_active?'active':''
			]);
		?>
			<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>>
				<div class="bg-white relative z-top p-tb-50 p-tb-smobile-20">
					<?php
					// Icon
					finanzia_elementor_icon_render( $cms_tab['tab_title_icon'], [], ['aria-hidden' => 'true', 'class' => $title_icon_classes, 'icon_size' => 64], 'div');
					?>
					<div <?php etc_print_html($widget->get_render_attribute_string('cms-tab-title')); ?>><?php 
						// text
						echo nl2br($title);
					?></div>	
				</div>	
			</div>
			
		<?php } ?>
	</div>
	<div class="cms-tabs-contents relative"><?php 
		// Tabs Content
		foreach ($cms_tabs as $key => $cms_tab) {
			$is_active = ( $key + 1 ) === $active_tab ? true : false;
			$content_key = $widget->get_repeater_setting_key( 'tab_content', 'cms_tabs', $key );
			$widget->add_render_attribute( $content_key, [
				'id'	=> 'cms-'.$cms_tab['_id'],
				'class' => array_filter([
					'cms-tabs-content',
					$is_active ? 'active relative' : 'absolute cms-invisible',
					'top-left'
				])
			] );
			if ( $is_active ) {
				//$widget->add_render_attribute( $content_key, 'class', 'relative' );
			} else {
				//$widget->add_render_attribute( $content_key, 'class', 'absolute cms-invisile' );
			}
		?>
		<?php // Tab title for Mobile 
			// title
			$mobile_title_key = $widget->get_repeater_setting_key( 'mobile_tab_title', 'cms_tabs', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => array_filter([ 
					'cms-mobile-tab-title',
					'text-'.$widget->get_setting('tab_title_color', 'heading'),
					'text-hover-'.$widget->get_setting('tab_title_color_hover', 'primary'),
					'text-active-'.$widget->get_setting('tab_title_color_hover', 'primary'),
					'bg-'.$widget->get_setting('tab_title_bg_color', 'white'),
					'bg-hover-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					'bg-active-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					$is_active ? 'active' : '',
					'text-15',
					'relative',
					'p-lr-20'
				])
			]);
		?>
		<div class="cms-hidden-min-mobile-extra">
			<div <?php etc_print_html( $widget->get_render_attribute_string( $mobile_title_key ) ); ?>>
				<div class="bg-white relative z-top p-tb-50 p-tb-smobile-20">
					<?php
					// Icon
					finanzia_elementor_icon_render( $cms_tab['tab_title_icon'], [], ['aria-hidden' => 'true', 'class' => $title_icon_classes, 'icon_size' => 64], 'div');
					?>
					<div <?php etc_print_html($widget->get_render_attribute_string('cms-tab-title')); ?>><?php 
						// text
						echo nl2br($cms_tab['tab_title']);
					?></div>	
				</div>
			</div>
		</div>
		<?php // Tab Content ?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( $content_key ) ); ?>>
			<?php 
				// Banner 
				finanzia_elementor_image_render($cms_tab, [
					'name'           => 'tab_content_banner',
					'image_size_key' => 'tab_content_banner',
					'size'           => 'custom',
					'custom_size'    => ['width' => 1500, 'height' => 800],
					'img_class'		 => 'img-cover',
					'max_height'	 => true,
					'min_height'	 => true,		
					'before'  		 => '',
					'after'		     => ''
				]);
			?>
			<div class="cms-tabs--content cms-hover-show move-up relative z-top bg-white-70 cms-transition absolute top-left ml-20 mt-20 max-w p-40 p-lr-smobile-20" style="--transition-delay:0;--max-w:510px;">
				<?php 
					// Icon
					finanzia_elementor_icon_render( $cms_tab['tab_content_icon'], [], ['aria-hidden' => 'true', 'class' => 'tab-icon mb-30 text-'.$content_title_color, 'icon_size' => 128], 'div');
				?>
				<h4 <?php etc_print_html($widget->get_render_attribute_string('content-title')); ?>><?php echo nl2br($cms_tab['tab_content_title']); ?></h4>
				<div <?php etc_print_html($widget->get_render_attribute_string('content-desc')); ?>><?php echo nl2br($cms_tab['tab_content_desc']); ?></div>
				<div class="cms-tab-feature pt-30">
					<?php 
						// Feature
						$tab_content_features = json_decode($cms_tab['tab_content_feature'], true);
						$count = 0;
						foreach ($tab_content_features as $key => $tab_content_feature) {
							$count ++;
					?>
						<div class="cms-tab--feature d-flex flex-nowrap gap-30 gap-smobile-10 align-items-center text-15 <?php if($count>1) echo 'pt-25'; ?>"><?php
							//icon
							finanzia_svgs_icon([
								'icon' => 'core/check',
								'class' => 'text-green text-12 flex-auto'
							]);
							//text
							echo nl2br($tab_content_feature['title']);
						?></div>
					<?php } ?>
				</div>
				<?php 
					// Link
				    finanzia_elementor_link_render($widget, $cms_tab, [
						'name' 		=> 'link1_',
						'color'		=> false,
						'text_icon'	=> finanzia_svgs_icon([
							'icon'       => 'core/long-arrow-right',
							'icon_class' => '',
							'echo'       => false,
							'class'      => 'text-17'
						]),
						'loop'     => true,
						'loop_key' => $key,
						'class'    => $btn_classes
					]);
				?>
			</div>
		</div>
		<?php } 
	?></div>
</div>