<?php
$html_id     = etc_get_element_id($settings);
$tax         = array();
$source      = $widget->get_setting('source', '');
$orderby     = $widget->get_setting('orderby', 'date');
$order       = $widget->get_setting('order', 'desc');
$limit       = $widget->get_setting('limit', 6);
$layout_type = 'grid';
extract(etc_get_posts_of_grid('cms-service', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['service-category']));

$thumbnail_size             = $widget->get_setting('thumbnail_size','custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height'] : 380
];
$pagination_type            = $widget->get_setting('pagination_type', 'pagination');
$readmore_text              = $widget->get_setting('readmore_text', esc_html__('Explore More','finanzia'));

$posts_data = array(
    'post_type'                  => 'cms-service',
    'taxonomy'                   => 'service-category',
    //
    'startPage'                  => $paged,
    'maxPages'                   => $max,
    'total'                      => $total,
    'perpage'                    => $limit,
    'nextLink'                   => $next_link,
    'pagination_type'            => $pagination_type,
    //
    'layout'                     => $settings['layout'],
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_line'                   => $widget->get_setting('num_line', ['size' => 4])['size'],
    'readmore_text'              => $readmore_text,
    //
    'item_class'                 => ''
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-post-grid', 'cms-grid', 'cms-grid-'.$settings['layout']],
    'data-layout'     => $layout_type,
    'data-start-page' => $paged,
    'data-max-pages'  => $max,
    'data-total'      => $total,
    'data-perpage'    => $limit,
    'data-next-link'  => $next_link
]);
// Content attributes
$widget->add_render_attribute('content',[
    'class' => [
        'cms-grid-content',
        'd-flex gutter',
        finanzia_elementor_get_grid_columns($widget, $settings, [
            'default' => '3',
            'tablet'  => '2' 
        ])
    ],
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <?php finanzia_elementor_filter_render($widget, $settings, [
        'categories' => $categories
    ]); ?>

    <div <?php etc_print_html($widget->get_render_attribute_string('content')); ?>><?php
        finanzia_get_post_grid($settings, $posts, $posts_data);
    ?></div>
    <?php if ($pagination_type == 'pagination') { ?>
        <div class="cms-grid-pagination" data-loadmore="<?php echo esc_attr(json_encode($posts_data)); ?>"
             data-query="<?php echo esc_attr(json_encode($args)); ?>"><?php 
                finanzia_posts_pagination($query, true); 
        ?></div>
    <?php }
    if (!empty($next_link) && $pagination_type == 'loadmore') { ?>
        <div class="cms-load-more text-center" data-loadmore="<?php echo esc_attr(json_encode($posts_data)); ?>" data-query="<?php echo esc_attr(json_encode($args)); ?>">
            <span class="btn btn-outline">
                <i class="i-hidden"></i>
                <?php echo esc_html__('Load More', 'finanzia') ?>
            </span>
        </div>
    <?php } 
    if($pagination_type == 'false'){
    ?>
        <div class="cms-grid-pagination d-none" data-loadmore="<?php echo esc_attr(json_encode($posts_data)); ?>"
             data-query="<?php echo esc_attr(json_encode($args)); ?>"><?php 
                finanzia_posts_pagination($query, true); 
        ?></div>
    <?php
    }
    ?>
</div>