<?php
$default_align = $widget->get_setting('align', 'start');
	// Wrap 
	$widget->add_render_attribute('wrap',[
		'class' => [
			'cms-eqc',
			'cms-eqc-'.$settings['layout'],
			'd-flex gapX-30 gapY-10',
			finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align', 'prefix_class' => 'justify-content-', 'default' => $default_align]),
			'flex-mobile-column'
		]
	]);
	// Email
		$icon_email_color = $widget->get_setting('icon_email_color', 'accent');
		$email_color = $widget->get_setting('email_color', 'primary');
		$email_color_hover = $widget->get_setting('email_color_hover', 'accent');
		$widget->add_render_attribute( 'email-item', [
			'class' => [
				'cms-eqc-item',
				'd-flex align-items-center gap-10',
				finanzia_elementor_get_alignment_class($widget, $settings, [
					'name'         => 'align',
					'prefix_class' => 'justify-content-',
					'default'      => $default_align
				]),
				'cms-email',
				'text-'.$email_color,
				'text-hover-'.$email_color_hover,
				'cms-hover-underline'
			],
			'href'   => 'mailto:'.$settings['email'],
			'target' => '_blank'
		]);
		// email icon
		$widget->add_render_attribute( 'email-icon', [
			'class' => [
				'text-'.$icon_email_color,
				'text-16'
			]
		]);
		// email title
		$widget->add_inline_editing_attributes( 'email_title' );
		$widget->add_render_attribute( 'email_title', [
			'class' => [
				'cms-email-title',
				'empty-none',
				finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
		// email
		$widget->add_inline_editing_attributes( 'email' );
		$widget->add_render_attribute( 'email', [
			'class' => [
				'cms-email-text',
				finanzia_add_hidden_device_controls_render($settings, 'text_')
			]
		]);
	// Phone
	$icon_phone_color = $widget->get_setting('icon_phone_color', 'accent');
	$phone_color = $widget->get_setting('phone_color', 'primary');
	$phone_color_hover = $widget->get_setting('phone_color_hover', 'accent');
	$phone_link  = str_replace(' ', '', $settings['phone']);
	$widget->add_render_attribute( 'phone-item',[ 
		'class' => [
			'cms-eqc-item',
			'd-flex align-items-center gap-10',
			finanzia_elementor_get_alignment_class($widget, $settings, [
				'name'         => 'align',
				'prefix_class' => 'justify-content-',
				'default'      => $default_align
			]),
			'cms-phone',
			'text-'.$phone_color,
			'text-hover-'.$phone_color_hover,
			'cms-hover-underline'
		],
		'href' => 'tel:'.$phone_link
	]);
		// phone icon
		$widget->add_render_attribute( 'phone-icon', [
			'class' => [
				'text-'.$icon_phone_color			]
		]);
		// phone title
		$widget->add_inline_editing_attributes('phone_title');
		$widget->add_render_attribute( 'phone_title',[ 
			'class' => [
				'cms-phone-title',
				'empty-none',
				finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
		// phone number
		$widget->add_inline_editing_attributes('phone');
		$widget->add_render_attribute( 'phone',[ 
			'class' => [
				'cms-phone-text',
				finanzia_add_hidden_device_controls_render($settings, 'text_')
			]
		]);
	// Adress
		$icon_address_color = $widget->get_setting('icon_address_color', 'accent');
		$address_color = $widget->get_setting('address_color', 'primary');
		$address_color_hover = $widget->get_setting('address_color_hover', 'accent');

		$address     = $settings['address'];
		$map_zoom    = 14;
		$map_api_key = finanzia_get_opt('gm_api_key');
		$map_params  = [
		    rawurlencode( $address ),
		    absint( $map_zoom )
		];
		$map_url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;iwloc=near';
		
		$widget->add_render_attribute( 'address-item', [
			'class' => [
				'cms-eqc-item',
				'd-flex align-items-center',
				finanzia_elementor_get_alignment_class($widget, $settings, [
					'name'         => 'align',
					'prefix_class' => 'justify-content-',
					'default'      => $default_align
				]),
				'cms-address',
				'text-'.$address_color,
				'text-hover-'.$address_color_hover,
				'cms-hover-underline'
			],
			'href'   => vsprintf( $map_url, $map_params ),
			'target' => '_blank'
		]);
		if(!empty($settings['address_title'])) {
			$widget->add_render_attribute( 'address-item', [
				'class' => [
					'gap-10'
				]
			]);
		}
		// address icon
		$widget->add_render_attribute( 'address-icon', [
			'class' => [
				'text-'.$icon_address_color,
				'text-16'
			]
		]);
		// address title
		$widget->add_inline_editing_attributes( 'address_title' );
		$widget->add_render_attribute( 'address_title', [
			'class' => [
				'cms-address-title',
				'empty-none',
				finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
		// address
		$widget->add_inline_editing_attributes( 'address' );
		$widget->add_render_attribute( 'address', [
			'class' => [
				'cms-address-text',
				finanzia_add_hidden_device_controls_render($settings, 'text_')
			]
		]);
	// Socials
	$icons = $widget->get_setting('icons', []);
	$hover_animation = $widget->get_setting('hover_animation', '');
	$class_animation = '';
	if(!empty($hover_animation)){
		$class_animation = 'elementor-animation-' . $hover_animation;
	}
	//Icons wrap
	$widget->add_render_attribute('icon-wrap', [
		'class' => [
			'cms-social-icons',
			'cms-social-icons-'.$settings['layout'],
			'd-flex align-items-center',
			'gap-'.$widget->get_setting('gap',15),
			'text-13', 
			finanzia_elementor_get_alignment_class($widget, $settings, [
				'name' 		   => 'align',
				'prefix_class' => 'justify-content-'
			]),
			'pt-mobile-30'
		]
	]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	// Email
	if(!empty($settings['email'])){
	?>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'email-item' ) ); ?>>
		<span <?php etc_print_html($widget->get_render_attribute_string('email_title')); ?>><?php echo esc_html($settings['email_title']); ?></span>
		<span <?php etc_print_html($widget->get_render_attribute_string('email')); ?>><?php echo esc_html($settings['email']); ?></span>
	</a>
	<?php }
	// Phone
	if(!empty($settings['phone'])) { ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'phone-item' ) ); ?>>
			<span <?php etc_print_html($widget->get_render_attribute_string('phone_title')); ?>><?php echo esc_html($settings['phone_title']); ?></span>
			<span <?php etc_print_html($widget->get_render_attribute_string('phone')); ?>><?php echo esc_html($settings['phone']); ?></span>
		</a>
	<?php }
	// Address
	if(!empty($address)) { ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'address-item' ) ); ?>>
			<span <?php etc_print_html($widget->get_render_attribute_string('address_title')); ?>><?php echo esc_html($settings['address_title']); ?></span>
			<span <?php etc_print_html($widget->get_render_attribute_string('address')); ?>><?php echo esc_html($settings['address']); ?></span>	
		</a>
	<?php }
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('icon-wrap')); ?>>
		<?php
			foreach ( $icons as $key => $value ) {
				$_id = isset( $value['_id'] ) ? $value['_id'] : '';
				$link_key = $widget->get_repeater_setting_key( 'link', 'icons', $key );
				$widget->add_render_attribute( $link_key, 'class', [
						'cms-social-item d-flex align-items-center gap-10',
						//'cms-animate-icon',
						$class_animation,
						'elementor-repeater-item-' . $_id,
						'text-'.$widget->get_setting('icon_color','white'),
						'text-hover-'.$widget->get_setting('icon_hover_color', 'white'),
						'bg-'.$widget->get_setting('bg_color', 'accent'),
						'bg-hover-'.$widget->get_setting('bg_hover_color', 'primary'),
						'box-40 circle'
					] );

				$widget->add_link_attributes( $link_key, $value['link'] );

				$title_key = $widget->get_repeater_setting_key( 'title', 'icons', $key );
				$widget->add_render_attribute($title_key, [
					'class' => [
						'cms-stitle',
						'text-'.$widget->get_setting('social_title_color','primary'),
						finanzia_add_hidden_device_controls_render($settings, 'title_')
					]
				]);
				$widget->add_inline_editing_attributes($title_key);
		?>
		<a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>>
			<?php finanzia_elementor_icon_render( $value['social_icon'], [], [ 'aria-hidden' => 'true', 'class' => 'cms-icon', 'icon_size' => 20 ] ); ?>
			<?php if ( 'yes' === $settings['show_title'] ) { ?><span <?php etc_print_html($widget->get_render_attribute_string( $title_key )); ?>><?php echo esc_html($value['title']); ?></span><?php } ?>
		</a>
		<?php } ?>
	</div>
</div>