<?php
$process = $widget->get_setting('process', []);
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons',
        'd-flex gap-10',
        'justify-content-center',
        'flex-auto flex-smobile-full',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
        'max-w',
        'order-smobile-last'
    ],
    'style' => '--max-w:58px;--max-w-smobile:100%;'
]);
$arrows_classes = [
    'cms-carousel-button text-19',
    'box-58 circle',
    'text-'.$widget->get_setting('arrow_color','accent'),
    'bg-'.$widget->get_setting('arrow_bg_color','grey'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'justify-content-center gap-10',
        finanzia_add_hidden_device_controls_render($settings, 'dots_'),
        'w-100'
    ],
    'style' => [
        '--cms-dots-color:var(--cms-grey);',
        '--cms-dots-hover-color:var(--cms-accent);'
    ]
]);

// Wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-ettmn',
        'cms-ettmn-'.$widget->get_setting('layout_mode','carousel'),
        'cms-ettmn-'.$settings['layout'],
        'd-flex gap-20',
        'align-items-end'
    ]
]);
// Title
$widget->add_render_attribute('title',[
    'class' => [
        'cms-title cms-heading text-19 empty-none',
        'text-'.$widget->get_setting('title_color', 'heading'),
        'm-tb-n5'
    ]
]);
// Description 
$widget->add_render_attribute('description',[
    'class' => [
       'cms-desc',
       'text-'.$widget->get_setting('desc_color','body'),
       'text-15',
       'm-tb-n5 pt-20'
    ]
]);
// Items
$widget->add_render_attribute('item',[
    'class' => [
        'cms-item',
        'swiper-slide'
    ]
]);
$widget->add_render_attribute('item-inner',[
    'class' => [
        'cms--item',
        'd-flex gap-40 align-items-center',
        'bg-'.$widget->get_setting('bg_color', 'white'),
        'p-20'
    ]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <?php // Arrows
        if ($arrows == 'yes'){ ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
            finanzia_elementor_icon_render(
                [], 
                [
                    'library' => 'svg',
                    'value'   => [
                        'id'  => '',
                        'url' => get_template_directory().'/assets/svgs/core/arrow-left.svg'
                    ]
                ], 
                [
                    'class'     => $arrows_classes_prev,
                    'icon_size' => 19
                ], 
                'div'
            );
            finanzia_elementor_icon_render(
                [], 
                [
                    'library' => 'svg',
                    'value'   => [
                        'id'  => '',
                        'url' => get_template_directory().'/assets/svgs/core/arrow-right.svg'
                    ]
                ], 
                [
                    'class'     => $arrows_classes_next,
                    'icon_size' => 19
                ], 
                'div'
            );
        ?></div>
    <?php } ?>
    <div class="cms-carousel swiper flex-basic flex-smobile-full">
        <div class="swiper-wrapper">
            <?php foreach ($process as $key => $_process) { ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('item')); ?>>
                    <div <?php etc_print_html($widget->get_render_attribute_string('item-inner')); ?>>
                        <div class="flex-basic flex-smobile pl-20 pl-smobile-0">
                            <div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php 
                                etc_print_html($_process['title']); 
                            ?></div>
                            <div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php 
                                etc_print_html($_process['description']); 
                            ?></div>
                            <div class="count text-13 pt-33 d-flex gap-10 align-items-end lh-1">
                                <div class="flex-auto"><?php echo finanzia_leading_zero($key+1,'<span class="text-accent">','</span>').' '.finanzia_leading_zero(count($process),'<span class="text-body"> /', '</span>'); ?></div>
                                <div class="flex-basic bdr-b-1 bdr-divider-dark max-w" style="--max-w:60%;"></div>
                            </div>
                        </div>
                        <?php
                            finanzia_elementor_image_render($_process,[
                                'name'           => 'banner',
                                'image_size_key' => 'banner',
                                'img_class'      => '',
                                'size'           => 'custom',
                                'custom_size'    => ['width' => 290, 'height' => 167],
                                'attrs'          => [],
                                'before'         => '<div class="flex-auto flex-smobile-full order-smobile-first">',
                                'after'          => '</div>'
                            ]);
                        ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <?php // Dots
    if ($dots == 'yes') { ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
    <?php } ?>
</div>
