<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-process',
		'cms-eprocess-'.$settings['layout'],
		'cms-tabs'
	]),
	'data-break' => '1025'
]);
// Small Heading
$widget->add_render_attribute( 'small_title', [
	'class' => [
		'cms-small-title',
		'text-'.$widget->get_setting('small_title_color','heading'),
		'text-15',
		'p-tb',
		'empty-none'
	],
	'style' => '--p-tb:33px;'
]);
// Large Heading
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('ptitle_color','heading'),
		'text-size font-700',
		'm-tb-n7'
	],
	'style' => '--text-size:26px;--text-size-smobile:20px;'
]);
// Description
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('pdesc_color','heading'),
		'font-700',
		'm-tb-n7 pt-30'
	])
]);
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 empty-none',
		'text-'.$widget->get_setting('pdesc2_color','body'),
		'm-tb-n7 pt-30'
	])
]);
// Process Lists
$process = $widget->get_setting('process_list3', []);
$count_tab = count($process);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-tabs-title d-flex flex-col-<?php echo esc_attr($count_tab); ?> relative z-top cms-hidden-tablet pb-90">
		<?php 
		foreach ($process as $key => $_process) {
			$is_active = ( $key + 1 ) === 1 ? true : false;
			// title
			$tab_title_key = $widget->get_repeater_setting_key( 'tab_title_key', 'cms_tabs', $key );
			$widget->add_render_attribute( $tab_title_key, [
				'class' => array_filter([ 
					'cms-tab-title',
					$is_active ? 'active' : '',
					'text-size font-700',
					'text-center',
					'p-tb',
					'cms-hover-underline',
					'text-accent'
				]),
				'data-target' => '#cms-'.$_process['_id'],
				'data-active' => $is_active?'active':'',
				'style' 	  => '--text-size:21px;--p-tb:20px;'	
			]);
		?>
			<div <?php etc_print_html( $widget->get_render_attribute_string( $tab_title_key ) ); ?>>
				<?php echo nl2br($_process['small_title']); ?>
			</div>
			
		<?php } ?>
	</div>
	<div class="cms-tabs-contents relative">
		<?php 
		foreach($process as $key => $_process){
			$is_active = ( $key + 1 ) === 1 ? true : false;
			// Process
			$process_key = $widget->get_repeater_setting_key('process', 'cms_process', $key);
			$widget->add_render_attribute($process_key, [
				'id'	=> 'cms-'.$_process['_id'],
				'class' => array_filter([
					'cms-process',
					'cms-tabs-content',
					($key === 0) ? 'active relative' : 'absolute cms-invisible',
					'bg-'.$widget->get_setting('bg_color','white'),
					($key > 0) ? 'pt-tablet-40' : ''
				]),
				'data-active' => $is_active?'active':'invisible'
			]);
			// Items
			$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
			$widget->add_render_attribute($item_key, [
				'class' => [
					'cms--process',
					'd-flex gutter justify-content-between'
				],
				'data-target' => 'cms-'.$_process['_id']
			]);
			// Mobile title
			$mobile_title_key = $widget->get_repeater_setting_key( 'mobile_title_key', 'cms_tabs', $key );
			$widget->add_render_attribute( $mobile_title_key, [
				'class' => array_filter([ 
					'cms-tab-title',
					'text-accent',
					$is_active ? 'active' : '',
					'text-size font-700',
					'text-center',
					'p-tb mb',
					'cms-hover-underline',
					'cms-hidden-min-tablet-extra'
				]),
				'data-target' => '#cms-'.$_process['_id'],
				'data-active' => $is_active?'active':'',
				'style' 	  => '--text-size:21px;--p-tb:20px;--mb:40px;'	
			]);
		?>
			<div <?php etc_print_html($widget->get_render_attribute_string($process_key)); ?>>
				<div <?php etc_print_html( $widget->get_render_attribute_string( $mobile_title_key ) ); ?>>
					<?php echo nl2br($_process['small_title']); ?>
				</div>
				<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
					<div class="col-6 col-mobile-extra-12 max-w" style="--max-w:620px;--max-w-tablet-extra:100%;">
						<div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($_process['title']); ?></div>
						<div <?php etc_print_html($widget->get_render_attribute_string('desc')); ?>><?php echo nl2br($_process['desc']); ?></div>
						<div <?php etc_print_html($widget->get_render_attribute_string('desc2')); ?>><?php echo nl2br($_process['desc2']); ?></div>
						<?php // Link
						    finanzia_elementor_link_render($widget, $_process, [
								'name' 		=> 'link1_',
								'mode'	    => 'btn',
								'color'		=> true,
								'text_icon'	=> finanzia_svgs_icon([
									'icon'       => 'core/long-arrow-right',
									'icon_class' => '',
									'echo'       => false,
									'class'      => 'text-17'
								]),
								'loop'             => true,
								'loop_key'         => $key,
								'class'            => 'cms-hover-move-icon-right mt-40',
								'btn_color'        => $widget->get_setting('btn_color','accent'),
								'text_color'       => $widget->get_setting('btn_text_color','white'),
								'btn_color_hover'  => $widget->get_setting('btn_hover_color','accent-darken'),
								'text_color_hover' => $widget->get_setting('btn_text_hover_color','white'),
							]); 
							// Feature
							$features = json_decode($_process['feature'], true);
							$feature_count = 0;
							foreach ($features as $feature_key => $feature) {
								$feature_count++;
								// Feature
								$feature_item = $widget->get_repeater_setting_key('cms-tab--feature', 'cms_tabs', $key);
								$widget->add_render_attribute( $mobile_title_key, [
									'class' => [
										'cms-tab--feature d-flex flex-nowrap gap-15',
										($feature_count>1) ? 'pt-20 mt-20 bdr-t-1 bdr-'.$widget->get_setting('feature_border_color','divider') : 'pt-90',
										'text-'.$widget->get_setting('feature_color', 'body')
									]
								]);
							?>
								<div <?php etc_print_html($widget->get_render_attribute_string($feature_item)); ?>><?php
									//icon
									finanzia_svgs_icon([
										'icon'  => 'check',
										'class' => 'text-9 flex-auto box-25 circle bg-grey text-primary'
									]);
									//text
									echo nl2br($feature['title']);
								?></div>
							<?php }
						?>
					</div>
					<div class="col-6 col-mobile-extra-12 order-mobile-extra-first max-w" style="--max-w:630px;--max-w-tablet-extra:100%;"><?php
						finanzia_elementor_image_render($_process,[
							'name'                => 'banner',
							'image_size_key'      => 'banner',
							'img_class'           => '',
							'size'                => 'full',
							'custom_size'         => ['width' => 590, 'height' => 550],
							'before'              => '<div id="cms-'.$_process['_id'].'" class="cms-sticky">',
							'after'               => '</div>'
				        ]);
			        ?></div>
				</div>
			</div>
		<?php } ?>
	</div>
</div>