<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eprocess',
		'cms-eprocess-'.$settings['layout'],
		'bg-'.$widget->get_setting('bg_color', 'accent-darken')
	])
]);
// Small Heading
$widget->add_render_attribute( 'small_title', [
	'class' => [
		'cms-small-title',
		'text-'.$widget->get_setting('small_title_color','primary-lighten'),
		'text-15',
		'p-tb',
		'bdr-t-1 bdr-'.$widget->get_setting('small_title_border_color', 'divider-dark'),
		'empty-none'
	],
	'style' => '--p-tb:33px;'
]);
// Large Heading
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('ptitle_color','white'),
		'text-size font-700',
		'm-tb-n7'
	],
	'style' => '--text-size:26px;--text-size-smobile:20px;'
]);
// Description
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('pdesc_color','white'),
		'font-700',
		'm-tb-n7 pt-30'
	])
]);
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 empty-none',
		'text-'.$widget->get_setting('pdesc2_color','primary-lighten'),
		'font-700',
		'm-tb-n7 pt-30'
	])
]);
// Process Lists
$process = $widget->get_setting('process_list3', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	$count = 0;
	$zindex = '';
	foreach($process as $key => $_process){ 
		$count ++;
		// Process
		$process_key = $widget->get_repeater_setting_key('process', 'cms_process', $key);
		$widget->add_render_attribute($process_key, [
			'class' => array_filter([
				'cms-process cms-sticky cms-sticky-tablet-none',
				'bg-'.$widget->get_setting('bg_color', 'accent-darken')
			]),
			'style' => '--cms-sticky:'.($key*90).'px;--cms-sticky-tablet:0;'
		]);
		// Items
		$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
		$widget->add_render_attribute($item_key, [
			'class' => [
				'cms--process',
				'd-flex gutter justify-content-between'
			],
			'data-target' => 'cms-'.$_process['_id']
		]);
	?>
		<div <?php etc_print_html($widget->get_render_attribute_string($process_key)); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>>
				<div class="container"><?php echo finanzia_leading_zero($count).'. '.nl2br($_process['small_title']); ?></div>
			</div>
			<div class="container pt pb" style="--pt:70px;--pb:110px;--pt-tablet-extra:7px;--pb-tablet-extra:40px;">
				<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
					<div class="col-6 col-mobile-extra-12 max-w" style="--max-w:620px;--max-w-tablet-extra:100%;">
						<div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($_process['title']); ?></div>
						<div <?php etc_print_html($widget->get_render_attribute_string('desc')); ?>><?php echo nl2br($_process['desc']); ?></div>
						<div <?php etc_print_html($widget->get_render_attribute_string('desc2')); ?>><?php echo nl2br($_process['desc2']); ?></div>
						<?php // Link
						    finanzia_elementor_link_render($widget, $_process, [
								'name' 		=> 'link1_',
								'mode'	    => 'btn',
								'color'		=> true,
								'text_icon'	=> finanzia_svgs_icon([
									'icon'       => 'core/long-arrow-right',
									'icon_class' => '',
									'echo'       => false,
									'class'      => 'text-17'
								]),
								'loop'             => true,
								'loop_key'         => $key,
								'class'            => 'cms-hover-move-icon-right mt-40',
								'btn_color'        => $widget->get_setting('btn_color','white'),
								'text_color'       => $widget->get_setting('btn_text_color','accent'),
								'btn_color_hover'  => $widget->get_setting('btn_hover_color','white'),
								'text_color_hover' => $widget->get_setting('btn_color','accent'),
							]); 
							// Feature
							$features = json_decode($_process['feature'], true);
							$feature_count = 0;
							foreach ($features as $feature_key => $feature) {
								$feature_count++;

								// Feature
								$feature_item = $widget->get_repeater_setting_key('cms-tab--feature', 'cms_tabs', $feature_key);
								$widget->add_render_attribute( $feature_item, [
									'class' => [
										'cms-tab--feature d-flex flex-nowrap gap-15',
										($feature_count>1) ? 'pt-25 mt-25 bdr-t-1 bdr-'.$widget->get_setting('feature_border_color','divider-30') : 'pt-90',
										'text-'.$widget->get_setting('feature_color', 'white')
									]
								]);
							?>
								<div <?php etc_print_html($widget->get_render_attribute_string($feature_item)); ?>><?php
									//icon
									finanzia_svgs_icon([
										'icon'  => 'check',
										'class' => 'text-green text-9 flex-auto box-25 circle bg-white text-primary'
									]);
									//text
									echo nl2br($feature['title']);
								?></div>
							<?php }
						?>
					</div>
					<div class="col-6 col-mobile-extra-12 order-mobile-extra-first max-w" style="--max-w:630px;--max-w-tablet-extra:100%;"><?php
						finanzia_elementor_image_render($_process,[
							'name'                => 'banner',
							'image_size_key'      => 'banner',
							'img_class'           => '',
							'size'                => 'full',
							'custom_size'         => ['width' => 590, 'height' => 550],
							'before'              => '<div id="cms-'.$_process['_id'].'" class="cms-sticky">',
							'after'               => '</div>'
				        ]);
			        ?></div>
				</div>
			</div>
		</div>
	<?php } ?>
	<div class="cms-fix-sticky cms-hidden-tablet" style="height:25vh;"></div>
</div>