<?php
$default_align = 'center';
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-eptitle',
		'cms-eptitle-'.$widget->get_setting('layout','1'),
		'relative z-top',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'text-',
            'default'	   => $default_align	
        ]),
        'pt pt-tablet pb'
	],
	'style' => '--pt:186px;--pb:33px;--pt-tablet:50px;'
]);
// Container
$widget->add_render_attribute('container',[
	'class' => [
		'cms-content container',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'text-',
            'default'	   => $default_align	
        ]),
		'd-flex',
        finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'justify-content-',
            'default'	   => $default_align	
        ])
	]
]);
// Small Title 
$widget->add_render_attribute('small_title', [
	'class' => [
		'cms-small-title',
		'mt-n7 pb-15 w-100',
		'text-15 text-uppercase',
		'text-'.$widget->get_setting('small_title_color', 'white'),
		'ls-06',
		'empty-none'
	]
]);
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-nl2br lh-108',
		'text-75 text-tablet-50 text-smobile-40',
		'text-'.$widget->get_setting('title_color','white'),
		'w-100',
		'empty-none'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc cms-nl2br',
		'pt-15 w-100',
		'text-17 font-700',
		'text-'.$widget->get_setting('description_color', 'white'),
		'empty-none'
	]
]);

// Inline Edit
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'link_text' );
// CMS Content
$widget->add_render_attribute('cms--content',[
	'class' => [
		'cms--content d-flex flex-column',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'justify-content-',
            'default'	   => $default_align	
        ])
	]
]);
// Buttons 
$widget->add_render_attribute('buttons',[
	'class' => [
		'd-flex gap empty-none w-100',
		'pt-35',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'justify-content-',
            'default'	   => $default_align	
        ])
	],
	'style' => '--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:20px;'
]);
// Breadcrumb
$breadcrumb_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
	'justify-content-'.$default_align,
	'text-14'
];
$breadcrumb_link_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
];
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = $settings['bg_image']['url'];
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = get_the_post_thumbnail_url('', 'full');
} else {
	$background_img = $settings['bg_image']['url'];
}
$widget->add_render_attribute('background', [
	'class'                         => [
		'cms-eptitle-overlay cms-overlay',
		'cms-bg-cover',
		'cms-lazy',
		'relative overflow-hidden'
	],
	'style' => '--cms-bg-lazyload:url('.$background_img.');background-image:var(--cms-bg-lazyload-loaded);'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('background')); ?>><?php 
	// Shadow Style
    switch ($settings['shadow_style']) {
        case '1':
            echo '<div class="cms-shadow-img absolute top-right z-top rtl-flip"><img src="'.get_template_directory_uri().'/assets/images/shadow.png" /></div>';
            break;
        
        case '2':
            echo '<div class="cms-shadow-multi2 absolute top-right"></div>';
            break;
    }
?></div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('cms--content')); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>><?php echo etc_print_html( $settings['small_title'] ); ?></div>
			<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $widget->get_setting('title', get_the_title()) ); ?></h1>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo nl2br( $settings['description'] ); ?></div>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'buttons' ) ); ?>><?php 
				// Button #1
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'		=> 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/arrow-right',
						'icon_class' => '',
						'class'      => 'text-12',
						'echo'		 => false
					]),
					'class' => [
						'btn-lg',
						'cms-hover-move-icon-right'
					],
					'btn_color' => 'accent',
					'btn_color_hover' => 'white',
					'text_color_hover' => 'primary'
				]);
				// Button #2
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link2_',
					'mode'		=> 'btn',
					'text_icon'	=> '',
					'class' => [
						'btn-lg'
					],
					'btn_prefix'       => 'btn-outline-',
					'btn_color'        => 'white',
					'text_color'       => 'white',
					'btn_color_hover'  => 'white',
					'text_color_hover' => 'primary'
				]);
				// Video
				finanzia_elementor_button_video_render($widget, $settings, [
					'name'   => 'video_link',
					'icon'   => $widget->get_setting('video_icon'),
					'icon'       => $widget->get_setting('video_icon'),
					'text'   => $widget->get_setting('video_text','How it works'),
					'layout' => '1',
					'class'  => '',
					'echo'	 => true
			    ])
			?></div>
			<?php finanzia_breadcrumb([
				'icon_home'  => '',
				'class'      => finanzia_nice_class($breadcrumb_classes),
				'link_class' => finanzia_nice_class($breadcrumb_link_classes),
				'before'     => '<div class="pt pt-tablet" style="--pt:129px;--pt-tablet:20px;">',
				'after'      => '</div>'
			]); ?>
		</div>
	</div>
</div>