<?php
$default_align = 'start';
// wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-newsletter',
        'cms-newsletter-'.$widget->get_setting('layout','1'),
        finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','default' => $default_align])
    ],
    'style' => [
        '--cms-form-field-height:58px;',
        '--cms-form-field-radius:0;',
        '--cms-form-field-border:none;',
        '--cms-form-field-border-hover:none;',
        '--cms-form-field-border-width:0 0 1px 0;',
        '--cms-form-field-border-style:solid;',
        '--cms-form-field-border-color:var(--cms-divider-55);',
        '--cms-form-field-bg-color:var(--cms-accent-darken);',
        '--cms-form-field-color:var(--cms-white);',
        '--cms-placeholder-color:var(--cms-white);',
        '--cms-form-field-padding-start:0;',
        '--cms-form-field-padding-end:58px;',
        '--cms-form-btn-bg:var(--cms-accent);',
        '--cms-form-btn-color:var(--cms-white);',
        '--cms-form-btn-bg-hover:var(--cms-accent);',
        '--cms-form-btn-color-hover:var(--cms-white);',
        '--cms-btn-padding:0 15px;'
    ]
]);
// title 
$widget->add_inline_editing_attributes('title');
$widget->add_render_attribute('title', [
    'class' => [
        'cms-title cms-heading text-17',
        'text-'.$settings['title_color'],
        'pb-40 m-tb-n7',
        'empty-none'
    ]
]);
// Desccription
$widget->add_inline_editing_attributes('description');
$widget->add_render_attribute('description', [
    'class' => [
        'cms-desc text-14 empty-none',
        'text-'.$settings['desc_color'],
        'pb-40 m-tb-n7'
    ]
]);
// Privacy Policy
$widget->add_render_attribute('privacy_policy_text_wrap', [
    'class' => [
        'cms-pp text-14 empty-none',
        'text-'.$settings['desc_color'],
        'pt-15'
    ]
]);
// Privacy Policy text
$widget->add_inline_editing_attributes('privacy_policy_text');
$widget->add_render_attribute('privacy_policy_text',[
    'class' => 'pp-text'
]);
// Privacy Policy link
$widget->add_render_attribute( 'privacy_policy_link_text', [
    'class' =>[
        'pp-link',
        'cms-hover-underline',
        'text-'.$settings['desc_color'],
        'text-hover-'.$settings['desc_color'],
    ],
    'href'  => get_permalink($widget->get_setting('privacy_policy_page'))
]);
// Form Fields
$show_name = $widget->get_setting('show_name','no');
// Button Text 
$btn_text = !empty($settings['button_text']) ? $settings['button_text'] : esc_html__('Subscribe','finanzia');
// Shortcode
$fields = '[newsletter_form button_label="'.$btn_text.'" class="cms-newsletter-sc-2 relative"]';
    if($show_name == 'yes'){
        $fields .= '[newsletter_field name="first_name" label="" placeholder="'.$widget->get_setting('name_text',esc_html__('Your Name','finanzia')).'"]';
    }
    $fields .= '[newsletter_field name="email" label="" placeholder="'.$widget->get_setting('email_text',esc_html__('Your Email Address','finanzia')).'"]';
$fields .= '[/newsletter_form]';
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <h2 <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php 
        echo nl2br($settings['title']); 
    ?></h2>
    <div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php 
        echo wpautop($settings['description']); 
    ?></div>
    <?php 
        switch ($settings['layout_form']) {
            case 'custom':
                newsletter_form($settings['form_id']); 
                break;
            
            default:
                echo do_shortcode($fields); 
                break;
        }
    //
    if(!empty($widget->get_setting('privacy_policy_page'))){
    ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('privacy_policy_text_wrap')); ?>>
            <span <?php etc_print_html($widget->get_render_attribute_string('privacy_policy_text')); ?>><?php 
                // text
                etc_print_html($settings['privacy_policy_text']).'&nbsp;';
            ?></span>
            <?php 
                // link
                etc_print_html(
                    '<a '.$widget->get_render_attribute_string('privacy_policy_link_text').'>'.$widget->get_setting('privacy_policy_link_text', esc_html__('Privacy Policy','finanzia')).'</a>'
                );
            ?>
        </div>
    <?php } ?>
</div>