<?php
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-emenu',
		'cms-emenu-'.$settings['layout'],
		'p-40 p-lr-tablet-30 p-lr-smobile-20',
		'bg-grey'
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-heading empty-none',
		'text-'.$widget->get_setting('title_color', 'heading'),
		'text-21',
		'pb-15 mt-n7 mb-30',
		'bdr-b-2'
	]
]);
// Menu
$menu = $widget->get_setting('menu','');
$link_class = implode(' ', array_filter([
	'text-'.$widget->get_setting('link_color','accent'),
	'text-hover-'.$widget->get_setting('link_color_hover','white'),
	'bg-white bg-hover-accent cms-radius-45',
	'cms-hover-move-icon-right',
	'cms-shadow-1 cms-hover-shadow-none'
]));
// icon
$menu_icon = finanzia_svgs_icon([
	'icon'      => 'core/long-arrow-right',
	'icon_size' => 17,
	'class'     => 'menu-icon',
	'echo'      => false
]);
if ( ! empty( $menu ) ) : ?>
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
		<h4 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php 
			echo etc_print_html( $settings['title'] ); 
		?></h4>
		<?php 
			wp_nav_menu( array(
				'fallback_cb'     => '',
				'walker'          => '',
				'container'		  => '',
				'container_class' => '',
				'menu'            => $menu,
				'menu_class'      => 'cms-menu',
				'link_class'	  => $link_class,
				'depth'           => 1,
				'link_after'	  => $menu_icon,
				'theme_location'  => ''
			)); 
		?>
	</div>
<?php  endif;  ?>