<?php
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-emenu',
		'cms-emenu-'.$settings['layout']
	],
	'style' => '--cms-divider-color:var(--cms-'.$widget->get_setting('divider_color','divider').');'
]);
// Menu
$menu = $widget->get_setting('menu','');
// Align
$align = finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align', 'prefix_class' => 'justify-content-']);
$menu_class = [
	'cms-menu cms-menu-horz',
	$align,
	'text-'.$widget->get_setting('link_color','link')
];

$link_class = implode(' ', array_filter([
	'text-'.$widget->get_setting('link_color','link'),
	'text-hover-'.$widget->get_setting('link_color_hover','link')
]));
if ( ! empty( $menu ) ) : ?>
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
		<?php 
			wp_nav_menu( array(
				'fallback_cb'     => '',
				'walker'          => '',
				'container'		  => '',
				'container_class' => '',
				'menu'            => $menu,
				'menu_class'      => finanzia_nice_class($menu_class),
				'link_class'	  => $link_class,
				'depth'           => 1,
				'theme_location'  => ''
			)); 
		?>
	</div>
<?php  endif;  ?>