<?php
$settings['num_words'] = !empty($settings['num_words']) ? $settings['num_words'] : 17;
$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Read More','finanzia');

$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'cms-industry', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['industry-category']));

// Arrows
$arrows = $widget->get_setting('arrows');
$arrows_type = $widget->get_setting('arrows_type', 'button');
$arrows_icon_size = ($arrows_type === 'icon') ? 24 : 18;
$arrows_classes = [
    'cms-carousel-button',
    'relative',
    'arrow-'.$arrows_type,
    finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
    'd-flex align-items-center justify-content-center',
    'bg-accent bg-hover-primary text-white text-hover-white',
    'circle',
    'text-'.$arrows_icon_size
];
$arrows_classes_prev = ['cms-carousel-button-prev prev'];
$arrows_classes_next = ['cms-carousel-button-next next'];
// Dots
$dots      = $widget->get_setting('dots');
$dots_type = $widget->get_setting('dots_type', 'bullets');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots',
        'cms-carousel-dots-'.$settings['dots_type'],
        'cms-carousel-dots-primary-regular',
        'cms-carousel-dots-active-accent-regular',
        'justify-content-center',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ]
]);

$title_tag = $widget->get_setting('title_tag', 'h2');

$thumbnail_size             = $widget->get_setting('thumbnail_size', 'custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height']: 423
];
$readmore_text              = $widget->get_setting('readmore_text', esc_html__('Read More','finanzia'));

$posts_data = array(
    'post_type'                  => 'cms-industry',
    'taxonomy'                   => 'industry-category',
    
    'layout'                     => $settings['layout'],   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_line'                   => $widget->get_setting('num_line', ['size' => 3])['size'],
    'readmore_text'              => $readmore_text,
    //
    'item_class'                 => 'cms-swiper-item swiper-slide'
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-post-carousel', 'cms-grid', 'cms-grid-'.$widget->get_setting('layout','1')],
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-carousel swiper">
        <div class="swiper-wrapper">
            <?php
                finanzia_get_post_grid($settings, $posts, $posts_data);
            ?>
        </div>
    </div>
    <?php if ($arrows == 'yes'){ ?>
            <div class="cms-swipwer-buttons d-flex gap-20 flex-auto"><?php
            finanzia_svgs_icon([
                'icon'  => 'core/arrow-left',
                'class' => finanzia_nice_class(array_merge($arrows_classes, $arrows_classes_prev)),
                'tag'   => 'div'
            ]);
            finanzia_svgs_icon([
                'icon'  => 'core/arrow-right',
                'class' => finanzia_nice_class(array_merge($arrows_classes, $arrows_classes_next)),
                'tag'   => 'div'
            ]); 
        ?></div>
    <?php } ?>
    <?php
        if ($dots == 'yes') : ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
    <?php endif ?>
</div>