<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'd-flex justify-content-between'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading',
		'text-'.$widget->get_setting('smallheading_color','body'),
		'pb-30 m-tb-n7',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading cms-nl2br empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'm-tb-n7'
	]
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'font-700',
		'text-'.$widget->get_setting('desc_color','heading'),
		'm-tb-n7'
	])
]);
// Description #2
$widget->add_inline_editing_attributes( 'desc2' );
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 empty-none pt-33',
		'text-'.$widget->get_setting('desc2_color','body'),
		'mt-tb-n7'
	])
]);
// Buttons
$widget->add_render_attribute('buttons',[
	'class' => [
		'cms-heading-buttons d-flex gap-30 pt-40',
		'align-items-center justify-content-'.$widget->get_setting('align',$default_align)
	]
]);
// Signature
$widget->add_render_attribute('signature-wrap',[
	'class' => [
		'cms-signature d-flex gap-20 align-items-center',
		'text-nowrap',
		'justify-content-'.$widget->get_setting('align', $default_align),
		'relative'
	]
]);
// Signature name
//$widget->add_inline_editing_attributes( 'sname' );
$widget->add_render_attribute('sname', [
	'class' => [
		'sname',
		'cms-heading text-17'
	]
]);
// Signature position
//$widget->add_inline_editing_attributes( 'sposition' );
$widget->add_render_attribute('sposition', [
	'class' => [
		'sposition',
		'text-15',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="col-8 col-tablet-extra-10 col-mobile-12 pb-70 pb-tablet-40 max-w" style="--max-w:730px;">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php 
			etc_print_html( $settings['smallheading_text'] ); 
		?></div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
			echo nl2br( $settings['heading_text'] ); 
		?></h2>
	</div>
	<div class="col-6 col-tablet-extra-10 col-mobile-12 ml-auto max-w" style="--max-w:620px;">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
			echo nl2br( $settings['desc'] ); 
		?></div>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc2' ) ); ?>><?php 
			echo nl2br( $settings['desc2'] ); 
		?></div>
		<div <?php etc_print_html($widget->get_render_attribute_string('buttons')); ?>><?php
			// Button #1
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link1_',
				'mode'		=> 'btn',
				'text_icon'	=> finanzia_svgs_icon([
					'icon'       => 'core/long-arrow-right',
					'icon_class' => '',
					'echo'       => false,
					'class'      => 'text-17'
				]),
				'class' => 'cms-hover-move-icon-right',
				'btn_color'       => 'accent',
				'btn_color_hover' => 'accent-darken'
			]);
			// Button #2
			finanzia_elementor_link_render($widget, $settings, [
				'name'            => 'link2_',
				'mode'            => 'btn',
				'class'           => '',
				'btn_color'       => 'primary',
				'btn_color_hover' => 'accent'
			]);
			// Signature 
			?>
			<div <?php etc_print_html($widget->get_render_attribute_string('signature-wrap')); ?>>
				<?php finanzia_elementor_image_render($settings, [
					'name'        => 'savatar',
					'size'		  => 'thumbnail',
					//'custom_size' => ['width' => 56, 'height' => 56],
					'img_class'   => finanzia_nice_class(['savatar', 'circle']),
					'attrs'		  => [],
					'before'      => '<div class="savatars max-w box-58 p-7 bdr-2 bdr-accent circle" style="--max-w:58px;">',
					'after'       => '</div>'
				]); ?>
				<div class="stext flex-auto relative">
					<?php 
						finanzia_elementor_image_render($settings, [
							'name'        => 'simage',
							'size'        => 'full',
							'img_class'	  => 'rtl-flip ml max-h',
							'custom_size' => ['width' => 172, 'height'=> 67],
							'attrs' => [
								'style' => '--max-h:67px;width:auto;--ml:53px;'
							],
							'default' => false
						]);
					?>
					<div class="cms--signature absolute center-left">
						<div <?php etc_print_html($widget->get_render_attribute_string('sname')); ?>><?php echo nl2br($settings['sname']); ?></div>
						<div <?php etc_print_html($widget->get_render_attribute_string('sposition')); ?>><?php echo nl2br($settings['sposition']); ?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>