<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'relative'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading',
		'text-'.$widget->get_setting('smallheading_color','accent'),
		'pb-20 mt-n7',
		'font-500',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n7',
		'pb-40'
	]
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'font-700',
		'text-'.$widget->get_setting('desc_color','body'),
		'mt-n7'
	])
]);
// Description #2
$widget->add_inline_editing_attributes( 'desc2' );
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 empty-none pt-25',
		'text-'.$widget->get_setting('desc2_color','body'),
		'mt-n7'
	])
]);
// Buttons
$widget->add_render_attribute('buttons',[
	'class' => [
		'cms-heading-buttons d-flex gap-30 pt-40',
		'align-items-center justify-content-'.$widget->get_setting('align',$default_align)
	]
]);
// Feature Desc
$widget->add_render_attribute('features-desc',[
	'class' => [
		'cms-heading-features-desc font-700 pt-60',
		'empty-none',
		'text-'.$widget->get_setting('feature_description_color','primary')
	]
]);
// Feature List
$features = $widget->get_setting('cms_feature', []);
$widget->add_render_attribute('features-wrap', [
	'class' => [
		'cms-heading-features pt-60'
	]
]);
// Signature
$widget->add_render_attribute('signature-wrap',[
	'class' => [
		'cms-signature d-flex gap-20 align-items-center',
		'text-nowrap',
		'justify-content-'.$widget->get_setting('align', $default_align),
		'relative'
	]
]);
// Signature name
//$widget->add_inline_editing_attributes( 'sname' );
$widget->add_render_attribute('sname', [
	'class' => [
		'sname',
		'cms-heading text-19 font-500'
	]
]);
// Signature position
//$widget->add_inline_editing_attributes( 'sposition' );
$widget->add_render_attribute('sposition', [
	'class' => [
		'sposition',
		'text-14 text-body',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php 
		etc_print_html( $settings['smallheading_text'] ); 
	?></div>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
		echo nl2br( $settings['heading_text'] ); 
	?></h2>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
		echo nl2br( $settings['desc'] ); 
	?></div>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc2' ) ); ?>><?php 
		echo nl2br( $settings['desc2'] ); 
	?></div>
	<div <?php etc_print_html($widget->get_render_attribute_string('buttons')); ?>><?php
		// Button #1
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link1_',
			'mode'		=> 'btn',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-17'
			]),
			'class'           => 'cms-hover-move-icon-right',
			'btn_color'       => 'accent',
			'btn_color_hover' => 'accent-darken'
		]);
		// Button #2
		finanzia_elementor_link_render($widget, $settings, [
			'name'            => 'link2_',
			'mode'            => 'btn',
			'class'           => '',
			'btn_color'       => 'accent-darken',
			'btn_color_hover' => 'accent'
		]);
		// Signature 
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string('signature-wrap')); ?>>
			<?php finanzia_elementor_image_render($settings, [
				'name'        => 'savatar',
				'size'		  => 'thumbnail',
				//'custom_size' => ['width' => 56, 'height' => 56],
				'img_class'   => finanzia_nice_class(['savatar', 'circle']),
				'attrs'		  => [],
				'before'      => '<div class="savatars max-w box-68 p-7 bdr-2 bdr-accent-regular circle" style="--max-w:68px;">',
				'after'       => '</div>'
			]); ?>
			<div class="stext flex-auto relative">
				<?php 
					finanzia_elementor_image_render($settings, [
						'name'        => 'simage',
						'size'        => 'full',
						'img_class'	  => 'rtl-flip ml-50 max-h',
						'custom_size' => ['width' => 172, 'height'=> 67],
						'attrs' => [
							'style' => '--max-h:67px;width:auto'
						]
					]);
				?>
				<div class="cms--signature absolute center-left">
					<div <?php etc_print_html($widget->get_render_attribute_string('sname')); ?>><?php echo nl2br($settings['sname']); ?></div>
					<div <?php etc_print_html($widget->get_render_attribute_string('sposition')); ?>><?php echo nl2br($settings['sposition']); ?></div>
				</div>
			</div>
		</div>
	</div>
	<?php if($settings['show_feature'] == 'yes'):
	// Feature Description
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('features-desc')); ?>><?php 
		echo nl2br($settings['feature_description']);
	?></div>
	<div <?php etc_print_html($widget->get_render_attribute_string('features-wrap')); ?>>
		<?php
		// Feature List
		foreach ( $features as $key => $cms_feature ):
			// Item
			$item_key = $widget->get_repeater_setting_key( 'item', 'cms_list', $key );
			$widget->add_render_attribute($item_key, [
				'class' => [
					'cms-list',
					'text-'.$widget->get_setting('feature_desc_color','body'),
					'd-flex gap-15',
					($key>0) ? 'bdr-t-1 pt-30 mt-30' : '',
					'bdr-'.$widget->get_setting('feature_border_color', 'divider')
				]
			]);
			// Title
			$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
			$widget->add_render_attribute($title_key, [
				'class' => [
					'feature-title',
					'text-17',
					'text-'.$widget->get_setting('feature_title_color','body'),
					'm-tb-n7'
				]
			]);
			$widget->add_inline_editing_attributes( $title_key, 'none' );
		?>
	        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
	            <?php 
	            	if(!empty($cms_feature['icon']['value'])){
		            	finanzia_elementor_icon_render($cms_feature['icon'], [], [ 
							'aria-hidden' => 'true', 
							'class'       => 'cms-eicon flex-auto',
							'icon_size'   => 64,
							'icon_color'  => $widget->get_setting('feature_icon_color','accent')
		            	]);
		            } else {
		            	finanzia_svgs_icon([
		            		'icon'  => 'check',
		            		'class'	=> 'cms--ficon flex-auto text-9 box-25 circle bg-grey text-accent mt-10'
		            	]);
		            }
	            ?>
	            <div class="feature-content flex-basic">
	            	<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php 
	            		echo esc_html( $cms_feature['title'] ); 
	            	?></div>
	            	<div class="desc text-14 pt-15 empty-none m-tb-n5"><?php
	            		echo nl2br($cms_feature['description']);
	            	?></div>
	            </div>
	        </div>
		<?php endforeach;?>
	</div>
	<?php endif; ?>
</div>