<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'd-flex gapY-40 justify-content-between'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n10',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInRight'
	])
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','body'),
		'pt-60 pt-tablet-30 mt-n7',
		'elementor-invisible'
	]),
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Signature
$widget->add_render_attribute('signature-wrap',[
	'class' => [
		'cms-signature',
		'flex-auto flex-smobile-full',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Signature name
//$widget->add_inline_editing_attributes( 'sname' );
$widget->add_render_attribute('sname', [
	'class' => [
		'sname',
		'cms-heading text-19 font-500'
	]
]);
// Signature position
//$widget->add_inline_editing_attributes( 'sposition' );
$widget->add_render_attribute('sposition', [
	'class' => [
		'sposition',
		'text-14 text-accent',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('signature-wrap')); ?>>
		<div class="cms-sticky">
			<?php finanzia_elementor_image_render($settings, [
				'name'        => 'savatar',
				'size'		  => 'custom',
				'custom_size' => ['width' => 90, 'height' => 122],
				'img_class'   => finanzia_nice_class(['savatar', 'cms-radius-16', 'mb-20']),
				'attrs'		  => [],
				'before'      => '',
				'after'       => ''
			]); ?>
			<div class="stext flex-auto relative">
				<?php 
					finanzia_elementor_image_render($settings, [
						'name'        => 'simage',
						'size'        => 'full',
						'img_class'	  => 'rtl-flip ml-50 max-h',
						'custom_size' => ['width' => 172, 'height'=> 67],
						'attrs' => [
							'style' => '--max-h:67px;width:auto'
						]
					]);
				?>
				<div class="cms--signature absolute center-left">
					<div <?php etc_print_html($widget->get_render_attribute_string('sname')); ?>><?php echo nl2br($settings['sname']); ?></div>
					<div <?php etc_print_html($widget->get_render_attribute_string('sposition')); ?>><?php echo nl2br($settings['sposition']); ?></div>
				</div>
			</div>
		</div>
	</div>
	<div class="flex-basic max-w" style="--max-w:840px;">
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
			echo nl2br( $settings['heading_text'] ); 
		?></h2>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
				echo nl2br( $settings['desc'] ); 
		?></div>
		<div class="d-flex gap-30 mt-40 empty-none elementor-invisible" data-settings='<?php echo json_encode(['animation' => 'fadeInUp']); ?>'><?php
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link1_',
				'mode'		=> 'btn',
				'text_icon'	=> finanzia_svgs_icon([
					'icon'       => 'core/arrow-right',
					'icon_class' => '',
					'echo'       => false,
					'class'      => 'text-10'
				]),
				'class' => [
					'btn-lg',
					'cms-hover-move-icon-up'
				],
				'btn_color'        => 'accent',
				'btn_color_hover'  => 'primary',
				'text_color'       => 'white',
				'text_color_hover' => 'white'
			]);
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link2_',
				'mode'		=> 'btn',
				'text_icon'	=> '',
				'class' => [
					'btn-lg'
				],
				'btn_prefix'       => 'btn-outline-',
				'btn_color'        => 'border',
				'btn_color_hover'  => 'accent',
				'text_color'       => 'primary',
				'text_color_hover' => 'white'
			]);
		?></div>
	</div>
</div>