<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'd-flex gapY-40 justify-content-between'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n10',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInRight'
	])
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','body'),
		'font-700',
		'mt-n7',
		'elementor-invisible'
	]),
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Description #2
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 empty-none',
		'text-'.$widget->get_setting('desc2_color','body'),
		'mt-n7 pt-30',
		'elementor-invisible'
	]),
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Signature
$widget->add_render_attribute('signature-wrap',[
	'class' => [
		'cms-signature',
		'col-4 col-tablet-3 col-mobile-12',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Signature name
//$widget->add_inline_editing_attributes( 'sname' );
$widget->add_render_attribute('sname', [
	'class' => [
		'sname',
		'cms-heading text-17 font-700'
	]
]);
// Signature position
//$widget->add_inline_editing_attributes( 'sposition' );
$widget->add_render_attribute('sposition', [
	'class' => [
		'sposition',
		'text-15',
	]
]);
// Feature List
$features = $widget->get_setting('cms_feature', []);
$widget->add_render_attribute('features-wrap', [
	'class' => [
		'cms-heading-features',
		'flex-basic max-w',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInRight'
	]),
	'style' => '--max-w:330px;--max-w-tablet-extra:50%;--max-w-mobile-extra:100%;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('signature-wrap')); ?>>
		<div class="cms-sticky pb-mobile-40">
			<?php finanzia_elementor_image_render($settings, [
				'name'        => 'savatar',
				'size'		  => 'custom',
				'custom_size' => ['width' => 120, 'height' => 160],
				'img_class'   => finanzia_nice_class(['savatar', 'cms-radius-5', 'mb-30']),
				'attrs'		  => [],
				'before'      => '',
				'after'       => ''
			]); ?>
			<div class="stext flex-auto relative">
				<?php 
					finanzia_elementor_image_render($settings, [
						'name'        => 'simage',
						'size'        => 'full',
						'img_class'	  => 'rtl-flip ml-50 max-h',
						'custom_size' => ['width' => 172, 'height'=> 67],
						'attrs' => [
							'style' => '--max-h:67px;width:auto'
						]
					]);
				?>
				<div class="cms--signature absolute center-left">
					<div <?php etc_print_html($widget->get_render_attribute_string('sname')); ?>><?php echo nl2br($settings['sname']); ?></div>
					<div <?php etc_print_html($widget->get_render_attribute_string('sposition')); ?>><?php echo nl2br($settings['sposition']); ?></div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-8 col-tablet-9 col-mobile-12">
		<div class="pl-70 pl-tablet-extra-0">
			<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
				echo nl2br( $settings['heading_text'] ); 
			?></h2>
			<div class="pt d-flex gap justify-content-between" style="--pt:60px;--pt-tablet:30px;--cms-gap:110px;--cms-gap-tablet-extra:40px;--cms-gap-mobile:30px;">
				<div class="flex-auto max-w" style="--max-w:330px;--max-w-tablet-extra:50%;--max-w-mobile-extra:100%;">
					<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
						echo nl2br( $settings['desc'] ); 
					?></div>
					<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc2' ) ); ?>><?php 
						echo nl2br( $settings['desc2'] ); 
					?></div>
					<div class="d-flex gap-30 mt-33 empty-none elementor-invisible" data-settings='<?php echo json_encode(['animation' => 'fadeInUp']); ?>'><?php
						finanzia_elementor_link_render($widget, $settings, [
							'name' 		=> 'link1_',
							'mode'		=> 'btn',
							'text_icon'	=> finanzia_svgs_icon([
								'icon'       => 'core/long-arrow-right',
								'icon_class' => '',
								'echo'       => false,
								'class'      => 'text-17'
							]),
							'class' => [
								'cms-hover-move-icon-right'
							],
							'btn_color'        => 'accent',
							'btn_color_hover'  => 'primary',
							'text_color'       => 'white',
							'text_color_hover' => 'white'
						]);
						finanzia_elementor_link_render($widget, $settings, [
							'name'             => 'link2_',
							'mode'             => 'btn',
							'text_icon'        => '',
							'class'            => [],
							'btn_prefix'       => 'btn-outline-',
							'btn_color'        => 'border',
							'btn_color_hover'  => 'accent',
							'text_color'       => 'primary',
							'text_color_hover' => 'white'
						]);
					?></div>
				</div>
				<?php if($settings['show_feature'] == 'yes'):?>
				<div <?php etc_print_html($widget->get_render_attribute_string('features-wrap')); ?>>
					<?php
					// Feature List
					$count_feature = 0;
					foreach ( $features as $key => $cms_feature ):
						$count_feature ++;
						// Items
						$item_key = $widget->get_repeater_setting_key( 'features-item', 'cms_list', $key );
						$widget->add_render_attribute($item_key,[
							'class' => [
								'cms-list',
								'text-'.$widget->get_setting('feature_desc_color','body'),
								'hover-icon-bounce',
								'd-flex align-items-center gap-15',
								($count_feature != count($features)) ? 'mb-30' : ''
							]
						]);
						// Title
						$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
						$widget->add_render_attribute($title_key, [
							'class' => [
								'feature-title',
								'text-17',
								'text-'.$widget->get_setting('feature_title_color','primary-darken'),
								'mt-n5'
							]
						]);
						$widget->add_inline_editing_attributes( $title_key, 'none' );
					?>
				        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
				            <?php 
				            	if(!empty($cms_feature['icon']['value'])){
					            	finanzia_elementor_icon_render($cms_feature['icon'], [], [ 
										'aria-hidden' => 'true', 
										'class'       => 'cms-eicon flex-auto',
										'icon_size'   => 64,
										'icon_color'  => $widget->get_setting('feature_icon_color','accent')
					            	]);
					            } else {
					            	finanzia_svgs_icon([
					            		'icon'  => 'check',
					            		'class'	=> 'cms--ficon flex-auto text-10 box-25 circle bg-grey text-accent'
					            	]);
					            }
				            ?>
				            <div class="feature-content flex-basic">
				            	<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php 
				            		echo esc_html( $cms_feature['title'] ); 
				            	?></div>
				            	<div class="desc text-14 pt-5 empty-none"><?php
				            		echo nl2br($cms_feature['description']);
				            	?></div>
				            </div>
				        </div>
					<?php endforeach;?>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>