<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'relative'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-26',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n8 pb-30'
	]
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc font-700',
		'cms-nl2br empty-none ',
		'text-'.$widget->get_setting('desc_color','heading'),
		'mt-n7'
	])
]);
// Description #2
$widget->add_inline_editing_attributes( 'desc2' );
$widget->add_render_attribute( 'desc2', [
	'class' => array_filter([
		'cms-desc2 cms-nl2br',
		'empty-none',
		'text-'.$widget->get_setting('desc2_color','body'),
		'pt-25'
	])
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
		echo nl2br( $settings['heading_text'] ); 
	?></h2>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
		echo nl2br( $settings['desc'] ); 
	?></div>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc2' ) ); ?>><?php 
		echo nl2br( $settings['desc2'] ); 
	?></div>
</div>