<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'relative'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-26',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n8'
	]
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none pt-30',
		'text-'.$widget->get_setting('desc_color','body'),
		'mt-n7'
	])
]);
// Feature Desc
$widget->add_render_attribute('features-desc',[
	'class' => [
		'cms-heading-features-desc font-700 pt-30',
		'empty-none',
		'text-'.$widget->get_setting('feature_description_color','primary')
	]
]);
// Feature List
$features = $widget->get_setting('cms_feature', []);
$widget->add_render_attribute('features-wrap', [
	'class' => [
		'cms-heading-features pt-40',
		'cms-lists-1'
	]
]);
$widget->add_render_attribute('features-item',[
	'class' => [
		'cms-list',
		'text-'.$widget->get_setting('feature_desc_color','body'),
		'hover-icon-bounce',
		'd-flex gap-15'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
		echo nl2br( $settings['heading_text'] ); 
	?></h2>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
		echo nl2br( $settings['desc'] ); 
	?></div>
	<?php if($settings['show_feature'] == 'yes'):?>
	<div <?php etc_print_html($widget->get_render_attribute_string('features-wrap')); ?>>
		<?php
		// Feature List
		foreach ( $features as $key => $cms_feature ):
			$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
			$widget->add_render_attribute($title_key, [
				'class' => [
					'feature-title',
					'text-16 font-700',
					'text-'.$widget->get_setting('feature_title_color','primary-darken')
				]
			]);
			$widget->add_inline_editing_attributes( $title_key, 'none' );
		?>
	        <div <?php etc_print_html($widget->get_render_attribute_string('features-item')); ?>>
	            <?php 
	            	if(!empty($cms_feature['icon']['value'])){
		            	finanzia_elementor_icon_render($cms_feature['icon'], [], [ 
							'aria-hidden' => 'true', 
							'class'       => 'cms-eicon flex-auto',
							'icon_size'   => 64,
							'icon_color'  => $widget->get_setting('feature_icon_color','accent')
		            	]);
		            } else {
		            	finanzia_svgs_icon([
		            		'icon'  => 'core/check',
		            		'class'	=> 'cms--ficon flex-auto text-8 box-26 circle bg-grey2 text-accent'
		            	]);
		            }
	            ?>
	            <div class="feature-content flex-basic">
	            	<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php 
	            		echo esc_html( $cms_feature['title'] ); 
	            	?></div>
	            	<div class="desc text-14 pt-15 empty-none"><?php
	            		echo nl2br($cms_feature['description']);
	            	?></div>
	            </div>
	        </div>
		<?php endforeach;?>
	</div>
	<?php endif; ?>
</div>