<?php 
$randGallery = $widget->get_setting('gallery', []);
if ($settings['gallery_rand'] == 'rand'){
    shuffle($randGallery);
}
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['gallery_custom_dimension']['width']) ? $settings['gallery_custom_dimension']['width'] : 400,
    'height' => !empty($settings['gallery_custom_dimension']['height']) ? $settings['gallery_custom_dimension']['height'] : 400
];
// Wrap
$widget->add_render_attribute('wrap',[
    'class' => array_filter([
        'cms-egallery',
        'cms-egallery-'.$settings['layout'],
    ]),
    'data-show' => $widget->get_setting('gallery_show', 6),
    'data-loadmore' => $widget->get_setting('gallery_loadmore_show', 3)
]);
// Wrap Inner
$widget->add_render_attribute('wrap-inner', [
    'class' => [
        'cms-images-light-box',
        'd-flex gutter gutter-mobile-20',
        finanzia_elementor_get_grid_columns($widget, $settings, [
            'default' => '3',
            'tablet'  => '2' 
        ])
    ]
]);
// Gallery Item
$widget->add_render_attribute('gallery-item', [
    'class' => [
        'cms-gallery-item'
    ]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div <?php etc_print_html($widget->get_render_attribute_string('wrap-inner')); ?>>
        <?php
        foreach ( $randGallery as $key => $value):
        	$value['gallery_size'] = $settings['gallery_size'];
        	$value['gallery_custom_dimension'] = $thumbnail_custom_dimension;
        	$value['gallery'] = $value;
            ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('gallery-item')); ?>>
                <?php if($settings['open_lightbox'] === 'yes'){ ?>
                    <a data-elementor-lightbox-slideshow="<?php echo esc_attr($settings['element_id']);?>" class="grid-item-inner cms-galleries-light-box relative d-flex overflow-hidden cms-radius-24" href="<?php echo esc_url(wp_get_attachment_image_url($value['id'], 'full')); ?>" title="<?php echo esc_attr(wp_get_attachment_caption($value['id']))?>">
                <?php 
                }
                    finanzia_elementor_image_render($value,[
						'name'        => 'gallery',
						'img_class'   => 'img-cover cms-radius-24',
						'custom_size' => $thumbnail_custom_dimension,
					]);
                ?>
                    <span class="cms-icon absolute cms-transition text-10 lh-0 box-58 circle bg-accent text-white bg-hover-white text-hover-accent z-top"><?php include get_template_directory() . '/assets/svgs/core/plus.svg'; ?></span>
                <?php if($settings['open_lightbox'] === 'yes'){ ?>
                    </a>
                <?php } ?>
            </div>
        <?php
        endforeach;
        ?>
    </div>
    <?php if(count($randGallery) > $widget->get_setting('gallery_show', '6')): ?>
        <div class="text-center pt-40">
            <a href="#" class="cms-gallery-load btn btn-lg btn-outline-border text-primary btn-hover-accent text-hover-white"><?php etc_print_html($widget->get_setting('load_more_text', 'Load More')); ?></a>
        </div>
    <?php endif; ?>
</div>