<?php
$default_align = $widget->get_setting('text_align', 'start');
$fancy_boxs = $widget->get_setting('fancy_box', []);
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-fancyboxs-'.$settings['layout'],
		'd-flex gutter-custom-x gutter-custom-y',
		finanzia_elementor_get_grid_columns($widget, $settings, [
			'default' => 4,
			'tablet'  => 3,
			'mobile'  => 2,
			'gap'        => '',
			'gap_prefix' => ''	
		]),
		finanzia_elementor_get_alignment_class($widget, $settings, [
			'name'    => 'text_align',
			'default' => $default_align
		])
	],
	'style' => implode(';', [
		'--gutter-x:40px',
		'--gutter-y:80px'
	])
]);
//Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-heading cms-nl2br',
		'text-'.$widget->get_setting('title_color','primary'),
		'text-19',
		'mt-n5 pb-15',
		'bdr-b-1 bdr-divider'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc cms-nl2br',
		'text-'.$widget->get_setting('description_color','body'),
		'text-15',
		'pt-20 mb-n5',
		'empty-none'
	]
]);
// Output HTMl
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	$count = 0;
	foreach ($fancy_boxs as $key => $fancy_box) { 
		$count++;
		// Item
		$item_key = $widget->get_repeater_setting_key( 'item', 'cms_fancy_box', $key );
		$widget->add_render_attribute( $item_key, [
			'class' => array_filter([
				'fancy-box-item relative'
			])
		]);
		// Item Inner
		$item_inner_key = $widget->get_repeater_setting_key( 'item-inner', 'cms_fancy_box', $key );
		$widget->add_render_attribute( $item_inner_key, [
			'class' => array_filter([
				'cms-fancybox',
				'cms-fancybox-'.$settings['layout'],
				'hover-icon-bounce'
			])
		]);
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string($item_inner_key)); ?>>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $fancy_box['title'] ); ?></div>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo wpautop( $fancy_box['description'] ); ?></div>
		    <?php
				// Icon
				finanzia_elementor_icon_image_render($widget, $settings,[
					'size'        => 48,
		            'color'       => $widget->get_setting('icon_color','accent'),
		            'color_hover' => $widget->get_setting('icon_color','accent'),
		            // icon
		            'icon_tag'    => 'div',
		            'icon_default' => [],
		            // default
		            'class'      => 'mt-50',
		            'before'     => '',
		            'after'      => '',
		            'echo'       => true
				], $fancy_box);
			?>
			<?php 
				finanzia_elementor_link_render($widget, $fancy_box, [
					'loop'        => true,
					'loop_key'    => $key,
					'color'       => false,
					'class'       => 'mt-23 cms-link font-700 cms-hover-underline cms-hover-move-icon-right',
					'before_text' => '',
					'after_text'  => '',
					'text_icon'   => finanzia_svgs_icon([
						'icon'       => 'core/long-arrow-right',
						'class'      => 'text-17',
						'icon_class' => '',
						'echo'       => false
					])
				]);
			?>
		</div>
	</div>
	<?php } ?>
</div>
