<?php 
$download_lists = $widget->get_setting('download_lists', []);
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-emenu',
		'cms-emenu-'.$settings['layout'],
		'p-50 p-lr-tablet-30 p-lr-smobile-20',
		'bg-grey'
	]
]);
// Title
$widget->add_inline_editing_attributes('title');
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-heading empty-none',
		'text-'.$widget->get_setting('title_color', 'heading'),
		'text-21',
		'pb-15 mt-n7 mb-30',
		'bdr-b-2'
	]
]);
// Items

?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('title')) ?>><?php echo nl2br($settings['title']); ?></div>
	<div class="cms-download-list"><?php
		$count = 0;
		foreach ($download_lists as $key => $download) {
			$count++;
			$download_key = $widget->get_repeater_setting_key( 'link', 'cms_download_link', $key );
	    	$widget->add_link_attributes( $download_key, $download['link'] );
			$widget->add_render_attribute($download_key, [
				'class' => [
					'cms-dowload-item',
					'd-flex flex-nowrap align-items-center gap-20',
					'text-15 font-700',
					'cms-radius-5',
					'text-white text-hover-white',
					'cms-hover-change'
				]
			]);
			// icon 
			$icon_classes = ['cms-icon p-20 p-smobile-10 flex-auto cms-transition', 'bdr-r-1 bdr-divider-30'];
			//
			if($key%2 == 0){
				$widget->add_render_attribute($download_key, [
					'class' => [
						'bg-primary bg-hover-accent',
					]
				]);
			} else {
				$widget->add_render_attribute($download_key, [
					'class' => [
						'bg-accent bg-hover-primary',
					]
				]);
			}
			if($count != count($download_lists)){
				$widget->add_render_attribute($download_key, [
					'class' => ['mb-20']
				]);
			}
    ?>
    	<a <?php etc_print_html($widget->get_render_attribute_string($download_key)) ?>><?php 
    		//icon
    		finanzia_elementor_icon_render( $download['icon'], [], [ 'aria-hidden' => 'true', 'class' => finanzia_nice_class($icon_classes), 'icon_size' => 48 ] );
    		//text
    		etc_print_html($download['name']);
    	?></a>
  <?php
		}
	?></div>
</div>