<?php
$widget->add_inline_editing_attributes( 'text' );
$widget->add_inline_editing_attributes( 'link_text' );
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-cta',
		'cms-cta-'.$settings['layout'],
		finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align'])
	])
]);
// Text
$widget->add_render_attribute('text', [
	'class' => [
		'cms-desc',
		'text-'.$widget->get_setting('text_color','body'),
		'empty-none'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<span <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php printf('%s', $settings['text']);?></span>
	<?php 
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link_',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-17'
			]),
			'class' => [
				'cms-link',
				'cms-hover-move-icon-right',
				'cms-hover-underline',
				'font-700'
			],
			'text_color'       => 'accent',
			'text_color_hover' => 'primary'
		]);
	?>
</div>