<?php
// wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-charts-'.$settings['layout'],
		'relative',
		'cms-radius-tr-64'
	]
]);
// Content
$widget->add_render_attribute('wrap-content', [
	'class' => [
		'cms-charts-content',
		'cms-gradient-'.$settings['bg_gradient'],
		'cms-backdrop-1',
		'max-290',
		'cms-radius-34 p-50 p-lr-smobile-20',
		'absolute bottom-left mb-110 ml-20'
	]
]);
// Chart 
$charts = $widget->get_settings('cms_chart',[]);
$chart_dimensions = $widget->get_settings('cms_chart_dimensions')['size'];
$chart_dimensions_size = !empty($chart_dimensions) ? $chart_dimensions : 190;

$chart_cutout = $widget->get_settings('cms_chart_cutout')['size'];
$chart_cutout_size = !empty($chart_cutout) ? $chart_cutout : '70';
// Features
$features = $widget->get_settings('cms_features',[]);
$widget->add_render_attribute('features',[
	'class' => [
		'cms-lists cms-lists-4 mt-40',
		'text-'.$widget->get_setting('feature_color', 'accent-regular')
	]
]);
$widget->add_render_attribute('feature-list',[
	'class' => [
		'cms-list d-flex gap-20 font-500 bdr-b-1',
		'bdr-'.$widget->get_setting('feature_border_color', 'accent-regular')
	]
]);
// Chart After
ob_start();
?>
<div class="chart-value absolute bottom-center text-white heading text-24 font-500 lh-07"><?php echo esc_html($charts[0]['chart_value']); ?>%</div>
<?php
$chart_after = ob_get_clean();
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>><?php
	// Banner
	finanzia_elementor_image_render($settings,[
		'name'                => 'banner',
		'size'				  => 'custom',
		'custom_size'         => ['width' => 780, 'height' => 800],
		'img_class'			  => 'cms-radius-tr-64',
		'as_background'		  => true,
		'as_background_class' => 'cms-radius-tr-64 pt-130',
		'max_height'		  => true
	]);
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap-content')); ?>><?php
		// Charts
		finanzia_chart_data_settings($widget, $settings,[
			'wrap_class'	   => 'relative',
			'chart_dimensions' => $chart_dimensions_size,
			'chart_mode' 	   => $widget->get_setting('cms_chart_mode','half-circle'),
			'chart_cutout'	   => $chart_cutout_size,
			'after'			   => $chart_after	
		]);
		// Get first value as lable
		?>
		<div class="cms-heading text-19 lh-1315 text-white empty-none pt-35"><?php 
			echo nl2br($settings['content']);
		?></div>
	</div>
</div>