<?php
$background_img        = finanzia_elementor_image_src_render($settings, ['name' => 'banner', 'echo' => false]);
$chart_dimensions      = $widget->get_settings('cms_chart_dimensions')['size'];
$chart_dimensions_size = !empty($chart_dimensions) ? $chart_dimensions : 220;
$chart_cutout          = $widget->get_settings('cms_chart_cutout')['size'];
$chart_cutout_size     = !empty($chart_cutout) ? $chart_cutout : '55';
// wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-charts-'.$settings['layout'],
		'cms-lazy cms-bg-parallax',
		'relative',
		'min-h',
		'd-flex align-items-end',
		'cms-gradient-render cms-gradient-'.$settings['bg_gradient'],
		'pb-110 pb-tablet-40'
	],
	'style' => [
		'--min-h:800px;--min-h-tablet:500px;',
		'--cms-bg-lazyload:url('.$background_img.');',
		'background-image:var(--cms-bg-lazyload-loaded);'
	]
]);
// Content 
$widget->add_inline_editing_attributes( 'title' );
$widget->add_inline_editing_attributes( 'text' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('content',[
	'class' => [
		'content max-w',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInUp'
	]),
	'style' => '--max-w:'.$chart_dimensions_size.'px;'
]);
$widget->add_render_attribute('title', [
	'class' => [
		'cms-title cms-heading cms-nl2br empty-none',
		'text-24 font-600 text-white',
		'm-tb-n7 pt-30',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInUp'
	])
]);
$widget->add_render_attribute('text', [
	'class' => [
		'cms-desc cms-nl2br',
		'empty-none',
		'text-white',
		'm-tb-n7 pt-30',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInUp'
	])
]);

// chart
$charts = $widget->get_settings('cms_chart',[]);

$widget->add_render_attribute('chart',[
	'class' => [
		'max-w',
		//'elementor-invisible'
	],
	'data-settings' => json_encode([
		//'animation' => 'fadeInUp'
	]),
	'style' => '--max-w:'.$chart_dimensions_size.'px;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="container">
		<div <?php etc_print_html($widget->get_render_attribute_string('chart')); ?>><?php
			// Charts
			finanzia_chart_data_settings($widget, $settings,[
				'chart_dimensions' => $chart_dimensions_size,
				'chart_mode' 	   => $widget->get_setting('cms_chart_mode'),
				'chart_cutout'	   => $chart_cutout_size,
				'class'			   => ''
			]);
			?>
		</div>
		<div <?php etc_print_html($widget->get_render_attribute_string('content')); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('title'));?>><?php etc_print_html($settings['title']) ?></div>
			<div <?php etc_print_html($widget->get_render_attribute_string('text'));?>><?php echo wpautop($settings['text']) ?></div>
			<div class="cms-buttons d-flex align-items-center gap-30 pt-40 empty-none"><?php
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'	    => 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/long-arrow-right',
						'icon_class' => '',
						'echo'       => false,
						'class'      => 'text-17'
					]),
					'class' => [
						'cms-hover-move-icon-right'
					]
				]);
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link2_',
					'mode'		=> 'btn',
					'text_icon'	=> '',
					'class' => [],
					'btn_prefix'       => 'btn-outline-',
					'btn_color'        => 'border',
					'text_color'       => 'primary',
					'btn_color_hover'  => 'primary',
					'text_color_hover' => 'white'
				]);
			?></div>
		</div>
	</div>
</div>