<?php
$widget->add_inline_editing_attributes( 'title' );
$widget->add_inline_editing_attributes( 'text' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('title', [
	'class' => [
		'cms-title cms-heading text-24 font-600','empty-none',
		'm-tb-n7 pb-30'
	]
]);
$widget->add_render_attribute('text', [
	'class' => [
		'cms-desc',
		'empty-none',
		'm-tb-n7'
	]
]);
// Chart 
$charts = $widget->get_settings('cms_chart');
$chart_dimensions = $widget->get_settings('cms_chart_dimensions')['size'];
$chart_dimensions_size = !empty($chart_dimensions) ? $chart_dimensions : 400;
$chart_cutout = $widget->get_settings('cms_chart_cutout')['size'];
$chart_cutout_size = !empty($chart_cutout) ? $chart_cutout : '50%';
$html_id = etc_get_element_id($settings);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('title'));?>><?php etc_print_html($settings['title']) ?></div>
<div class="d-flex gutter-30">
	<div class="cms-chart-content col-6 col-mobile-12">
		<div <?php etc_print_html($widget->get_render_attribute_string('text'));?>><?php echo wpautop($settings['text']) ?></div>
		<div class="cms-buttons d-flex align-items-center gap-30 pt-40 empty-none"><?php
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link1_',
				'mode'	    => 'btn',
				'text_icon'	=> finanzia_svgs_icon([
					'icon'       => 'core/arrow-right',
					'icon_class' => '',
					'echo'       => false,
					'class'      => 'text-12'
				]),
				'class' => [
					'btn-lg',
					'cms-hover-move-icon-right'
				]
			]);
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link2_',
				'mode'		=> 'btn',
				'text_icon'	=> '',
				'class' => [
					'btn-lg',
				],
				'btn_prefix'       => 'btn-outline-',
				'btn_color'        => 'border',
				'text_color'       => 'primary',
				'btn_color_hover'  => 'primary',
				'text_color_hover' => 'white'
			]);
		?></div>
	</div>
	<div class="col-6 col-mobile-12">
		<div class="cms-charts-chart pl-30 cms-sticky">
			<?php finanzia_chart_data_settings($widget, $settings, [
				'chart_dimensions' => $chart_dimensions_size,
				'chart_mode'       => $widget->get_setting('cms_chart_mode'),
				'chart_cutout'	   => $chart_cutout_size,
				'wrap_class'	   => 'm-lr-auto'	
			]); ?>
			<?php if($settings['show_label'] == 'yes'){ ?>
				<div class="cms-chart-items d-flex align-items-start pt-25">
		            <?php foreach ($charts as $key => $value): 
		                $chart_setting_key = $widget->get_repeater_setting_key( 'chart_item', 'chart', $key );
		                $widget->add_render_attribute( $chart_setting_key, [
		                    'class' => 'd-inline-block circle flex-auto mt-7',
		                    'style' => 'width: 10px; height: 10px;background-color:'.$value['chart_color']
		                ]);
		            ?>
		               <div class="cms-chart-item-title font-700 text-14 d-flex flex-nowrap gap-10 flex-50 flex-tablet-extra-full"><span <?php $widget->print_render_attribute_string( $chart_setting_key );?>></span><?php etc_print_html($value['chart_main_title']); ?></div>
		            <?php endforeach; ?>
		        </div>
		    <?php } ?>
	    </div>
	</div>
</div>