<?php
$settings['num_line'] = !empty($settings['num_line']['size']) ? $settings['num_line'] : ['size' => 3];
$num_line = $settings['num_line']['size'];

$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Explore More','finanzia');

$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'cms-case', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['case-category']));

// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex justify-content-end gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-19',
    'box-67 circle',
    'text-'.$widget->get_setting('arrow_color','white'),
    'bg-'.$widget->get_setting('arrow_bg_color','divider-30'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','accent'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','white')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'justify-content-start gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-divider-30);',
        '--cms-dots-hover-color:var(--cms-white);'
    ]
]);

$thumbnail_size             = $widget->get_setting('thumbnail_size', 'large');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height']: 380
];
$num_words                  = $widget->get_setting('num_words',25);
$readmore_text              = $widget->get_setting('readmore_text', esc_html__('Read More','finanzia'));

$posts_data = array(
    'post_type'                  => 'cms-case',
    'taxonomy'                   => 'case-category',
    
    'layout'                     => $settings['layout'],   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_words'                  => $num_words,
    'readmore_text'              => $readmore_text,
    //
    'item_class'                 => 'cms-swiper-item swiper-slide'
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-post-carousel', 'cms-grid', 'cms-grid-'.$widget->get_setting('layout','1')],
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-carousel swiper">
        <div class="swiper-wrapper">
            <?php
                finanzia_get_post_grid($settings, $posts, $posts_data);
            ?>
        </div>
    </div>
    <div class="d-flex gutter-40 align-items-end pt-50">
        <div <?php etc_print_html($widget->get_render_attribute_string('cta-wrap')); ?>>
            <div class="m-tb-n7">
                <span <?php etc_print_html($widget->get_render_attribute_string('cta-text')) ?>><?php printf('%s', $settings['cta_text']);?></span>
                <?php 
                    finanzia_elementor_link_render($widget, $settings, [
                        'name'      => 'cta_link_',
                        'text_icon' => '',
                        'class' => [
                            'cms-link',
                            'cms-hover-underline',
                            'font-700'
                        ]
                    ]);
                ?>
            </div>
        </div>
        <div class="cms-swiper-buttons-dots flex-basic d-flex gap-20 align-items-center justify-content-between empty-none order-mobile-extra-first"><?php
            // Dots
            if ($dots == 'yes') { ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
            <?php } 
            // Arrows
            if ($arrows == 'yes'){ ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                    finanzia_elementor_icon_render(
                        [], 
                        [
                            'library' => 'svg',
                            'value'   => [
                                'id'  => '',
                                'url' => get_template_directory().'/assets/svgs/core/arrow-left.svg'
                            ]
                        ], 
                        [
                            'class'     => $arrows_classes_prev,
                            'icon_size' => 19
                        ], 
                        'div'
                    );
                    finanzia_elementor_icon_render(
                        [], 
                        [
                            'library' => 'svg',
                            'value'   => [
                                'id'  => '',
                                'url' => get_template_directory().'/assets/svgs/core/arrow-right.svg'
                            ]
                        ], 
                        [
                            'class'     => $arrows_classes_next,
                            'icon_size' => 19
                        ], 
                        'div'
                    );
                ?></div>
            <?php } 
        ?></div>
    </div>
</div>