<?php
$settings['num_line'] = !empty($settings['num_line']['size']) ? $settings['num_line'] : ['size' => 3];
$num_line = $settings['num_line']['size'];

$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Explore More','finanzia');

$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'cms-case', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['case-category']));

// Arrows
$arrows = $widget->get_setting('arrows');
$arrows_type = $widget->get_setting('arrows_type', 'icon');
$arrows_icon_size = ($arrows_type === 'icon') ? 25 : 10;
$arrows_classes = [
    'cms-carousel-button relative',
    'arrow-'.$arrows_type,
    finanzia_add_hidden_device_controls_render($settings, 'arrows_')
];
$widget->add_render_attribute('arrows-prev', [
    'class' => array_merge(['cms-carousel-button-prev prev'], $arrows_classes)
]);
$widget->add_render_attribute('arrows-next', [
    'class' => array_merge(['cms-carousel-button-next next'], $arrows_classes)
]);
// Dots
$dots      = $widget->get_setting('dots');
$dots_type = $widget->get_setting('dots_type', 'bullets');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots',
        'cms-carousel-dots-'.$settings['dots_type'],
        'cms-carousel-dots-primary-regular',
        'cms-carousel-dots-active-accent-regular',
        'justify-content-end',
        finanzia_add_hidden_device_controls_render($settings, 'dots_'),
        'mt-20'
    ]
]);

$title_tag = $widget->get_setting('title_tag', 'h2');

$thumbnail_size             = $widget->get_setting('thumbnail_size', 'custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height']: 423
];
$num_words                  = $widget->get_setting('num_words',25);
$readmore_text              = $widget->get_setting('readmore_text', esc_html__('Read More','finanzia'));

$posts_data = array(
    'post_type'                  => 'cms-case',
    'taxonomy'                   => 'case-category',
    
    'layout'                     => $settings['layout'],   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_words'                  => $num_words,
    'readmore_text'              => $readmore_text,
    //
    'item_class'                 => 'cms-swiper-item swiper-slide'
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-post-carousel', 'cms-grid', 'cms-grid-'.$widget->get_setting('layout','1')],
]);
// Heading wrap
$widget->add_render_attribute('heading-wrap',[
    'class' => [
        'cms-heading-wrap',
        'flex-basic',
        'flex-mobile-full'
    ]
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
    'class' => [
        'cms-smallheading empty-none font-700 text-16 pb-10',
        'text-'.$widget->get_setting('smallheading_color','accent'),
    ]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
    'class' => [
        'cms-heading empty-none',
        'text-'.$widget->get_setting('heading_color'),
        'text-45 lh-1375'
    ]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-carousel swiper">
        <div class="swiper-wrapper">
            <?php
                finanzia_get_post_grid($settings, $posts, $posts_data);
            ?>
        </div>
    </div>
    <?php // Arrows
    if ($arrows == 'yes'){
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-left',
            'class' => 'cms-carousel-button cms-carousel-button-prev text-24 box-64 circle cms-gradient-1 bg-hover-accent text-white d-flex align-items-center justify-content-center',
            'tag'   => 'div'
        ]);
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-right',
            'class' => 'cms-carousel-button cms-carousel-button-next text-24 box-64 circle cms-gradient-1 bg-hover-accent text-white d-flex align-items-center justify-content-center',
            'tag'   => 'div'
        ]);
    } ?>
    <?php
        if ($dots == 'yes') : ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
    <?php endif ?>
</div>