<?php
$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'post', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
], ['category']));

// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-9',
    'box-58 circle',
    'text-'.$widget->get_setting('arrow_color','accent-darken'),
    'bdr-1 bdr-'.$widget->get_setting('arrow_color','accent-darken'),
    'bg-'.$widget->get_setting('arrow_bg_color','white'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bdr-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'cms-carousel-dots-primary cms-carousel-dots-active-accent-regular',
        'justify-content-start gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-primary);',
        '--cms-dots-hover-color:var(--cms-accent);',
    ]
]);
// Thumbnail
$thumbnail_size             = $widget->get_setting('thumbnail_size', 'custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height']: 380
];
// Posts Data
$posts_data = array(
    'post_type'                  => 'post',
    'taxonomy'                   => 'category',
    
    'layout'                     => $settings['layout'],   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_line'                   => $widget->get_setting('num_line', ['size' => 4])['size'],
    'readmore_text'              => $widget->get_setting('readmore_text', esc_html__('Read More','finanzia')),
    //
    'item_class'                 => 'cms-swiper-item swiper-slide'
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-post-carousel', 'cms-grid', 'cms-grid-'.$settings['layout']],
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-carousel swiper">
        <div class="swiper-wrapper">
            <?php
                finanzia_get_post_grid($settings, $posts, $posts_data);
            ?>
        </div>
    </div>
    <div class="cms-swiper-buttons-dots d-flex gap-20 align-items-center justify-content-between empty-none pt" style="--pt:23px;"><?php
        // Dots
        if ($dots == 'yes') { ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
        <?php } 
        // Arrows
        if ($arrows == 'yes'){ ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-prev.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_prev,
                        'icon_size' => 10
                    ], 
                    'div'
                );
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-next.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_next,
                        'icon_size' => 10
                    ], 
                    'div'
                );
            ?></div>
        <?php } 
    ?></div>
</div>