<?php
// Post thumnail as banner
$settings['banner']['id'] = !empty($settings['banner']['id']) ? $settings['banner']['id'] : get_post_thumbnail_id();
//wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-ebanner', 
		'cms-ebanner-'.$settings['layout'],
		'hover-image-zoom-out',
		'overflow-hidden',
		'cms-hover-change',
		'text-center'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'text-21'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('description_color','body'),
		'text-15',
		'pt-15 mb-n7'
	])
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php
		// Banner
		finanzia_elementor_image_render($settings,[
			'name'        => 'banner',
			'size'        => '',
			'custom_size' => ['width' => 294, 'height' => 200],
			'img_class'	  => '',
			'before'      => '<div class="bg-grey bg-hover-accent bg-on-hover-accent cms-transition mb-35 text-center p-tb p-lr" style="--p-tb:33px;--p-lr:20px;">',
			'after'       => '</div>'
		]);
	?>
	<div class="p-lr-40 p-lr-tablet-extra-20 p-lr-tablet-0">
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo nl2br( $settings['description_text'] ); ?></div>
	</div>
</div>