(function($) {
    "use strict";
    $(window).on('elementor/frontend/init', function($scope, settings) {
        var _elementor = typeof elementor != 'undefined' ? elementor : elementorFrontend;
        // lazy load image
        var GlobalLazyLoad = function($scope, $) {
            $.each($scope.find('.cms-lazy'), function(index, item) {
                const observer = elementorModules.utils.Scroll.scrollObserver({
                    callback: event => {
                        if (event.isInViewport) {
                            // remove css class
                            $(this).removeClass('lazy-loading').addClass('cms-lazy-loaded');
                            // add style
                            var duration = $(this).data('duration');
                            if (typeof duration != 'undefined') {
                                $(this).css({ 'animation-duration': duration + 'ms' });
                            }
                        }
                    }
                });
                observer.observe(item);
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', GlobalLazyLoad);
        /**
         * Animate
         * Make animate re-play
         * 
         * */
        var GlobalWidgetAnimateHandler = function($scope, $) {
            $.each($scope.find('.elementor-invisible'), function(index, item) {
                const observer = elementorModules.utils.Scroll.scrollObserver({
                    callback: event => {
                        var animate = $(this),
                        data = animate.data('settings');
                        if (typeof data['animation'] != 'undefined' || typeof data['_animation'] != 'undefined') {
                            if (event.isInViewport) {
                                $(this).addClass('cms-inview');
                                //
                                setTimeout(function() {
                                    animate.removeClass('elementor-invisible').addClass('animated ' + data['animation']);
                                }, data['animation_delay']);
                                //
                                if(typeof data['_animation'] != 'undefined'){
                                    setTimeout(function() {
                                        animate.addClass(data['_animation']);
                                    }, data['_animation_delay']);
                                }
                            } else {
                                // Revert
                                /*$(this).removeClass('cms-inview').removeClass('animated').removeClass(data['animation']).addClass('elementor-invisible');
                                if(typeof data['_animation'] != 'undefined'){
                                    $(this).removeClass(data['_animation']);
                                }*/
                            }
                        }
                    }
                });
                observer.observe(item);
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', GlobalWidgetAnimateHandler);
        // Equal Height
        var CMSEqualHeight = function($scope, $) {
            $.each($scope.find('.cms-equal-item'), function(index, item) {
                var self = $(this),
                    target = '#'+self.data('equal'),
                    equal_item = self.parents('.cms-equal').find(target),
                    self_h = self.innerHeight();
                    equal_item.css({'min-height':self_h});
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', CMSEqualHeight);
        // Accordion
        var WidgetCMSAccordionHandler = function($scope, $) {
            $scope.find('.cms-accordion-title').on('click', function(e) {
                e.preventDefault();
                var self = $(this);
                if (self.hasClass('animating')) {
                    return false;
                }
                self.addClass('animating');
                var target = self.data('target');
                var parent = self.parents('.cms-accordion-wrap');
                var active_items = parent.find('.cms-accordion-title.active');
                $.each(active_items, function(index, item) {
                    var item_target = $(item).data('target');
                    if (item_target != target) {
                        $(item).removeClass('active');
                        self.parent().removeClass('active');
                        $(item_target).slideUp(400);
                    }
                });

                if (self.hasClass('active')) {
                    self.parent().removeClass('active');
                    self.removeClass('active');
                    $(target).slideUp(400);
                } else {
                    self.parents('.cms-accordion').find('.cms-accordion-item').removeClass('active');
                    self.parents('.cms-accordion').find('.cms-accordion-title').removeClass('active');
                    self.parents('.cms-accordion').find('.cms-accordion-content').slideUp(400);
                    self.parent().addClass('active');
                    self.addClass('active');
                    $(target).slideDown(400);
                }
                setTimeout(function() {
                    self.removeClass('animating');
                }, 400);
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSAccordionHandler);
        
        // // Accordion Sticky
        // var WidgetCMSAccordionStickyHandler = function($scope, $) {
        //     $scope.find('.cms-accordion-sticky').on('click', function(e) {
        //         e.preventDefault();
        //         var self = $(this);
        //         if (self.hasClass('animating')) {
        //             return false;
        //         }
        //         self.addClass('animating');
        //         var target = self.data('target');
        //         var parent = self.parents('.cms-accordions-sticky');
        //         var active_items = parent.find('.cms-accordion-sticky.active');

        //         // active items
        //         /*$.each(active_items, function(index, item) {
        //             var item_target = $(item).data('target');
        //             if (item_target != target) {
        //                 $(item).removeClass('active');
        //                 self.parents('.cms-accordion-item').removeClass('active');
        //                 $(item_target).slideUp(400);
        //             }
        //         });*/

        //         if (self.hasClass('active')) {
        //             /*self.parents('.cms-accordion-item').removeClass('active');
        //             self.removeClass('active');
        //             $(target).slideUp(400);*/
        //         } else {
        //             self.parents('.cms-accordions-sticky').find('.cms-accordion-item').removeClass('active');
        //             self.parents('.cms-accordions-sticky').find('.cms-accordion-sticky').removeClass('active');
        //             self.parents('.cms-accordions-sticky').find('.cms-accordion-content').slideUp(400);
        //             self.parents('.cms-accordion-item').addClass('active');
        //             self.addClass('active');
        //             $(target).slideDown(400);
        //         }
        //         setTimeout(function() {
        //             self.removeClass('animating');
        //         }, 400);
        //         // animate to top
        //         $('html,body').animate({scrollTop: parent.offset().top - 100}, 30);
        //     });
        // };
        // elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSAccordionStickyHandler);
        
        // Counter
        var WidgetCMSCounterHandler = function( $scope, $ ) {
            elementorFrontend.waypoint($scope.find('.cms-counter-number'), function () {
                var $number = $(this),
                    data = $number.data();

                var decimalDigits = data.toValue.toString().match(/\.(.*)/);

                if (decimalDigits) {
                    data.rounding = decimalDigits[1].length;
                }

                $number.numerator(data);

            }, {
                offset: 0,
                triggerOnce: true
            });
            // add class active to counter chart bar
            elementorFrontend.waypoint($scope.find('.cms-counter-chart-bar'), function () {
                $(this).addClass('active');
            });
            //
            $scope.find('.counter-item').on('click', function(e) {
                e.preventDefault();
                var self = $(this);
                if (self.hasClass('animating')) {
                    return false;
                }
                self.addClass('animating');
                var target = self.data('target');
                var parent = self.parents('.cms-counter-sticky');
                var active_items = parent.find('.counter-item.active');
                $.each(active_items, function(index, item) {
                    var item_target = $(item).data('target');
                    if (item_target != target) {
                        //$(item).removeClass('active');
                        //self.parent().removeClass('active');
                        //$(item_target).slideUp(400);
                        //$(item_target).removeClass('active');
                    }
                });

                if (self.hasClass('active')) {
                    //self.parent().removeClass('active');
                    //self.removeClass('active');
                    //$(target).slideUp(400);
                    //$(target).removeClass('active');
                } else {
                    self.parent().addClass('active');
                    self.addClass('active');
                    //$(target).slideDown(400);
                    $(target).addClass('active');
                }
                setTimeout(function() {
                    self.removeClass('animating');
                }, 400);
            });
            $scope.find('.counter-item').on('hover', function(e) {
                e.preventDefault();
                var self = $(this);
                if (self.hasClass('animating')) {
                    return false;
                }
                self.addClass('animating');
                var target = self.data('target');
                var parent = self.parents('.cms-counter-sticky');
                var active_items = parent.find('.counter-item.active');
                $.each(active_items, function(index, item) {
                    var item_target = $(item).data('target');
                    if (item_target != target) {
                        $(item).removeClass('active');
                        self.parent().removeClass('active');
                        //$(item_target).slideUp(400);
                        $(item_target).removeClass('active');
                    }
                });

                if (self.hasClass('active')) {
                    //self.parent().removeClass('active');
                    //self.removeClass('active');
                    //$(target).slideUp(400);
                    //$(target).removeClass('active');
                } else {
                    //$(target).slideDown(400);
                    self.parent().addClass('active');
                    self.addClass('active');
                    $(target).addClass('active');
                }
                setTimeout(function() {
                    self.removeClass('animating');
                }, 400);
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSCounterHandler);
        // Tabs
        var WidgetCMSTabsHandler = function( $scope, $ ) {
            var data_break = $scope.find('.cms-tabs').data('break');
            //
            $scope.find(".cms-tab-title").on("click touch mouseenter", function(e){
                e.preventDefault();
                var target = $(this).data("target");
                var parent = $(this).parents(".cms-tabs");
                // hide all
                parent.find(".cms-tabs-content").removeClass('active').addClass('absolute cms-invisible');
                parent.find(".cms-tab-title").removeClass('active');
                // Show current
                $(this).addClass("active");
                $(target).addClass('active relative').removeClass('absolute cms-invisible hover');
            })
            .on('mouseenter', function(e){
                var target = $(this).data("target");
                //
                setTimeout(function() {
                   $(target).addClass('hover');
                }, 600);
            })
            .on('mouseleave', function(e){
                var target = $(this).data("target");
                $(target).removeClass('hover');
            });
            $(window).on('load resize', function() {
                if($(window).width() <= data_break) {
                    $scope.find(".cms-tab-title").addClass('active');
                    $scope.find('.cms-tabs-content').removeClass('active absolute cms-invisible').addClass('relative');
                } else {
                    $scope.find('.cms-tab-title:not([data-active="active"])').removeClass('active');
                    $scope.find('.cms-tabs-content:not([data-active="active"])').removeClass('active relative').addClass('absolute cms-invisible');
                }
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSTabsHandler);
        
        // CountDown
        var WidgetCMSCountDownHandler = function( $scope, $ ) {
            var countdown = $scope.find(".cms-countdown");
                countdown.each(function () {
                    var _this = $(this);
                    var count_down = $(this).find('> div').data("count-down");
                    setInterval(function () {
                        var startDateTime = new Date().getTime();
                        var endDateTime = new Date(count_down).getTime();
                        var distance = endDateTime - startDateTime;
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                        var text_day = days !== 1 ? _this.attr('data-days') : _this.attr('data-day');
                        var text_hour = hours !== 1 ? _this.attr('data-hours') : _this.attr('data-hour');
                        var text_minu = minutes !== 1 ? _this.attr('data-minutes') : _this.attr('data-minute');
                        var text_second = seconds !== 1 ? _this.attr('data-seconds') : _this.attr('data-second');
                        days = days < 10 ? '0' + days : days;
                        hours = hours < 10 ? '0' + hours : hours;
                        minutes = minutes < 10 ? '0' + minutes : minutes;
                        seconds = seconds < 10 ? '0' + seconds : seconds;

                        _this.html(''
                            + '<div class="countdown-item"><div class="countdown-item-inner"><div class="countdown-amount">' + days + '</div><div class="countdown-period">' + text_day + '</div></div></div>'
                            + '<div class="countdown-item"><div class="countdown-item-inner"><div class="countdown-amount">' + hours + '</div><div class="countdown-period">' + text_hour + '</div></div></div>'
                            + '<div class="countdown-item"><div class="countdown-item-inner"><div class="countdown-amount">' + minutes + '</div><div class="countdown-period">' + text_minu + '</div></div></div>'
                            + '<div class="countdown-item"><div class="countdown-item-inner"><div class="countdown-amount">' + seconds + '</div><div class="countdown-period">' + text_second + '</div></div></div>'
                        );
                    }, 100);
                });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSCountDownHandler);
        // CMS Text Scroll with Swiper
        var CMSTextScrollHandler = function($scope, $) {
            // Swiper Text Scroll
            const Swiper = elementorFrontend.utils.swiper,
                carousel = $scope.find(".cms-swiper-container"),
                carousel_settings = {
                    wrapperClass: 'cms-swiper-wrapper',
                    slideClass: 'cms-swiper-slide',
                    slidesPerView: 'auto',
                    centeredSlides: true,
                    spaceBetween: 10,
                    speed: 4000,
                    watchSlidesProgress: true,
                    watchSlidesVisibility: true,
                    autoplay: {
                        delay: 0,
                        pauseOnMouseEnter: false
                    },
                    loop: true,
                    navigation: false,
                    pagination: false
                };
            carousel.each(function(index, element) {
                var swiper = new Swiper(carousel, carousel_settings);
            });
            // Swiper Banner Scroll
            const banner_carousel = $scope.find(".cms-banner-swiper-container"),
                banner_carousel_settings = {
                    wrapperClass: 'cms-banner-swiper-wrapper',
                    slideClass: 'cms-swiper-slide',
                    effect: 'fade',
                    slidesPerView: 1,
                    centeredSlides: true,
                    spaceBetween: 10,
                    speed: 500,
                    watchSlidesProgress: true,
                    watchSlidesVisibility: true,
                    autoplay: {
                        delay: 2000,
                        pauseOnMouseEnter: false
                    },
                    loop: false,
                    navigation: false,
                    pagination: false
                };
            banner_carousel.each(function(index, element) {
                var swiper = new Swiper(banner_carousel, banner_carousel_settings);
            });
            
        };
        // Make sure you run this code under Elementor.
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_text_scroll.default', CMSTextScrollHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_video_player.default', CMSTextScrollHandler);
        // CMS Swiper Circle Scroll 
        var CMSSwiperCircularScrollHandler = function($scope, $) {
            const Swiper = elementorFrontend.utils.swiper,
                circular = $scope.find(".cms-swiper-circular"),
                circular_settings = {
                    wrapperClass: 'swiper-wrapper',
                    slideClass: 'swiper-slide',
                    loop: false,
                    centeredSlides: true,
                    mousewheel: true,
                    slidesPerView: 3,
                    effect: "creative",
                    creativeEffect: {
                        perspective: true,
                        limitProgress: 3,
                        prev: {
                            translate: ['-120%', '50%', 0],
                            rotate: [0, 0, -20],
                            origin: "bottom"
                        },
                        next: {
                            translate: ['120%', '50%', 0],
                            rotate: [0, 0, 20],
                            origin: "bottom"
                        },
                    },
                    mousewheelSensitivity: 1,
                    mousewheel: {
                        releaseOnEdges: true
                    }
                };
            circular.each(function(index, element) {
                var swiper = new Swiper(circular, circular_settings);
            });
        };
        // Make sure you run this code under Elementor.
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_process.default', CMSSwiperCircularScrollHandler);

        // CMS Progress Bar
        var WidgetCMSProgressBarHandler = function($scope, $) {
            elementorFrontend.waypoint($scope.find('.cms-progress-bar-wrap'), function() {
                var $progressbar_w = $(this).find('.cms-progress-bar-w'),
                    $progressbar_h = $(this).find('.cms-progress-bar-h');
                $progressbar_w.css('width', $progressbar_w.data('width') + '%');
                $progressbar_h.css('height', $progressbar_h.data('height') + 'px');

                var $number = $(this).find('.cms-progress-bar-number'),
                    data = $number.data(),
                    decimalDigits = data.toValue.toString().match(/\.(.*)/);
                if (decimalDigits) {
                    data.rounding = decimalDigits[1].length;
                }
                $number.numerator(data);
            });
        };
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSProgressBarHandler);
        // CMS Image Cursor
        var WidgetCMSPointerImageCursor = function ($scope, $){
            var $links            = $scope.find( '.cms-img-cursor' ),
                x                 = 0,
                y                 = 0,
                currentXCPosition = 0,
                currentYCPosition = 0;

            if ( $links.length ) {
                $links.on(
                    'mouseenter',
                    function () {
                        $links.removeClass( 'cms--active' );
                        $( this ).addClass( 'cms--active' );
                    }
                ).on(
                    'mousemove',
                    function ( event ) {
                        var $thisLink         = $( this ),
                            $followInfoHolder = $thisLink.find( '.cms-cursor-pointer' ),
                            $followImage      = $followInfoHolder.find( '.cms-cursor--pointer' ),
                            $followImageItem  = $followImage.find( 'img' ),
                            followImageWidth  = $followImageItem.width(),
                            followImagesCount = parseInt( $followImage.data( 'images-count' ), 10 ),
                            followImagesSrc   = $followImage.data( 'images' ),
                            $followTitle      = $followInfoHolder.find( '.cms-cursor--title' ),
                            itemWidth         = $thisLink.outerWidth(),
                            itemHeight        = $thisLink.outerHeight(),
                            itemOffsetTop     = $thisLink.offset().top - $( window ).scrollTop(),
                            itemOffsetLeft    = $thisLink.offset().left;
                        x = (event.clientX - itemOffsetLeft) >> 0;
                        y = (event.clientY - itemOffsetTop) >> 0;

                        if ( x > itemWidth ) {
                            currentXCPosition = itemWidth;
                        } else if ( x < 0 ) {
                            currentXCPosition = 0;
                        } else {
                            currentXCPosition = x;
                        }

                        if ( y > itemHeight ) {
                            currentYCPosition = itemHeight;
                        } else if ( y < 0 ) {
                            currentYCPosition = 0;
                        } else {
                            currentYCPosition = y;
                        }

                        if ( followImagesCount > 1 ) {
                            var imagesUrl    = followImagesSrc.split( '|' ),
                                itemPartSize = itemWidth / followImagesCount;

                            $followImageItem.removeAttr( 'srcset' );

                            if ( currentXCPosition < itemPartSize ) {
                                $followImageItem.attr( 'src', imagesUrl[0] );
                            }

                            // -2 is constant - to remove first and last item from the loop
                            for ( var index = 1; index <= (followImagesCount - 2); index++ ) {
                                if ( currentXCPosition >= itemPartSize * index && currentXCPosition < itemPartSize * (index + 1) ) {
                                    $followImageItem.attr( 'src', imagesUrl[index] );
                                }
                            }

                            if ( currentXCPosition >= itemWidth - itemPartSize ) {
                                $followImageItem.attr( 'src', imagesUrl[followImagesCount - 1] );
                            }
                        }

                        $followImage.css(
                            {
                                'top': itemHeight / 2,
                            }
                        );
                        $followTitle.css(
                            {
                                'transform': 'translateY(' + -(parseInt( itemHeight, 10 ) / 2 + currentYCPosition) + 'px)',
                                'left': -(currentXCPosition - followImageWidth / 2),
                            }
                        );
                        $followInfoHolder.css( { 'top': currentYCPosition, 'left': currentXCPosition } );
                    }
                ).on(
                    'mouseleave',
                    function () {
                        $links.removeClass( 'cms--active' );
                    }
                );
            }
        }
        elementorFrontend.hooks.addAction('frontend/element_ready/global', WidgetCMSPointerImageCursor);
        // Parallax
        var CMSParallax = function ($scope, $){
            var $items = $scope.find( '.cms-parallax' ),
                parallaxInstances = $('[data-parallax]');
            if ( parallaxInstances.length && typeof ParallaxScroll === 'object' ) {
                ParallaxScroll.init(); //initialization removed from plugin js file to have it run only on non-touch devices
            }
        }
        elementorFrontend.hooks.addAction('frontend/element_ready/global', CMSParallax);
    });
}(jQuery));


