(function($) {
    var WidgetCMSProcessSlider = function($scope, $) {
        let els = $scope.find('.cms-eprocess-slider');
        const fromTop = 350;
        const toTop = -295;
        $.each(els, (i, el) => {
            el = $(el);
            el.find('.cms-slider-process').hide();
            el.find('.cms-slider-process').first().show();
            el.find('.count').hide();
            el.find('.count').first().show();
            scaleBackground(el);

            el.scroller({
                sensitivity: 0,
                callback: event => {
                    let { $element, isInViewport, isDisappearing, intersectionScrollDirection, scrollPercentage } = event;
                    if (isInViewport) {
                        $element.scroller('onWindowScroll');
                        $element.scroller('onWindowResize');
                    } else {
                        $element.scroller('offWindowScroll');
                        $element.scroller('offWindowResize');
                    }
                },
                onWindowScroll: () => {
                    setProcesses(el);
                    scaleBackground(el);
                },
                onWindowResize: () => {
                    setProcesses(el);
                    scaleBackground(el);
                },
            });
        });

        function getProcessing(el) {
            el = $(el);
            if (el.length == 0) {
                return false;
            }

            const elOffset = el[0].getBoundingClientRect();
            let processing = 0;
            if (elOffset.top > fromTop) {
                processing = 0;
            } else if (elOffset.top <= fromTop && elOffset.top >= toTop) {
                if (elOffset.top >= 0) {
                    processing = (fromTop - elOffset.top) / (fromTop + Math.abs(toTop)) * 100;
                } else {
                    processing = (Math.abs(elOffset.top) + fromTop) / (fromTop + Math.abs(toTop)) * 100;
                }
            } else {
                processing = 100;
            }



            return processing;
        }

        function setProcess(items, processing, callback) {
            items = $(items);
            $.each(items, function(index, item) {
                item = $(item);
                if (index == 0) {
                    if (processing >= 100 / items.length) {
                        item.fadeOut();
                    } else {
                        item.fadeIn();
                    }
                } else if (index == items.length - 1) {
                    if (processing > 100 / items.length * index) {
                        item.fadeIn();
                    } else {
                        item.fadeOut();
                    }
                } else {
                    if (processing > 100 / items.length * index && processing <= 100 / items.length * (index + 1)) {
                        item.fadeIn();
                    } else {
                        item.fadeOut();
                    }
                }
            });
            if (typeof callback == 'function') {
                callback(items, processing);
            }
        }

        function setProcesses(el) {
            let bgItems = el.find('.cms-bg-cover');
            let textItems = el.find('.cms-slider-process');
            let numberItems = el.find('.count');

            let processing = getProcessing(el);
            setProcess(bgItems, processing, scaleBackground);
            setProcess(textItems, processing);
            setProcess(numberItems, processing);
        }

        function scaleBackground(el) {
            let bg = el.find('.cms-bg-cover');
            let processing = getProcessing(el);
            const offset = 50;
            bg.css('left', `${(100 - processing) / 100 * offset}px`);
            bg.css('right', `${(100 - processing) / 100 * offset}px`);
        }
    };
    // Make sure you run this code under Elementor.
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_process_slider.default', WidgetCMSProcessSlider);
    });
})(jQuery);