(function($) {
    /**
     * @param $scope The Widget wrapper element as a jQuery element
     * @param $ The jQuery alias
     */
    var WidgetCMSHoverHandler = function( $scope, $ ) {
            //
            $scope.find(".cms-hover").on("click touch mouseenter", function(e){
                e.preventDefault();
                var target = $(this).data("target");
                var parent = $(this).parents(".cms-hovers");
                // hide all
                parent.find(".cms-hover-content").removeClass('active').addClass('absolute cms-invisible');
                parent.find(".cms-hover").removeClass('active');
                // Show current
                $(this).addClass("active");
                $('#'+target).addClass('active relative').removeClass('absolute cms-invisible hover');
            })
            .on('mouseenter', function(e){
                var target = $(this).data("target");
                //
                $('#'+target).addClass('hover');
            })
            .on('mouseleave', function(e){
                var target = $(this).data("target");
                $('#'+target).removeClass('active relative hover').addClass('absolute cms-invisible');
            });
            $(window).on('load resize', function() {
                if($(window).width() <= 767) {
                    $scope.find(".cms-hover").addClass('active');
                    $scope.find('.cms-hover-content').removeClass('active absolute cms-invisible').addClass('relative');
                } else {
                    $scope.find('.cms-hover:not([data-active="active"])').removeClass('active');
                }
            });
        };

    // Make sure you run this code under Elementor.
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_theme_teams.default', WidgetCMSHoverHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_case_grid.default', WidgetCMSHoverHandler);
    });
})(jQuery);