( function( $ ) {
    /**
     * @param $scope The Widget wrapper element as a jQuery element
     * @param $ The jQuery alias
     */
    var WidgetCMSScrollSlide = function( $scope, $ ) {
        gsap.registerPlugin(ScrollTrigger);
        gsap.defaults({overwrite: 'auto'});
        var cmssroller     = $scope.find(".cms-scroller"),
            sections_right = $scope.find(".cms-sroller-item-right"),
            slides_right   = $scope.find(".fromRight"),
            slides_left    = $scope.find(".fromLeft"),
            slides_scale   = $scope.find(".scaleUp"),
            _xPercent      = cmssroller.data('percent'),
            innerHeight    = cmssroller.innerHeight();
        // Scroll Slide
        gsap.timeline({ 
            scrollTrigger: { 
                trigger: cmssroller, 
                pin: true, 
                scrub: true, 
                start: "top top", 
                end: "+="+(sections_right.length-1)*innerHeight,
                //offset: 50
            }
        }).to(slides_right, {
            xPercent: -100,
            duration: 2,  
            ease: "none", 
            stagger: 3
        }).to(slides_left, {
            xPercent: 100,
            duration: 2,  
            ease: "none", 
            stagger: 3
        }).to(slides_scale, {
            //xPercent: 100,
            //transform: '50% 50%',
            scale:1,
            duration: 2,  
            ease: "none", 
            stagger: 3
        });
    };
    // Make sure you run this code under Elementor.
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/cms_theme_process_sticky.default', WidgetCMSScrollSlide );
    });
} )( jQuery );